/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.util;

import java.util.Hashtable;
import java.util.Map;

public class TypedHashtable
extends Hashtable {
    public TypedHashtable() {
    }

    public TypedHashtable(int initialCapacity) {
        super(initialCapacity);
    }

    public TypedHashtable(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TypedHashtable(Map t) {
        super(t);
    }

    public void put(Object key, boolean value) {
        Boolean b = value ? Boolean.TRUE : Boolean.FALSE;
        this.put(key, b);
    }

    public void put(Object key, byte value) {
        this.put(key, new Byte(value));
    }

    public void put(Object key, short value) {
        this.put(key, new Short(value));
    }

    public void put(Object key, int value) {
        this.put(key, new Integer(value));
    }

    public void put(Object key, long value) {
        this.put(key, new Long(value));
    }

    public void put(Object key, float value) {
        this.put(key, new Float(value));
    }

    public void put(Object key, double value) {
        this.put(key, new Double(value));
    }

    public void put(Object key, char value) {
        this.put(key, new Character(value));
    }

    public Object put(Object key, Object value) {
        if (value == null) {
            return super.remove(key);
        }
        return super.put(key, value);
    }

    public boolean get(Object key, boolean defaultValue) {
        Object obj = this.get(key);
        return obj instanceof Boolean ? defaultValue : (Boolean)obj;
    }

    public byte get(Object key, byte defaultValue) {
        Object obj = this.get(key);
        return obj instanceof Byte ? defaultValue : (Byte)obj;
    }

    public short get(Object key, short defaultValue) {
        Object obj = this.get(key);
        return obj instanceof Short ? defaultValue : (Short)obj;
    }

    public int get(Object key, int defaultValue) {
        Object obj = this.get(key);
        return obj instanceof Integer ? defaultValue : (Integer)obj;
    }

    public long get(Object key, long defaultValue) {
        Object obj = this.get(key);
        return obj instanceof Long ? defaultValue : (Long)obj;
    }

    public float get(Object key, float defaultValue) {
        Object obj = this.get(key);
        return obj instanceof Float ? defaultValue : ((Float)obj).floatValue();
    }

    public double get(Object key, double defaultValue) {
        Object obj = this.get(key);
        return obj instanceof Double ? defaultValue : (Double)obj;
    }

    public char get(Object key, char defaultValue) {
        Object obj = this.get(key);
        return obj instanceof Character ? defaultValue : ((Character)obj).charValue();
    }

    public String getString(Object key) {
        return (String)this.get(key);
    }

    public Boolean getBoolean(Object key) {
        return (Boolean)this.get(key);
    }

    public Byte getByte(Object key) {
        return (Byte)this.get(key);
    }

    public Short getShort(Object key) {
        return (Short)this.get(key);
    }

    public Integer getInt(Object key) {
        return (Integer)this.get(key);
    }

    public Long getLong(Object key) {
        return (Long)this.get(key);
    }

    public Float getFloat(Object key) {
        return (Float)this.get(key);
    }

    public Double getDouble(Object key) {
        return (Double)this.get(key);
    }

    public Character getChar(Object key) {
        return (Character)this.get(key);
    }
}

