/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.html;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gradle.internal.xml.SimpleMarkupWriter;
import org.gradle.util.internal.TextUtil;

public class SimpleHtmlWriter
extends SimpleMarkupWriter {
    private static final Set<String> VALID_HTML_TAGS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("html", "head", "meta", "title", "link", "script", "body", "h1", "h2", "h3", "h4", "h5", "table", "thead", "tbody", "th", "td", "tr", "ul", "li", "a", "p", "pre", "div", "span", "label", "input")));

    public SimpleHtmlWriter(Writer writer) throws IOException {
        this(writer, null);
    }

    public SimpleHtmlWriter(Writer writer, String indent) throws IOException {
        super(writer, indent);
        this.writeHtmlHeader();
    }

    private void writeHtmlHeader() throws IOException {
        this.writeRaw("<!DOCTYPE html>");
    }

    @Override
    public SimpleMarkupWriter startElement(String name) throws IOException {
        if (!SimpleHtmlWriter.isValidHtmlTag(name)) {
            throw new IllegalArgumentException(String.format("Invalid HTML tag: '%s'", name));
        }
        return super.startElement(name);
    }

    private static boolean isValidHtmlTag(String name) {
        return VALID_HTML_TAGS.contains(TextUtil.toLowerCaseLocaleSafe((String)name));
    }
}

