/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.impl.services;

import java.io.File;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheLockingAccessCoordinator;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.internal.Factory;
import org.gradle.internal.cc.impl.initialization.ConfigurationCacheStartParameter;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.cached.CachedExternalResource;
import org.gradle.internal.resource.cached.CachedExternalResourceIndex;
import org.gradle.internal.resource.cached.ExternalResourceFileStore;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.metadata.ExternalResourceMetaDataCompare;
import org.gradle.internal.resource.transfer.AccessorBackedExternalResource;
import org.gradle.internal.resource.transfer.DownloadAction;
import org.gradle.internal.resource.transfer.ExternalResourceConnector;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ServiceScope(value={Scope.BuildTree.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/gradle/internal/cc/impl/services/RemoteScriptUpToDateChecker;", "", "lockingAccessCoordinator", "Lorg/gradle/api/internal/artifacts/ivyservice/ArtifactCacheLockingAccessCoordinator;", "startParameter", "Lorg/gradle/internal/cc/impl/initialization/ConfigurationCacheStartParameter;", "temporaryFileProvider", "Lorg/gradle/api/internal/file/temp/TemporaryFileProvider;", "externalResourceFileStore", "Lorg/gradle/internal/resource/cached/ExternalResourceFileStore;", "externalResourceConnector", "Lorg/gradle/internal/resource/transfer/ExternalResourceConnector;", "cachedExternalResourceIndex", "Lorg/gradle/internal/resource/cached/CachedExternalResourceIndex;", "", "(Lorg/gradle/api/internal/artifacts/ivyservice/ArtifactCacheLockingAccessCoordinator;Lorg/gradle/internal/cc/impl/initialization/ConfigurationCacheStartParameter;Lorg/gradle/api/internal/file/temp/TemporaryFileProvider;Lorg/gradle/internal/resource/cached/ExternalResourceFileStore;Lorg/gradle/internal/resource/transfer/ExternalResourceConnector;Lorg/gradle/internal/resource/cached/CachedExternalResourceIndex;)V", "isUpToDate", "", "uri", "Ljava/net/URI;", "configuration-cache"})
public final class RemoteScriptUpToDateChecker {
    @NotNull
    private final ArtifactCacheLockingAccessCoordinator lockingAccessCoordinator;
    @NotNull
    private final ConfigurationCacheStartParameter startParameter;
    @NotNull
    private final TemporaryFileProvider temporaryFileProvider;
    @NotNull
    private final ExternalResourceFileStore externalResourceFileStore;
    @NotNull
    private final ExternalResourceConnector externalResourceConnector;
    @NotNull
    private final CachedExternalResourceIndex<String> cachedExternalResourceIndex;

    public RemoteScriptUpToDateChecker(@NotNull ArtifactCacheLockingAccessCoordinator lockingAccessCoordinator, @NotNull ConfigurationCacheStartParameter startParameter, @NotNull TemporaryFileProvider temporaryFileProvider, @NotNull ExternalResourceFileStore externalResourceFileStore, @NotNull ExternalResourceConnector externalResourceConnector, @NotNull CachedExternalResourceIndex<String> cachedExternalResourceIndex) {
        Intrinsics.checkNotNullParameter((Object)lockingAccessCoordinator, (String)"lockingAccessCoordinator");
        Intrinsics.checkNotNullParameter((Object)startParameter, (String)"startParameter");
        Intrinsics.checkNotNullParameter((Object)temporaryFileProvider, (String)"temporaryFileProvider");
        Intrinsics.checkNotNullParameter((Object)externalResourceFileStore, (String)"externalResourceFileStore");
        Intrinsics.checkNotNullParameter((Object)externalResourceConnector, (String)"externalResourceConnector");
        Intrinsics.checkNotNullParameter(cachedExternalResourceIndex, (String)"cachedExternalResourceIndex");
        this.lockingAccessCoordinator = lockingAccessCoordinator;
        this.startParameter = startParameter;
        this.temporaryFileProvider = temporaryFileProvider;
        this.externalResourceFileStore = externalResourceFileStore;
        this.externalResourceConnector = externalResourceConnector;
        this.cachedExternalResourceIndex = cachedExternalResourceIndex;
    }

    public final boolean isUpToDate(@NotNull URI uri) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (this.startParameter.isOffline()) {
            bl = true;
        } else {
            ExternalResourceName externalResourceName = new ExternalResourceName(uri);
            CachedExternalResource cached = this.cachedExternalResourceIndex.lookup((Object)externalResourceName.toString());
            ExternalResourceMetaData remoteMetaData = this.externalResourceConnector.getMetaData(externalResourceName, true);
            if (cached != null && ExternalResourceMetaDataCompare.isDefinitelyUnchanged((ExternalResourceMetaData)cached.getExternalResourceMetaData(), (Factory)new Factory(remoteMetaData){
                final /* synthetic */ ExternalResourceMetaData $remoteMetaData;
                {
                    this.$remoteMetaData = $remoteMetaData;
                }

                @Nullable
                public final ExternalResourceMetaData create() {
                    return this.$remoteMetaData;
                }
            })) {
                this.cachedExternalResourceIndex.store((Object)externalResourceName.toString(), cached.getCachedFile(), cached.getExternalResourceMetaData());
                bl = true;
            } else {
                AccessorBackedExternalResource externalResource = new AccessorBackedExternalResource(externalResourceName, this.externalResourceConnector, true);
                DownloadAction downloadAction = new DownloadAction(externalResourceName, this.temporaryFileProvider, null);
                externalResource.withContentIfPresent((ExternalResource.ContentAndMetadataAction)downloadAction);
                this.lockingAccessCoordinator.useCache(new Runnable(this, externalResource, downloadAction, externalResourceName){
                    final /* synthetic */ RemoteScriptUpToDateChecker this$0;
                    final /* synthetic */ AccessorBackedExternalResource $externalResource;
                    final /* synthetic */ DownloadAction $downloadAction;
                    final /* synthetic */ ExternalResourceName $externalResourceName;
                    {
                        this.this$0 = $receiver;
                        this.$externalResource = $externalResource;
                        this.$downloadAction = $downloadAction;
                        this.$externalResourceName = $externalResourceName;
                    }

                    public final void run() {
                        LocallyAvailableResource cachedResource = RemoteScriptUpToDateChecker.access$getExternalResourceFileStore$p(this.this$0).move((Object)this.$externalResource.toString(), this.$downloadAction.getDestination());
                        File fileInFileStore = cachedResource.getFile();
                        RemoteScriptUpToDateChecker.access$getCachedExternalResourceIndex$p(this.this$0).store((Object)this.$externalResourceName.toString(), fileInFileStore, this.$downloadAction.getMetaData());
                    }
                });
                bl = false;
            }
        }
        return bl;
    }

    public static final /* synthetic */ ExternalResourceFileStore access$getExternalResourceFileStore$p(RemoteScriptUpToDateChecker $this) {
        return $this.externalResourceFileStore;
    }

    public static final /* synthetic */ CachedExternalResourceIndex access$getCachedExternalResourceIndex$p(RemoteScriptUpToDateChecker $this) {
        return $this.cachedExternalResourceIndex;
    }
}

