/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import org.apache.commons.math3.stat.StatUtils;
import org.broad.igv.ui.AbstractDataPanelTool;
import org.broad.igv.ui.panel.DataPanel;
import org.broad.igv.ui.panel.ReferenceFrame;

public class PanTool
extends AbstractDataPanelTool {
    private static int throttleTimeMS = 50;
    private static double[] repaintTimes = new double[100];
    private static int repaintTimeCount = 0;
    private int previousYDirection = 0;
    private int cumulativeDeltaX;
    private int cumulativeDeltaY;
    private Point lastMousePoint;
    private JScrollBar verticalScrollBar;
    private boolean isDragging = false;
    private long lastDragEventTime = 0L;
    private ReferenceFrame referenceFrame;

    public PanTool(DataPanel owner) {
        super(owner, Cursor.getDefaultCursor());
        this.setName("Pan");
        if (owner != null) {
            Container parentOfParent;
            this.verticalScrollBar = owner.getVerticalScrollbar();
            Container parentContainer = owner.getParent();
            if (parentContainer == null || (parentOfParent = parentContainer.getParent()) == null || parentOfParent instanceof JViewport) {
                // empty if block
            }
        }
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getDefaultCursor();
    }

    public Point getLastMousePoint() {
        return this.lastMousePoint;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            return;
        }
        this.lastMousePoint = e.getPoint();
        this.cumulativeDeltaX = 0;
        this.cumulativeDeltaY = 0;
    }

    public void setReferenceFrame(ReferenceFrame frame) {
        this.referenceFrame = frame;
    }

    @Override
    public ReferenceFrame getReferenceFame() {
        if (this.referenceFrame != null) {
            return this.referenceFrame;
        }
        return super.getReferenceFame();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.isDragging) {
            this.isDragging = false;
            this.lastDragEventTime = 0L;
            this.getReferenceFame().dragStopped();
        }
        Component panel = (Component)e.getSource();
        panel.setCursor(this.getCursor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void mouseDragged(MouseEvent e) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastDragEventTime < (long)throttleTimeMS) {
            return;
        }
        this.lastDragEventTime = currentTime;
        try {
            Component panel = (Component)e.getSource();
            if (this.lastMousePoint == null) {
                this.lastMousePoint = e.getPoint();
                return;
            }
            if (!this.isDragging && e.getPoint().distance(this.lastMousePoint) < 2.0) {
                return;
            }
            this.isDragging = true;
            int deltaX = this.lastMousePoint.x - e.getX();
            int deltaY = this.lastMousePoint.y - e.getY();
            this.cumulativeDeltaX += Math.abs(deltaX);
            this.cumulativeDeltaY += Math.abs(deltaY);
            if (this.cumulativeDeltaX > this.cumulativeDeltaY) {
                this.getReferenceFame().shiftOriginPixels(deltaX);
            } else {
                int totalYChange = (int)(this.lastMousePoint.getY() - (double)e.getY());
                if (totalYChange != 0) {
                    int currentYDirection = 0;
                    currentYDirection = totalYChange / Math.abs(totalYChange);
                    if (this.previousYDirection != 0) {
                        boolean changedYDirection;
                        boolean bl = changedYDirection = currentYDirection != this.previousYDirection;
                        if (!changedYDirection) {
                            this.previousYDirection = currentYDirection;
                            if (this.verticalScrollBar != null) {
                                int adjustedScrollbarValue = this.verticalScrollBar.getValue();
                                this.verticalScrollBar.setValue(adjustedScrollbarValue += totalYChange);
                            }
                        }
                    }
                    this.previousYDirection = currentYDirection;
                }
            }
        }
        finally {
            this.lastMousePoint = e.getPoint();
        }
    }

    public static void repaintTime(double t) {
        PanTool.repaintTimes[PanTool.repaintTimeCount++] = t;
        if (repaintTimeCount == repaintTimes.length) {
            double p = StatUtils.percentile((double[])repaintTimes, (double)95.0);
            throttleTimeMS = Math.max(5, Math.min(200, (int)p));
            repaintTimeCount = 0;
        }
    }
}

