/*
 * Decompiled with CFR 0.152.
 */
package free.chess;

import free.chess.Player;

public abstract class Piece {
    public static final int WHITE = 1;
    public static final int BLACK = -1;
    protected final int val;

    protected Piece(int n, int n2) {
        switch (n) {
            case -1: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown color constant: " + n);
            }
        }
        if (n2 == 0) {
            throw new IllegalArgumentException("Piece type may not be 0");
        }
        this.val = n * n2;
    }

    public boolean isOppositeColor(Piece piece) {
        return this.getColor() != piece.getColor();
    }

    public boolean isSameColor(Piece piece) {
        return this.getColor() == piece.getColor();
    }

    public Player getPlayer() {
        if (this.isWhite()) {
            return Player.WHITE_PLAYER;
        }
        return Player.BLACK_PLAYER;
    }

    public int getColor() {
        return this.val < 0 ? -1 : 1;
    }

    public boolean isWhite() {
        return this.val > 0;
    }

    public boolean isBlack() {
        return this.val < 0;
    }

    public abstract String toShortString();

    public String toShortColorString() {
        if (this.isWhite()) {
            return this.toShortString().toUpperCase();
        }
        return this.toShortString().toLowerCase();
    }

    public String getColorName() {
        if (this.isWhite()) {
            return "White";
        }
        if (this.isBlack()) {
            return "Black";
        }
        throw new Error("This may never happen");
    }

    public abstract String getTypeName();

    public String toString() {
        return this.getColorName() + ' ' + this.getTypeName();
    }

    public int hashCode() {
        return this.val;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        return this.val == ((Piece)object).val;
    }
}

