
(defmeth residual-plot-proto :plot-help ()
  (plot-help-window (strcat "Help for " (send self :title)))
  (paste-plot-help (format nil 
"The residuals plot is a plot of the residuals versus the predicted values of the response variable.~2%"))
  (paste-plot-help (format nil 
"The residuals plot is a regression diagnostic plot: It helps diagonse the suitability of the assumptions underlying regression analysis to the data being analyzed. Residual plots may be used to detect nonnormal error distributions, constant error variance (heteroscedasticity), nonlinearity and outliers.~2%"))
  (paste-plot-help (format nil 
"NORMALITY: The points in the plot should be randomly distributed about the zero line. If they are not, then the assumption of normality has probably not been met.~2%"))
  (paste-plot-help (format nil 
"LINEARITY: Points that form a systematic pattern, such as a curve, suggest that the assumption of linearity has been violated.~2%"))
  (paste-plot-help  (format nil "HETEROSCADASTICITY: The variance of the residuals should be about the same for all values of the predicted response variable. If the variance changes systematically with the response variable, then the assumption of constant error variance has not been met.~2%"))
  (paste-plot-help  (format nil "OUTLIERS: Outliers may be identified by examining observations which have residuals that are much larger than the rest of the residual values.~2%"))
  (paste-plot-help (format nil "Clicking the Y button reveals that you have a choice of OLS (ordinary least squares), Bayes OLS, and Standardized OLS residuals. These are defined as follows:~%"))
  (paste-plot-help (format nil "  1: OLS RESIDUALS are the difference between the predicted response and the observed response.~%  2: STANDARDIZED RESIDUALS are the OLS values standardized to have a variance of 1. These are also known as STUDENTIZED residuals.~%  3: BAYES RESIDUALS are the standardized values with error bars added. The bars represent the mean plus or minus 2 times a Bayesian standard error (see Tierney, 1990). They cover a range of values within which we would roughly expect to find the residual 95% of the time.~2%"))
  (let ((mod (send (send self :spreadplot-supervisor) :model))
        )
    (cond
      ((equalp (send mod :method) "Monotonic")
       (paste-plot-help (format nil "In addition, you have the choice of looking at the three types of residuals for the monotonically transformed response variable.")))
      ((equalp (send mod :method) "Robust")
       (paste-plot-help (format nil "In addition, you have the choice of looking at these three types of residuals for the robust analysis.")))
      ))
  (show-plot-help)
  )

(defmeth influence-plot-proto :plot-help ()
  (let ((title (send self :title))
        (method (send (send (send self :spreadplot-supervisor) :model) :method)))
    (plot-help-window (strcat "Help for " title))
    (paste-plot-help (format nil "The ~a plot is a regression diagnostic plot: It helps diagnose the stability of the regression analysis. The plot may be used to determine the influence of a particular observation on the regression parameter estimates.~2%" title))
    (when (equal title "Leverage and Influence")
          (paste-plot-help (format nil "The Leverage and Influence plot presents two kinds of regression diagonostics. By clicking on the Y button you can view either the Leverage plot or the Influence plot. "))
          (cond
            ((equal method "Monotonic")
             (paste-plot-help (format nil "For this monotonic regression you have the choice of OLS (ordinary least squares) or Monotonic leverages and influence plots.~2%")))
            ((equal method "Robust")
             (paste-plot-help (format nil "For this robust regression you have the choice of OLS (ordinary least squares) or Robust leverages and influence plots.~2%")))
            (t paste-plot-help (format nil "~2%"))
            ))
    (when (equal title "Leverage and Influence")
          (paste-plot-help (format nil "LEVERAGE PLOT:~%")))
    (when (or (equal title "Leverage")
              (equal title "Leverage and Influence"))
          (paste-plot-help (format nil "The leverage plot, which displays leverages vs. predicted response values, shows the effect on the predicted response values of changing an individual response value by 1 unit. A large leverage suggests that the observation has a large influence on the calculation of the parameter estimates: Small changes in the observation will have relatively large effects on the parameter estimates. If such an observation is not reliable, then the model is also not reliable and we do not have stable estimates of the parameters.~2%"))
          (paste-plot-help (format nil "Note that observations with large leverages are not outliers. The position of the regression curve is heavily influenced by observations that are extreme in their value on the predictor variable. Because influential observations draw the regression line toward themselves, we cannot always spot them by looking for large residuals.~2%")))
    (when (equal title "Leverage and Influence")
          (paste-plot-help (format nil "INFLUENCE PLOT:~%")))
    (when (or (equal title "Influence")
              (equal title "Leverage and Influence"))
          (paste-plot-help (format nil "The Influence plot shows the effect, on the values of the predicted response variable, of removing an individual observation. The plot uses Cook's distance measure, a measure which determines the influence of removing an observation by estimating the difference between the regression coefficients calculated when the observation is included in the analysis and when it is omitted from the analysis.~2%"))
          (paste-plot-help (format nil "A large Cook's distance suggests that the observation has a large influence on the calculation of the parameter estimates: Small changes in the observation will have relatively large effects on the parameter estimates. If such an observation is not reliable, then the model is also not reliable and we do not have stable estimates of the parameters.")))
    (when (or (equal method "Monotonic")
              (equal method "Robust"))
          (paste-plot-help (format nil "~2%For this ~a regression, the ~a measures differ as to whether the ~a data or the raw data are used in the calculation of the measure." method method (if (equal method "Robust") "weighted" "transformed"))))
    (show-plot-help)))

(defmeth LSMT-PLOT-PROTO :plot-help ()
  (plot-help-window (strcat "Help for " (send self :title)))
  (cond
    ((equal (send self :title) "Fit")
     (paste-plot-help (format nil "THE ITER BUTTON:~%Use the ITER button to do Robust or Monotone Regression iterations. When you click on the button you will see a dialog box that lets you choose which type of analysis you wish to do, and to specify details of the analysis iterations.~2%"))
     (paste-plot-help (format nil "THE PLOT:~%The Fit plot is a plot of the predicted values of the response variable versus the observed values of the response variable. The line through the plot represents perfect fit.~2%To the extent that the points deviate vertically from this line the predicted values are not fitting the actual observed response variable well. These vertical deviations are the residuals that are being minimized. The greater the deviation (residuals), the worse the fit.~2%")))
    (t
     (paste-plot-help (format nil "THE ITER BUTTON:~%Use the ITER button to perform another iteration of the monotone regression algorithm. Each time you click the button, one more iteration is performed. The iterations should be performed until the squared multiple correlation, and estimates of the Beta (regression) weights have become stable. The Squared Correlation and Betas are shown in the RSquare and Betas plot.~2%"))
     (paste-plot-help (format nil "THE PLOT:~%The Fit and Transformation plot displays three kinds of information.~2%"))
     (paste-plot-help (format nil "  1: The broken red line is the monotonic transformation of the response variable. This transformation is computed iteratively to optimize the fit of the linear combination of predictor variables to the monotonically transformed response variable. The transformation attempts to linearize the relationship of the predictors to the response as much as possible.~2%"))
     (paste-plot-help (format nil "  2: The points are a plot of the predicted values of the monotonically transformed response variable versus the untransformed (observed) values of the response variable. The iterations calculate a monotonic transformation of the response variable which attempts to make the scatter of points be as close as possible to the monotonic transformation (the broken red line). Vertical deviations of the points from the broken red represent lack of fit to the monotonically transformed response variable. These vertical deviations are the residuals that are being minimized. The greater the deviation (residuals), the worse the fit.~2%"))
     (paste-plot-help (format nil "  3: The straight line through the plot represents the OLS linear transformation. When the monotonic transformation departs systematically from the straight line, the monotonic transformation is accounting for systematic depatures from linearity in the relationship of the predictor variables to the response variable."))
     ))
  (show-plot-help))

(defmeth robust-reg-plot-proto :plot-help ()
  (plot-help-window (strcat "Help for " (send self :title)))
(paste-plot-help (format nil "THE ITER BUTTON:~%Use the ITER button to perform another iteration of the robust regression algorithm. Each time you click the button, one more iteration is performed. The iterations should be performed until the estimates of the weights have become stable.  The weights are shown in the Robust Weights plot.~2%"))
  (paste-plot-help (format nil "THE PLOT:~2%The Robust Fit plot is a plot of the predicted values of the response variable versus the observed values of the response variable. The line through the plot represents perfect fit. To the extent that the points deviate vertically from this line the predicted values are not fitting the actual observed response variable well. These vertical deviations are the residuals that are being minimized. The greater the deviation (residuals), the worse the fit.~2%For the robust analysis, the large deviations are being given small weight. Thus, observations with large residuals do not contribute greatly to the overall robust regression analysis.~2%"))
  (show-plot-help))

(defmeth robust-plot-proto :plot-help ()
  (plot-help-window (strcat "Help for " (send self :title)))
  (paste-plot-help (format nil "The Robust Weights plot shows the observation weights that are calculated on each iteration during the iterative process underlying the robust regression analysis.~2%The goal of the iterations is to de-emphasize observations that have large OLS residuals. This is done by giving them low weight. Thus, observations with large residuals do not contribute greatly to the overall robust regression analysis.~2%The iterations should be performed until the estimates of the weights have become stable."))
  (show-plot-help))

(defmeth rsq-plot-proto :plot-help ()
  (plot-help-window (strcat "Help for " (send self :title)))
  (paste-plot-help (format nil "The RSquare and Betas plot shows the squared multiple correlation coefficient and the beta (regression) weights for the monotonic regression on each iteration of the analysis. The weights are for the predictor variables. They control the contribution of the predictor variables to the prediction of the monotonically transformed response variable.~2%The iterative algorithm attempts to maximize the squared multiple correlation by re-estimating the weights and re-transforming the response variable on each iteration. The iterative process has reached a stable solution when the RSq curve reaches asymptote and the Beta curves become stable."))
  (show-plot-help))

(defmeth added-var-plot-proto :plot-help ()
  (plot-help-window (strcat "Help for " (send self :title)))
  (let* ((model (send (send self :spreadplot-supervisor) :model))
         (method (send model :method))
         (simple-reg (send model :simple-reg)))
    (cond
      (simple-reg
       (paste-plot-help (format nil "For simple regression, the regression plot displays the relationship between the response variable and the predictor. This relationship is represented by the scatter of points, and it is summarized by the straight line, which is the regression line. The slope and intercept of this line are the parameter estimates computed by the analysis.~2%"))
       (paste-plot-help (format nil "If the scatter of points displays a linear relationship, then the assumption of linearity is satisfied for the analysis.")))
      (t
       (paste-plot-help (format nil "The regression plot for multiple regression (also known as an Added Variables plot) displays the relationship between the ~a variable and one of the predictors, with all of the other predictor variables removed from the picture. This relationship is represented by the scatter of points.~2%" (if (equal method "Monotonic") "monotonically transformed response" "response")))
       (if (equal method "Monotonic") (paste-plot-help (format nil "The monotonic transformation is attempting to make this scatter as linear as possible. ")))
       (paste-plot-help (format nil "If the scatter of points displays a linear relationship, then the assumption of linearity is satisfied for the predictor that is displayed."))))
    (paste-plot-help (format nil " The strength of relationship for the displayed predictor is displayed by the size of the scatter of points. A lot of scatter means there is a weak relationship. Small scatter implies strong relationship.~2%"))
    (show-plot-help)
    ))