---
layout: default
title: Community Guidelines
---

# Community Guidelines

Sass is more than a technology; Sass is driven by the community of individuals
that power its development and use every day. As a community, we want to embrace
the very differences that have made our collaboration so powerful, and work
together to provide the best environment for learning, growing, and sharing of
ideas. It is imperative that we keep Sass a fun, welcoming, challenging, and
fair place to play.

As such, the Sass Community Guidelines states our ideals as a community. It's
meant to be a guide on how we work together and conduct ourselves, not a
specific rulebook. It is a way to communicate our existing values to the entire
community, and share our values with the ‘verse.

## We strive to:

### BE CONSIDERATE

Our work will be used by other people, and we in turn will depend on the work of others. Any decision we take will affect users and colleagues, and we should consider them when making decisions.

### BE OPEN AND INVITING

Our community has grown immensely because of the diversity that is found within the community. We welcome all individuals regardless of, but not limited to, their gender identity and expression, sexual orientation, preferred relationship model, disability, physical appearance, body size, age, race, or religious affiliation. We take pride in the the richness of experiences that have come to help develop Sass, and want to continue growing our community. In short, everyone is welcome, except those who are unwelcoming.

### BE RESPECTFUL

Disagreement is no excuse for poor manners. We work together to resolve conflict, assume good intentions and do our best to act in an empathetic fashion. We don't allow frustration to turn into a personal attack. A community where people feel uncomfortable or threatened is not a productive one. Harassment of other community members is never okay.

### TAKE RESPONSIBILITY FOR OUR WORDS AND OUR ACTIONS

We can all make mistakes; when we do, we take responsibility for them. If someone has been harmed or offended, we listen carefully and respectfully, and work to right the wrong.

### BE COLLABORATIVE

What we produce is a complex whole made of many parts; it is the sum of many dreams. Collaboration between teams that each have their own goal and vision is essential; for the whole to be more than the sum of its parts, each part must make an effort to understand the whole.

Collaboration reduces redundancy and improves the quality of our work. Internally and externally, we celebrate good collaboration. Wherever possible, we work closely with upstream projects and others in the free software community to coordinate our efforts. We prefer to work transparently and involve interested parties as early as possible.

### VALUE DECISIVENESS, CLARITY AND OPEN COMMUNICATION

Disagreements, social and technical, are normal, but we do not allow them to persist and fester leaving others uncertain of the agreed direction.

We expect participants in the project to resolve disagreements constructively. When they cannot, we escalate the matter to either designated leaders at the event or within the community to arbitrate and provide clarity and direction.

### BE RESPONSIVE AND HELPFUL

All of us started as new and inexperienced. Even the most experienced of us may forget things. Nobody is expected to be perfect in this community. Questions are encouraged and those who are asked should endeavor to be responsive, courteous, and helpful. When off topic, please direct to the appropriate forum. Even when the question is common and repeatedly asked, even when the documentation explains it, remember that they have only asked it once and they may have read, but not understood. Ultimately, it is better to give no answer than an unfriendly one.

### STEP DOWN CONSIDERATELY

When somebody leaves or disengages from the community, we ask that they do so in a way that minimizes disruption to the projects using their published work. They should tell people they are leaving and take the proper steps to ensure that others can pick up where they left off.

## LICENSE

Our friends at [Ubuntu][1] and [Drupal][2] have already worked hard to develop
their own community guidelines, and we borrow heavily from them. However, we
have made modifications for our specific needs as a community.

The Sass Community Guidelines are licensed under the [Creative Commons Attribution-Share Alike 3.0 license][0].
You may re-use it for your own project, and modify it as you wish, just please
allow others to use your modifications and give credit to [Sass][3],
[Ubuntu][1], and [Drupal][2].

  [0]: https://creativecommons.org/licenses/by-sa/3.0/us/
  [1]: https://www.ubuntu.com/about/about-ubuntu/conduct
  [2]: https://www.drupal.org/dcoc
  [3]: https://sass-lang.com/community-guidelines
