/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.transform.Stylesheet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.StringTokenizer;

class TransformerOutputProperties
extends Properties {
    final Properties defaultProperties;
    final Stylesheet stylesheet;
    boolean dirty;

    public String getProperty(String key) {
        String val = super.getProperty(key);
        if (val == null) {
            val = this.defaultProperties.getProperty(key);
        }
        return val;
    }

    public Object put(Object key, Object value) {
        Object ret = super.put(key, value);
        this.dirty = true;
        return ret;
    }

    public void clear() {
        super.clear();
        this.dirty = true;
    }

    void apply() {
        if (!this.dirty) {
            return;
        }
        String method = this.getProperty("method");
        if ("xml".equals(method)) {
            this.stylesheet.outputMethod = 0;
        } else if ("html".equals(method)) {
            this.stylesheet.outputMethod = 1;
        } else if ("text".equals(method)) {
            this.stylesheet.outputMethod = 2;
        }
        this.stylesheet.outputVersion = this.getProperty("version");
        this.stylesheet.outputEncoding = this.getProperty("encoding");
        this.stylesheet.outputOmitXmlDeclaration = "yes".equals(this.getProperty("omit-xml-declaration"));
        this.stylesheet.outputStandalone = "yes".equals(this.getProperty("standalone"));
        this.stylesheet.outputPublicId = this.getProperty("doctype-public");
        this.stylesheet.outputSystemId = this.getProperty("doctype-system");
        StringTokenizer st = new StringTokenizer(this.getProperty("cdata-section-elements"));
        LinkedHashSet acc = new LinkedHashSet();
        while (st.hasMoreTokens()) {
            acc.add(st.nextToken());
        }
        this.stylesheet.outputCdataSectionElements = acc;
        this.stylesheet.outputIndent = "yes".equals(this.getProperty("indent"));
        this.stylesheet.outputMediaType = this.getProperty("media-type");
        this.dirty = false;
    }

    TransformerOutputProperties(Stylesheet stylesheet) {
        this.stylesheet = stylesheet;
        this.defaultProperties = new Properties();
        switch (stylesheet.outputMethod) {
            case 0: {
                this.defaultProperties.put("method", "xml");
                break;
            }
            case 1: {
                this.defaultProperties.put("method", "html");
                break;
            }
            case 2: {
                this.defaultProperties.put("method", "text");
                break;
            }
        }
        if (stylesheet.outputVersion != null) {
            this.defaultProperties.put("version", stylesheet.outputVersion);
        }
        if (stylesheet.outputEncoding != null) {
            this.defaultProperties.put("encoding", stylesheet.outputEncoding);
        }
        this.defaultProperties.put("omit-xml-declaration", stylesheet.outputOmitXmlDeclaration ? "yes" : "no");
        this.defaultProperties.put("standalone", stylesheet.outputStandalone ? "yes" : "no");
        if (stylesheet.outputPublicId != null) {
            this.defaultProperties.put("doctype-public", stylesheet.outputPublicId);
        }
        if (stylesheet.outputSystemId != null) {
            this.defaultProperties.put("doctype-system", stylesheet.outputSystemId);
        }
        StringBuffer buf = new StringBuffer();
        Iterator i = stylesheet.outputCdataSectionElements.iterator();
        while (i.hasNext()) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append((String)i.next());
        }
        this.defaultProperties.put("cdata-section-elements", buf.toString());
        this.defaultProperties.put("indent", stylesheet.outputIndent ? "yes" : "no");
        if (stylesheet.outputMediaType != null) {
            this.defaultProperties.put("media-type", stylesheet.outputMediaType);
        }
    }
}

