/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BasicSplitPaneUI
extends SplitPaneUI {
    protected static int KEYBOARD_DIVIDER_MOVE_OFFSET = 3;
    protected static final String NON_CONTINUOUS_DIVIDER = "nonContinuousDivider";
    protected int beginDragDividerLocation;
    protected int dividerSize;
    transient int lastDragLocation;
    protected BasicSplitPaneDivider divider;
    protected PropertyChangeListener propertyChangeListener;
    protected FocusListener focusListener;
    protected ActionListener keyboardDownRightListener;
    protected ActionListener keyboardEndListener;
    protected ActionListener keyboardHomeListener;
    protected ActionListener keyboardResizeToggleListener;
    protected ActionListener keyboardUpLeftListener;
    protected BasicHorizontalLayoutManager layoutManager;
    protected KeyStroke dividerResizeToggleKey;
    protected KeyStroke downKey;
    protected KeyStroke endKey;
    protected KeyStroke homeKey;
    protected KeyStroke leftKey;
    protected KeyStroke rightKey;
    protected KeyStroke upKey;
    protected boolean draggingHW;
    protected Component nonContinuousLayoutDivider;
    protected JSplitPane splitPane;

    public static ComponentUI createUI(JComponent x) {
        return new BasicSplitPaneUI();
    }

    public void installUI(JComponent c) {
        if (c instanceof JSplitPane) {
            this.splitPane = (JSplitPane)c;
            this.installDefaults();
            this.installListeners();
            this.installKeyboardActions();
        }
    }

    public void uninstallUI(JComponent c) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.splitPane = null;
    }

    protected void installDefaults() {
        LookAndFeel.installColors(this.splitPane, "SplitPane.background", "SplitPane.foreground");
        LookAndFeel.installBorder(this.splitPane, "SplitPane.border");
        this.divider = this.createDefaultDivider();
        this.resetLayoutManager();
        this.nonContinuousLayoutDivider = this.createDefaultNonContinuousLayoutDivider();
        this.splitPane.add((Component)this.divider, "divider");
        this.splitPane.setDividerSize(UIManager.getInt("SplitPane.dividerSize"));
        this.splitPane.setOpaque(true);
    }

    protected void uninstallDefaults() {
        this.layoutManager = null;
        this.splitPane.remove(this.divider);
        this.divider = null;
        this.nonContinuousLayoutDivider = null;
        this.splitPane.setBackground(null);
        this.splitPane.setBorder(null);
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.focusListener = this.createFocusListener();
        this.splitPane.addPropertyChangeListener(this.propertyChangeListener);
        this.splitPane.addFocusListener(this.focusListener);
    }

    protected void uninstallListeners() {
        this.splitPane.removePropertyChangeListener(this.propertyChangeListener);
        this.splitPane.removeFocusListener(this.focusListener);
        this.focusListener = null;
        this.propertyChangeListener = null;
    }

    protected void installKeyboardActions() {
    }

    protected void uninstallKeyboardActions() {
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyHandler();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected ActionListener createKeyboardUpLeftListener() {
        return new KeyboardUpLeftHandler();
    }

    protected ActionListener createKeyboardDownRightListener() {
        return new KeyboardDownRightHandler();
    }

    protected ActionListener createKeyboardHomeListener() {
        return new KeyboardHomeHandler();
    }

    protected ActionListener createKeyboardEndListener() {
        return new KeyboardEndHandler();
    }

    protected ActionListener createKeyboardResizeToggleListener() {
        return new KeyboardResizeToggleHandler();
    }

    public int getOrientation() {
        return this.splitPane.getOrientation();
    }

    public void setOrientation(int orientation) {
        this.splitPane.setOrientation(orientation);
    }

    public boolean isContinuousLayout() {
        return this.splitPane.isContinuousLayout();
    }

    public void setContinuousLayout(boolean b) {
        this.splitPane.setContinuousLayout(b);
    }

    public int getLastDragLocation() {
        return this.lastDragLocation;
    }

    public void setLastDragLocation(int l) {
        this.lastDragLocation = l;
    }

    public BasicSplitPaneDivider getDivider() {
        return this.divider;
    }

    protected Component createDefaultNonContinuousLayoutDivider() {
        if (this.nonContinuousLayoutDivider == null) {
            this.nonContinuousLayoutDivider = new Canvas();
            this.nonContinuousLayoutDivider.setBackground(Color.DARK_GRAY);
        }
        return this.nonContinuousLayoutDivider;
    }

    protected void setNonContinuousLayoutDivider(Component newDivider) {
        this.setNonContinuousLayoutDivider(newDivider, true);
    }

    protected void setNonContinuousLayoutDivider(Component newDivider, boolean rememberSizes) {
        this.nonContinuousLayoutDivider = newDivider;
    }

    public Component getNonContinuousLayoutDivider() {
        return this.nonContinuousLayoutDivider;
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public BasicSplitPaneDivider createDefaultDivider() {
        if (this.divider == null) {
            this.divider = new BasicSplitPaneDivider(this);
        }
        return this.divider;
    }

    public void resetToPreferredSizes(JSplitPane jc) {
        this.layoutManager.resetToPreferredSizes();
    }

    public void setDividerLocation(JSplitPane jc, int location) {
        location = this.validLocation(location);
        Container p = jc.getParent();
        Dimension rightPrefSize = jc.getRightComponent().getPreferredSize();
        Dimension size = jc.getSize();
        if (size.width == 0 && size.height == 0) {
            size = jc.getPreferredSize();
        }
        if (this.getOrientation() == 0 && location > size.height) {
            location = size.height;
            while (p != null) {
                p.setSize(p.getWidth(), p.getHeight() + rightPrefSize.height);
                p = p.getParent();
            }
        } else if (location > size.width) {
            location = size.width;
            while (p != null) {
                p.setSize(p.getWidth() + rightPrefSize.width, p.getHeight());
                p = p.getParent();
            }
        }
        this.setLastDragLocation(this.getDividerLocation(this.splitPane));
        this.splitPane.setLastDividerLocation(this.getDividerLocation(this.splitPane));
        int[] tmpSizes = this.layoutManager.getSizes();
        tmpSizes[0] = location - this.layoutManager.getInitialLocation(this.splitPane.getInsets());
        tmpSizes[1] = this.layoutManager.getAvailableSize(this.splitPane.getSize(), this.splitPane.getInsets()) - tmpSizes[0];
        this.layoutManager.setSizes(tmpSizes);
        this.splitPane.revalidate();
        this.splitPane.repaint();
    }

    public int getDividerLocation(JSplitPane jc) {
        return this.layoutManager.sizes[0] + this.layoutManager.getInitialLocation(this.splitPane.getInsets());
    }

    public int getMinimumDividerLocation(JSplitPane jc) {
        int value = this.layoutManager.getInitialLocation(jc.getInsets()) - this.layoutManager.getAvailableSize(jc.getSize(), jc.getInsets()) + this.splitPane.getDividerSize();
        if (this.layoutManager.components[1] != null) {
            value += this.layoutManager.minimumSizeOfComponent(1);
        }
        return value;
    }

    public int getMaximumDividerLocation(JSplitPane jc) {
        int value = this.layoutManager.getInitialLocation(jc.getInsets()) + this.layoutManager.getAvailableSize(jc.getSize(), jc.getInsets()) - this.splitPane.getDividerSize();
        if (this.layoutManager.components[1] != null) {
            value -= this.layoutManager.minimumSizeOfComponent(1);
        }
        return value;
    }

    public void finishedPaintingChildren(JSplitPane jc, Graphics g) {
        if (!this.splitPane.isContinuousLayout() && this.nonContinuousLayoutDivider != null && this.nonContinuousLayoutDivider.isVisible()) {
            SwingUtilities.paintComponent(g, this.nonContinuousLayoutDivider, null, this.nonContinuousLayoutDivider.getBounds());
        }
    }

    public void paint(Graphics g, JComponent jc) {
    }

    public Dimension getPreferredSize(JComponent jc) {
        return this.layoutManager.preferredLayoutSize(jc);
    }

    public Dimension getMinimumSize(JComponent jc) {
        return this.layoutManager.minimumLayoutSize(jc);
    }

    public Dimension getMaximumSize(JComponent jc) {
        return this.layoutManager.maximumLayoutSize(jc);
    }

    public Insets getInsets(JComponent jc) {
        return this.splitPane.getBorder().getBorderInsets(this.splitPane);
    }

    protected void resetLayoutManager() {
        this.layoutManager = this.getOrientation() == 1 ? new BasicHorizontalLayoutManager() : new BasicVerticalLayoutManager();
        this.getSplitPane().setLayout(this.layoutManager);
        this.layoutManager.updateComponents();
        this.getSplitPane().revalidate();
    }

    protected void startDragging() {
        this.dividerSize = this.divider.getDividerSize();
        this.setLastDragLocation(-1);
        if (!this.splitPane.getLeftComponent().isLightweight() || !this.splitPane.getRightComponent().isLightweight()) {
            this.draggingHW = true;
        }
        if (this.splitPane.isContinuousLayout()) {
            this.nonContinuousLayoutDivider.setVisible(false);
        } else {
            this.nonContinuousLayoutDivider.setVisible(true);
            this.nonContinuousLayoutDivider.setBounds(this.divider.getBounds());
        }
        this.splitPane.revalidate();
        this.splitPane.repaint();
    }

    protected void dragDividerTo(int location) {
        location = this.validLocation(location);
        if (this.beginDragDividerLocation == -1) {
            this.beginDragDividerLocation = location;
        }
        if (this.splitPane.isContinuousLayout()) {
            this.splitPane.setDividerLocation(location);
        } else {
            Point p = this.nonContinuousLayoutDivider.getLocation();
            if (this.getOrientation() == 1) {
                p.x = location;
            } else {
                p.y = location;
            }
            this.nonContinuousLayoutDivider.setLocation(p);
        }
        this.setLastDragLocation(location);
        this.splitPane.repaint();
    }

    protected void finishDraggingTo(int location) {
        if (this.nonContinuousLayoutDivider != null) {
            this.nonContinuousLayoutDivider.setVisible(false);
        }
        this.draggingHW = false;
        location = this.validLocation(location);
        this.dragDividerTo(location);
        this.splitPane.setDividerLocation(location);
        this.splitPane.setLastDividerLocation(this.beginDragDividerLocation);
        this.beginDragDividerLocation = -1;
        this.splitPane.repaint();
    }

    protected int getDividerBorderSize() {
        if (this.getOrientation() == 1) {
            return this.divider.getBorder().getBorderInsets((Component)this.divider).left;
        }
        return this.divider.getBorder().getBorderInsets((Component)this.divider).top;
    }

    private final int validLocation(int location) {
        int min = this.getMinimumDividerLocation(this.splitPane);
        int max = this.getMaximumDividerLocation(this.splitPane);
        if (min > 0 && location < min) {
            return min;
        }
        if (max > 0 && location > max) {
            return max;
        }
        return location;
    }

    private final /* synthetic */ void this() {
        this.lastDragLocation = -1;
    }

    public BasicSplitPaneUI() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class PropertyHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("dividerSize")) {
                int newSize = BasicSplitPaneUI.this.splitPane.getDividerSize();
                int[] tmpSizes = BasicSplitPaneUI.this.layoutManager.getSizes();
                BasicSplitPaneUI.this.dividerSize = tmpSizes[2];
                int newSpace = newSize - tmpSizes[2];
                tmpSizes[2] = newSize;
                tmpSizes[0] = tmpSizes[0] + newSpace / 2;
                tmpSizes[1] = tmpSizes[1] + newSpace / 2;
                BasicSplitPaneUI.this.layoutManager.setSizes(tmpSizes);
            } else if (e.getPropertyName().equals("orientation")) {
                int max = BasicSplitPaneUI.this.layoutManager.getAvailableSize(BasicSplitPaneUI.this.splitPane.getSize(), BasicSplitPaneUI.this.splitPane.getInsets());
                int dividerLoc = BasicSplitPaneUI.this.getDividerLocation(BasicSplitPaneUI.this.splitPane);
                double prop = (double)dividerLoc / (double)max;
                BasicSplitPaneUI.this.resetLayoutManager();
                if (prop <= 1.0 && prop >= 0.0) {
                    BasicSplitPaneUI.this.splitPane.setDividerLocation(prop);
                }
            }
            BasicSplitPaneUI.this.layoutManager.layoutContainer(BasicSplitPaneUI.this.splitPane);
            BasicSplitPaneUI.this.splitPane.repaint();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class FocusHandler
    extends FocusAdapter {
        public void focusGained(FocusEvent ev) {
        }

        public void focusLost(FocusEvent ev) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class KeyboardUpLeftHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent ev) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class KeyboardDownRightHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent ev) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class KeyboardHomeHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent ev) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class KeyboardEndHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent ev) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class KeyboardResizeToggleHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent ev) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class BasicHorizontalLayoutManager
    implements LayoutManager2 {
        protected Component[] components;
        protected int[] sizes;

        public void addLayoutComponent(Component comp, Object constraints) {
            this.addLayoutComponent((String)constraints, comp);
        }

        public void addLayoutComponent(String place, Component component) {
            int i = 0;
            if (place == null) {
                i = 2;
            } else if (place.equals("top") || place.equals("left")) {
                i = 0;
            } else if (place.equals("bottom") || place.equals("right")) {
                i = 1;
            } else {
                throw new IllegalArgumentException("Illegal placement in JSplitPane");
            }
            this.components[i] = component;
            this.resetSizeAt(i);
            BasicSplitPaneUI.this.splitPane.revalidate();
            BasicSplitPaneUI.this.splitPane.repaint();
        }

        protected int getAvailableSize(Dimension containerSize, Insets insets) {
            return containerSize.width - insets.left - insets.right;
        }

        protected int getInitialLocation(Insets insets) {
            if (insets != null) {
                return insets.left;
            }
            return 0;
        }

        public float getLayoutAlignmentX(Container target) {
            return target.getAlignmentX();
        }

        public float getLayoutAlignmentY(Container target) {
            return target.getAlignmentY();
        }

        protected int getPreferredSizeOfComponent(Component c) {
            Dimension dims = c.getPreferredSize();
            if (dims != null) {
                return dims.width;
            }
            return 0;
        }

        protected int getSizeOfComponent(Component c) {
            return c.getWidth();
        }

        protected int[] getSizes() {
            return this.sizes;
        }

        public void invalidateLayout(Container c) {
        }

        public void layoutContainer(Container container) {
            if (container instanceof JSplitPane) {
                JSplitPane split = (JSplitPane)container;
                this.distributeExtraSpace();
                Insets insets = split.getInsets();
                int width = this.getInitialLocation(insets);
                Dimension dims = split.getSize();
                int i = 0;
                while (i < this.components.length) {
                    if (this.components[i] != null) {
                        this.setComponentToSize(this.components[i], this.sizes[i], width, insets, dims);
                        width += this.sizes[i];
                    }
                    i += 2;
                }
                if (this.components[1] != null) {
                    this.setComponentToSize(this.components[1], this.sizes[1], width, insets, dims);
                    width += this.sizes[1];
                }
            }
        }

        public Dimension maximumLayoutSize(Container target) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        public Dimension minimumLayoutSize(Container target) {
            if (target instanceof JSplitPane) {
                JSplitPane split = (JSplitPane)target;
                Insets insets = target.getInsets();
                int height = 0;
                int width = 0;
                int i = 0;
                while (i < this.components.length) {
                    Dimension dims;
                    if (this.components[i] != null && (dims = this.components[i].getMinimumSize()) != null) {
                        width += dims.width;
                        height = Math.max(height, dims.height);
                    }
                    ++i;
                }
                return new Dimension(width, height);
            }
            return null;
        }

        public Dimension preferredLayoutSize(Container target) {
            if (target instanceof JSplitPane) {
                JSplitPane split = (JSplitPane)target;
                Insets insets = target.getInsets();
                int height = 0;
                int width = 0;
                int i = 0;
                while (i < this.components.length) {
                    Dimension dims;
                    if (this.components[i] != null && (dims = this.components[i].getPreferredSize()) != null) {
                        width += dims.width;
                        if (!(this.components[i] instanceof BasicSplitPaneDivider)) {
                            height = Math.max(height, dims.height);
                        }
                    }
                    ++i;
                }
                return new Dimension(width, height);
            }
            return null;
        }

        public void removeLayoutComponent(Component component) {
            int i = 0;
            while (i < this.components.length) {
                if (component == this.components[i]) {
                    this.components[i] = null;
                    this.sizes[i] = 0;
                }
                ++i;
            }
        }

        protected void resetSizeAt(int index) {
            if (this.components[index] != null) {
                this.sizes[index] = this.getPreferredSizeOfComponent(this.components[index]);
            }
        }

        public void resetToPreferredSizes() {
            int i = 0;
            while (i < this.components.length) {
                this.resetSizeAt(i);
                ++i;
            }
        }

        protected void setComponentToSize(Component c, int size, int location, Insets insets, Dimension containerSize) {
            int w = size;
            int h = containerSize.height - insets.top - insets.bottom;
            int x = location;
            int y = insets.top;
            c.setBounds(x, y, w, h);
        }

        protected void setSizes(int[] newSizes) {
            this.sizes = newSizes;
        }

        protected void updateComponents() {
            Component left = BasicSplitPaneUI.this.splitPane.getLeftComponent();
            Component right = BasicSplitPaneUI.this.splitPane.getRightComponent();
            if (left != null) {
                this.components[0] = left;
                this.resetSizeAt(0);
            }
            if (right != null) {
                this.components[1] = right;
                this.resetSizeAt(1);
            }
            this.components[2] = BasicSplitPaneUI.this.divider;
            this.resetSizeAt(2);
        }

        void distributeExtraSpace() {
            int availSize = this.getAvailableSize(BasicSplitPaneUI.this.splitPane.getSize(), BasicSplitPaneUI.this.splitPane.getInsets());
            int[] newSizes = new int[3];
            double weight = BasicSplitPaneUI.this.splitPane.getResizeWeight();
            int oldLen = this.sizes[0] + this.sizes[1];
            int rightAlloc = (int)((double)(availSize -= this.sizes[2] + oldLen) * (1.0 - weight));
            int leftAlloc = availSize - rightAlloc;
            this.sizes[0] = this.sizes[0] + leftAlloc;
            this.sizes[1] = this.sizes[1] + rightAlloc;
        }

        int minimumSizeOfComponent(int index) {
            Dimension dims = this.components[index].getMinimumSize();
            if (dims != null) {
                return dims.width;
            }
            return 0;
        }

        private final /* synthetic */ void this() {
            this.components = new Component[3];
            this.sizes = new int[3];
        }

        public BasicHorizontalLayoutManager() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class BasicVerticalLayoutManager
    extends BasicHorizontalLayoutManager {
        protected int getAvailableSize(Dimension containerSize, Insets insets) {
            return containerSize.height - insets.top - insets.bottom;
        }

        protected int getInitialLocation(Insets insets) {
            return insets.top;
        }

        protected int getPreferredSizeOfComponent(Component c) {
            Dimension dims = c.getPreferredSize();
            if (dims != null) {
                return dims.height;
            }
            return 0;
        }

        protected int getSizeOfComponent(Component c) {
            return c.getHeight();
        }

        public Dimension minimumLayoutSize(Container container) {
            if (container instanceof JSplitPane) {
                JSplitPane split = (JSplitPane)container;
                Insets insets = container.getInsets();
                int height = 0;
                int width = 0;
                int i = 0;
                while (i < this.components.length) {
                    Dimension dims;
                    if (this.components[i] != null && (dims = this.components[i].getMinimumSize()) != null) {
                        height += dims.height;
                        width = Math.max(width, dims.width);
                    }
                    ++i;
                }
                return new Dimension(width, height);
            }
            return null;
        }

        public Dimension preferredLayoutSize(Container container) {
            if (container instanceof JSplitPane) {
                JSplitPane split = (JSplitPane)container;
                Insets insets = container.getInsets();
                int height = 0;
                int width = 0;
                int i = 0;
                while (i < this.components.length) {
                    Dimension dims;
                    if (this.components[i] != null && (dims = this.components[i].getPreferredSize()) != null) {
                        height += dims.height;
                        width = Math.max(width, dims.width);
                    }
                    ++i;
                }
                return new Dimension(width, height);
            }
            return null;
        }

        protected void setComponentToSize(Component c, int size, int location, Insets insets, Dimension containerSize) {
            int y = location;
            int x = insets.left;
            int h = size;
            int w = containerSize.width - insets.left - insets.right;
            c.setBounds(x, y, w, h);
        }

        int minimumSizeOfComponent(int index) {
            Dimension dims = this.components[index].getMinimumSize();
            if (dims != null) {
                return dims.height;
            }
            return 0;
        }
    }
}

