/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.transform;

import java.io.PrintStream;
import java.io.PrintWriter;
import javax.xml.transform.SourceLocator;

public class TransformerException
extends Exception {
    private static final long serialVersionUID = 975798773772956428L;
    private SourceLocator locator;
    private Throwable containedException;

    public SourceLocator getLocator() {
        return this.locator;
    }

    public void setLocator(SourceLocator location) {
        this.locator = location;
    }

    public Throwable getException() {
        return this.containedException;
    }

    public Throwable getCause() {
        return this.containedException;
    }

    public Throwable initCause(Throwable cause) {
        if (this.containedException != null) {
            throw new IllegalStateException();
        }
        if (cause == this) {
            throw new IllegalArgumentException();
        }
        this.containedException = cause;
        return this;
    }

    public String getMessageAndLocation() {
        return this.locator == null ? this.getMessage() : this.getMessage() + ": " + this.getLocationAsString();
    }

    public String getLocationAsString() {
        if (this.locator == null) {
            return null;
        }
        String publicId = this.locator.getPublicId();
        String systemId = this.locator.getSystemId();
        int lineNumber = this.locator.getLineNumber();
        int columnNumber = this.locator.getColumnNumber();
        StringBuffer buffer = new StringBuffer();
        if (publicId != null) {
            buffer.append("publicId=");
            buffer.append(publicId);
        }
        if (systemId != null) {
            if (buffer.length() > 0) {
                buffer.append(' ');
            }
            buffer.append("systemId=");
            buffer.append(systemId);
        }
        if (lineNumber != -1) {
            if (buffer.length() > 0) {
                buffer.append(' ');
            }
            buffer.append("lineNumber=");
            buffer.append(lineNumber);
        }
        if (columnNumber != -1) {
            if (buffer.length() > 0) {
                buffer.append(' ');
            }
            buffer.append("columnNumber=");
            buffer.append(columnNumber);
        }
        return buffer.toString();
    }

    public void printStackTrace() {
        this.printStackTrace(System.out);
    }

    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        if (this.containedException != null) {
            s.print("caused by ");
            this.containedException.printStackTrace(s);
        }
    }

    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        if (this.containedException != null) {
            s.print("caused by ");
            this.containedException.printStackTrace(s);
        }
    }

    public TransformerException(String msg) {
        this(msg, null, null);
    }

    public TransformerException(Throwable cause) {
        this(cause.getMessage(), null, cause);
    }

    public TransformerException(String msg, Throwable cause) {
        this(msg, null, cause);
    }

    public TransformerException(String msg, SourceLocator locator) {
        this(msg, locator, null);
    }

    public TransformerException(String msg, SourceLocator locator, Throwable cause) {
        super(msg);
        this.locator = locator;
        if (cause != null) {
            this.initCause(cause);
            this.containedException = cause;
        }
    }
}

