/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome.fasta;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.broad.igv.util.ParsingUtils;

public class FastaSequenceParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, byte[]> parseFasta(String path) throws IOException {
        HashMap<String, byte[]> sequenceMap = new HashMap<String, byte[]>();
        try (BufferedReader br = null;){
            byte[] seq;
            String nextLine;
            br = ParsingUtils.openBufferedReader(path);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(10000);
            String currentChr = null;
            while ((nextLine = br.readLine()) != null) {
                if (nextLine.startsWith("#") || nextLine.trim().length() == 0) continue;
                if (nextLine.startsWith(">")) {
                    if (currentChr != null) {
                        seq = buffer.toByteArray();
                        sequenceMap.put(currentChr, seq);
                        buffer.reset();
                    }
                    currentChr = nextLine.substring(1).split("\\s+")[0];
                    continue;
                }
                buffer.write(nextLine.trim().getBytes());
            }
            if (currentChr != null) {
                seq = buffer.toByteArray();
                sequenceMap.put(currentChr, seq);
            }
        }
        return sequenceMap;
    }
}

