/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.trap;

import java.awt.EventQueue;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ExtensionHookView;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.extension.trap.OptionsTrapPanel;
import org.parosproxy.paros.extension.trap.ProxyListenerTrap;
import org.parosproxy.paros.extension.trap.TrapPanel;
import org.parosproxy.paros.extension.trap.TrapParam;
import org.parosproxy.paros.model.Session;

public class ExtensionTrap
extends ExtensionAdaptor
implements SessionChangedListener {
    private TrapPanel trapPanel = null;
    private ProxyListenerTrap proxyListener = null;
    private OptionsTrapPanel optionsTrapPanel = null;
    private TrapParam trapParam = null;

    public ExtensionTrap() {
        this.initialize();
    }

    public ExtensionTrap(String string) {
        super(string);
    }

    private void initialize() {
        this.setName("ExtensionTrap");
    }

    TrapPanel getTrapPanel() {
        if (this.trapPanel == null) {
            this.trapPanel = new TrapPanel();
            this.trapPanel.setName("Trap");
        }
        return this.trapPanel;
    }

    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        if (this.getView() != null) {
            ExtensionHookView extensionHookView = extensionHook.getHookView();
            extensionHookView.addWorkPanel(this.getTrapPanel());
            extensionHookView.addOptionPanel(this.getOptionsTrapPanel());
        }
        extensionHook.addOptionsParamSet(this.getTrapParam());
        extensionHook.addProxyListener(this.getProxyListenerTrap());
        extensionHook.addSessionListener(this);
    }

    public void sessionChanged(final Session session) {
        if (EventQueue.isDispatchThread()) {
            this.sessionChangedEventHandler(session);
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        ExtensionTrap.this.sessionChangedEventHandler(session);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void sessionChangedEventHandler(Session session) {
        this.getTrapPanel().setMessage("", "", false);
    }

    private ProxyListenerTrap getProxyListenerTrap() {
        if (this.proxyListener == null) {
            this.proxyListener = new ProxyListenerTrap(this.getModel(), this.getTrapParam());
            this.proxyListener.setTrapPanel(this.getTrapPanel());
        }
        return this.proxyListener;
    }

    private OptionsTrapPanel getOptionsTrapPanel() {
        if (this.optionsTrapPanel == null) {
            this.optionsTrapPanel = new OptionsTrapPanel();
        }
        return this.optionsTrapPanel;
    }

    private TrapParam getTrapParam() {
        if (this.trapParam == null) {
            this.trapParam = new TrapParam();
        }
        return this.trapParam;
    }
}

