<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xt="http://www.jclark.com/xt"
		version="1.0"
                extension-element-prefixes="xt">

<xsl:variable name="file">out</xsl:variable>

<xsl:output method="text"/>

<xsl:template match="/">
  <xt:document method="xml" href="{$file}.xml">
     <xsl:call-template name="out"/>
  </xt:document>
  <xsl:text>Created file </xsl:text>
  <xsl:value-of select="$file"/>
  <xsl:text>.xml&#xA;</xsl:text>
  <xt:document method="html" href="{$file}.html">
     <xsl:call-template name="out"/>
  </xt:document>
  <xsl:text>Created file </xsl:text>
  <xsl:value-of select="$file"/>
  <xsl:text>.html&#xA;</xsl:text>
  <xt:document method="text" href="{$file}.txt">
     <xsl:call-template name="out"/>
  </xt:document>
  <xsl:text>Created file </xsl:text>
  <xsl:value-of select="$file"/>
  <xsl:text>.txt&#xA;</xsl:text>
</xsl:template>

<xsl:template name="out">
  <html>
   <head><title>Title</title></head>
   <body>
   <p>Line 1<br/>Line 2</p>
   </body>
  </html>
</xsl:template>

<xsl:template match="*|@*">
  <xsl:copy>
    <xsl:apply-templates select="@*"/>
    <xsl:apply-templates select="node()"/>
  </xsl:copy>
</xsl:template>

</xsl:stylesheet>
