/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters;

import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.filters.BaseParamFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.types.Parameter;

public final class ReplaceTokens
extends BaseParamFilterReader
implements ChainableReader {
    private static final char DEFAULT_BEGIN_TOKEN = '@';
    private static final char DEFAULT_END_TOKEN = '@';
    private String queuedData = null;
    private String replaceData = null;
    private int replaceIndex = -1;
    private int queueIndex = -1;
    private Hashtable hash = new Hashtable();
    private char beginToken = (char)64;
    private char endToken = (char)64;

    public ReplaceTokens() {
    }

    public ReplaceTokens(Reader in) {
        super(in);
    }

    private int getNextChar() throws IOException {
        if (this.queueIndex != -1) {
            char ch = this.queuedData.charAt(this.queueIndex++);
            if (this.queueIndex >= this.queuedData.length()) {
                this.queueIndex = -1;
            }
            return ch;
        }
        return this.in.read();
    }

    public final int read() throws IOException {
        if (!this.getInitialized()) {
            this.initialize();
            this.setInitialized(true);
        }
        if (this.replaceIndex != -1) {
            char ch = this.replaceData.charAt(this.replaceIndex++);
            if (this.replaceIndex >= this.replaceData.length()) {
                this.replaceIndex = -1;
            }
            return ch;
        }
        int ch = this.getNextChar();
        if (ch == this.beginToken) {
            StringBuffer key = new StringBuffer("");
            while ((ch = this.getNextChar()) != -1) {
                key.append((char)ch);
                if (ch != this.endToken) continue;
            }
            if (ch == -1) {
                this.queuedData = this.queuedData == null || this.queueIndex == -1 ? key.toString() : key.toString() + this.queuedData.substring(this.queueIndex);
                this.queueIndex = 0;
                return this.beginToken;
            }
            key.setLength(key.length() - 1);
            String replaceWith = (String)this.hash.get(key.toString());
            if (replaceWith != null) {
                this.replaceData = replaceWith;
                this.replaceIndex = 0;
                return this.read();
            }
            String newData = key.toString() + this.endToken;
            this.queuedData = this.queuedData == null || this.queueIndex == -1 ? newData : newData + this.queuedData.substring(this.queueIndex);
            this.queueIndex = 0;
            return this.beginToken;
        }
        return ch;
    }

    public final void setBeginToken(char beginToken) {
        this.beginToken = beginToken;
    }

    private final char getBeginToken() {
        return this.beginToken;
    }

    public final void setEndToken(char endToken) {
        this.endToken = endToken;
    }

    private final char getEndToken() {
        return this.endToken;
    }

    public final void addConfiguredToken(Token token) {
        this.hash.put(token.getKey(), token.getValue());
    }

    private void setTokens(Hashtable hash) {
        this.hash = hash;
    }

    private final Hashtable getTokens() {
        return this.hash;
    }

    public final Reader chain(Reader rdr) {
        ReplaceTokens newFilter = new ReplaceTokens(rdr);
        newFilter.setBeginToken(this.getBeginToken());
        newFilter.setEndToken(this.getEndToken());
        newFilter.setTokens(this.getTokens());
        newFilter.setInitialized(true);
        return newFilter;
    }

    private final void initialize() {
        Parameter[] params = this.getParameters();
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                String value;
                String name;
                if (params[i] == null) continue;
                String type = params[i].getType();
                if ("tokenchar".equals(type)) {
                    name = params[i].getName();
                    value = params[i].getValue();
                    if ("begintoken".equals(name)) {
                        if (value.length() == 0) {
                            throw new BuildException("Begin token cannot be empty");
                        }
                        this.beginToken = params[i].getValue().charAt(0);
                        continue;
                    }
                    if (!"endtoken".equals(name)) continue;
                    if (value.length() == 0) {
                        throw new BuildException("End token cannot be empty");
                    }
                    this.endToken = params[i].getValue().charAt(0);
                    continue;
                }
                if (!"token".equals(type)) continue;
                name = params[i].getName();
                value = params[i].getValue();
                this.hash.put(name, value);
            }
        }
    }

    public static class Token {
        private String key;
        private String value;

        public final void setKey(String key) {
            this.key = key;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final String getKey() {
            return this.key;
        }

        public final String getValue() {
            return this.value;
        }
    }
}

