/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.view;

import java.awt.Component;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTabbedPane;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.activation.ActiveDockableListener;
import org.flexdock.docking.defaults.DefaultDockingPort;
import org.flexdock.docking.defaults.StandardBorderManager;
import org.flexdock.view.View;

public class Viewport
extends DefaultDockingPort
implements DockingConstants {
    protected HashSet blockedRegions = new HashSet(5);

    public Viewport() {
        this.setBorderManager(new StandardBorderManager());
    }

    public Viewport(String portId) {
        super(portId);
        this.setBorderManager(new StandardBorderManager());
    }

    public void setRegionBlocked(String region, boolean isBlocked) {
        if (this.isValidDockingRegion(region)) {
            if (isBlocked) {
                this.blockedRegions.add(region);
            } else {
                this.blockedRegions.remove(region);
            }
        }
    }

    public boolean isDockingAllowed(Component comp, String region) {
        boolean blocked;
        boolean bl = blocked = !super.isDockingAllowed(comp, region);
        if (blocked) {
            return false;
        }
        if (this.blockedRegions.contains(region)) {
            return false;
        }
        if (!"CENTER".equals(region)) {
            return true;
        }
        Dockable dockable = this.getCenterDockable();
        if (dockable == null) {
            return true;
        }
        return dockable.getDockingProperties().isTerritoryBlocked(region) == false;
    }

    public boolean dock(Dockable dockable) {
        return this.dock(dockable, "CENTER");
    }

    protected JTabbedPane createTabbedPane() {
        JTabbedPane pane = super.createTabbedPane();
        pane.addChangeListener(ActiveDockableListener.getInstance());
        return pane;
    }

    public Set getViewset() {
        return this.getDockableSet(-1, 0, View.class);
    }

    public Set getViewset(int depth) {
        return this.getDockableSet(depth, 0, View.class);
    }

    protected String paramString() {
        return "id=" + this.getPersistentId() + "," + super.paramString();
    }

    static {
        DockingManager.setDockingStrategy(Viewport.class, View.VIEW_DOCKING_STRATEGY);
    }
}

