/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.idea.model;

import com.google.common.base.Objects;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.UncheckedIOException;
import org.gradle.plugins.ide.idea.model.FilePath;
import org.gradle.plugins.ide.idea.model.Path;

public class PathFactory {
    private final List<Variable> variables = new ArrayList<Variable>();
    private final Map<String, File> varsByName = new HashMap<String, File>();

    public PathFactory addPathVariable(String name, File dir) {
        this.variables.add(new Variable('$' + name + '$', dir.getAbsolutePath() + File.separator, dir));
        this.varsByName.put(name, dir);
        return this;
    }

    public FilePath path(File file) {
        return this.path(file, false);
    }

    public FilePath path(File file, boolean useFileScheme) {
        Variable match = null;
        for (Variable variable : this.variables) {
            if (file.getAbsolutePath().equals(variable.getDir().getAbsolutePath())) {
                match = variable;
                break;
            }
            if (!file.getAbsolutePath().startsWith(variable.getPrefix()) || match != null && !variable.getPrefix().startsWith(match.getPrefix())) continue;
            match = variable;
        }
        if (match != null) {
            return PathFactory.resolvePath(match.getDir(), match.getName(), file);
        }
        String relPath = file.getAbsolutePath().replace(File.separatorChar, '/');
        String url = PathFactory.relativePathToURI(relPath, useFileScheme);
        return new FilePath(file, url, url, relPath);
    }

    public FilePath relativePath(String pathVar, File file) {
        return PathFactory.resolvePath(this.varsByName.get(pathVar), "$" + pathVar + "$", file);
    }

    private static FilePath resolvePath(File rootDir, String rootDirName, File file) {
        String relPath = PathFactory.getRelativePath(rootDir, rootDirName, file);
        String url = PathFactory.relativePathToURI(relPath);
        String canonicalUrl = PathFactory.relativePathToURI(file.getAbsolutePath().replace(File.separatorChar, '/'));
        return new FilePath(file, url, canonicalUrl, relPath);
    }

    public Path path(String url) {
        return this.path(url, null);
    }

    public Path path(String url, String relPath) {
        try {
            String[] parts;
            String expandedUrl = url;
            for (Variable variable : this.variables) {
                expandedUrl = expandedUrl.replace(variable.getName(), variable.getPrefix());
            }
            if (expandedUrl.toLowerCase().startsWith("file://")) {
                expandedUrl = PathFactory.toUrl("file", new File(expandedUrl.substring(7)).getCanonicalFile());
            } else if (expandedUrl.toLowerCase().startsWith("jar://") && (parts = expandedUrl.substring(6).split("!")).length == 2) {
                expandedUrl = PathFactory.toUrl("jar", new File(parts[0]).getCanonicalFile()) + "!" + parts[1];
            }
            return new Path(url, expandedUrl, relPath);
        }
        catch (IOException ex) {
            throw new UncheckedIOException((Throwable)ex);
        }
    }

    private static String toUrl(String scheme, File file) {
        return scheme + "://" + file.getAbsolutePath().replace(File.separatorChar, '/');
    }

    private static String getRelativePath(File rootDir, String rootDirString, File file) {
        String relpath = PathFactory.matchPathLists(PathFactory.getPathList(rootDir), PathFactory.getPathList(file));
        return relpath != null ? rootDirString + "/" + relpath : file.getAbsolutePath().replace(File.separatorChar, '/');
    }

    private static String relativePathToURI(String relpath) {
        return PathFactory.relativePathToURI(relpath, false);
    }

    private static String relativePathToURI(String relpath, boolean useFileScheme) {
        if (relpath.endsWith(".jar") && !useFileScheme) {
            return "jar://" + relpath + "!/";
        }
        return "file://" + relpath;
    }

    private static List<String> getPathList(File f) {
        try {
            ArrayList<String> list = new ArrayList<String>();
            File r = f.getCanonicalFile();
            while (r != null) {
                File parent = r.getParentFile();
                list.add(parent != null ? r.getName() : r.getAbsolutePath());
                r = parent;
            }
            return list;
        }
        catch (IOException ex) {
            throw new UncheckedIOException((Throwable)ex);
        }
    }

    private static String matchPathLists(List<String> r, List<String> f) {
        int j;
        StringBuilder s = new StringBuilder();
        int i = r.size() - 1;
        if (!r.get(i).equals(f.get(j))) {
            return null;
        }
        for (j = f.size() - 1; i >= 0 && j >= 0 && Objects.equal((Object)r.get(i), (Object)f.get(j)); --i, --j) {
        }
        while (i >= 0) {
            s.append("../");
            --i;
        }
        while (j >= 1) {
            s.append(f.get(j)).append("/");
            --j;
        }
        if (j == 0) {
            s.append(f.get(j));
        }
        return s.toString();
    }

    private static class Variable {
        private final String name;
        private final String prefix;
        private final File dir;

        Variable(String name, String prefix, File dir) {
            this.name = name;
            this.prefix = prefix;
            this.dir = dir;
        }

        public final String getName() {
            return this.name;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        public final File getDir() {
            return this.dir;
        }
    }
}

