/*
 * Decompiled with CFR 0.152.
 */
package free.jin;

import free.chess.BoardImageBoardPainter;
import free.chess.ImagePiecePainter;
import free.chess.SquareImagesBoardPainter;
import free.jin.Jin;
import free.jin.JinContext;
import free.jin.Preferences;
import free.jin.Resource;
import free.jin.Server;
import free.jin.User;
import free.jin.action.ActionInfo;
import free.jin.plugin.Plugin;
import free.jin.plugin.PluginInfo;
import free.util.AWTUtilities;
import free.util.BrowserControl;
import free.util.IOUtilities;
import free.util.Localization;
import free.util.audio.AppletContextAudioPlayer;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JinApplet
extends Applet
implements JinContext {
    private Locale locale;
    private Localization l10n;
    private final Properties autologinParams = new Properties();
    private Server server;
    private ActionInfo[] actions;
    private PluginInfo[] plugins;
    private Preferences prefs;
    private User[] users;
    private String username;
    private String password;
    private Thread settingsUploadThread = null;
    private Dialog settingsUploadDialog = null;

    public void init() {
        try {
            this.locale = this.determineLocale();
            this.configureLibraries();
            this.l10n = Localization.load(JinApplet.class);
            this.server = this.loadServer();
            this.actions = this.loadActions();
            this.plugins = this.loadPlugins();
            String string = this.getParameter("bgcolor");
            if (string != null) {
                this.setBackground(new Color(0xFF000000 | Integer.parseInt(string, 16)));
            }
            this.setLayout(new FlowLayout());
            this.add(new UserAuthPanel());
        }
        catch (Throwable throwable) {
            this.createErrorUI(throwable);
        }
    }

    private void restart() {
        try {
            this.username = null;
            this.password = null;
            this.removeAll();
            this.autologinParams.clear();
            this.server = this.loadServer();
            this.add(new UserAuthPanel());
            this.validate();
        }
        catch (Throwable throwable) {
            this.createErrorUI(throwable);
        }
    }

    private void start(Preferences preferences, User user, User[] userArray, String string, String string2) {
        this.username = string;
        this.password = string2;
        this.prefs = preferences;
        this.users = userArray;
        this.server.setGuestUser(user);
        this.autologinParams.put("login.username", string);
        this.autologinParams.put("login.password", string2);
        this.autologinParams.put("autologin", "true");
        Jin.createInstance(this);
        Jin.getInstance().start();
    }

    private void startAsGuest() {
        this.username = null;
        this.password = null;
        this.prefs = Preferences.createNew();
        this.users = new User[0];
        this.server.setGuestUser(null);
        this.autologinParams.put("login.guest", "true");
        this.autologinParams.put("autologin", "true");
        Jin.createInstance(this);
        Jin.getInstance().start();
    }

    private Locale determineLocale() {
        String string = this.getParameter("locale.language");
        String string2 = this.getParameter("locale.country");
        String string3 = this.getParameter("locale.variant");
        string = string == null ? "" : string;
        string2 = string2 == null ? "" : string2;
        string3 = string3 == null ? "" : string3;
        return new Locale(string, string2, string3);
    }

    private void configureLibraries() {
        Localization.setAppLocale(this.locale);
        BrowserControl.setAppletContext(this.getAppletContext());
        AppletContextAudioPlayer.setAppletContext(this.getAppletContext());
        ImagePiecePainter.setAsyncImageLoad(true);
        BoardImageBoardPainter.setAsyncImageLoad(true);
        SquareImagesBoardPainter.setAsyncImageLoad(true);
    }

    private Server loadServer() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String string = this.getParameter("server.classname");
        if (string == null) {
            throw new IllegalStateException("No server.classname parameter specified");
        }
        Server server = (Server)Class.forName(string).newInstance();
        server.setHost(this.getDocumentBase().getHost());
        String string2 = this.getParameter("port");
        if (string2 != null) {
            server.setPort(Integer.parseInt(string2));
        }
        return server;
    }

    private ActionInfo[] loadActions() throws IOException, ClassNotFoundException {
        String string = this.getParameter("actions.count");
        if (string == null) {
            throw new IllegalStateException("No actions.count parameter specified");
        }
        ActionInfo[] actionInfoArray = new ActionInfo[Integer.parseInt(string)];
        for (int i = 0; i < actionInfoArray.length; ++i) {
            Preferences preferences;
            String string2 = this.getParameter("actions." + i + ".classname");
            if (string2 == null) {
                throw new IllegalStateException("Missing classname for action No. " + i);
            }
            Class<?> clazz = Class.forName(string2);
            InputStream inputStream = clazz.getResourceAsStream("preferences");
            Preferences preferences2 = preferences = inputStream == null ? Preferences.createNew() : Preferences.load(inputStream);
            if (inputStream != null) {
                inputStream.close();
            }
            actionInfoArray[i] = new ActionInfo(clazz, preferences);
        }
        return actionInfoArray;
    }

    private PluginInfo[] loadPlugins() throws IOException, ClassNotFoundException {
        String string = this.getParameter("plugins.count");
        if (string == null) {
            throw new IllegalStateException("No plugins.count parameter specified");
        }
        PluginInfo[] pluginInfoArray = new PluginInfo[Integer.parseInt(string)];
        for (int i = 0; i < pluginInfoArray.length; ++i) {
            Preferences preferences;
            String string2 = this.getParameter("plugins." + i + ".classname");
            if (string2 == null) {
                throw new IllegalStateException("Missing classname for plugin No. " + i);
            }
            Class<?> clazz = Class.forName(string2);
            InputStream inputStream = clazz.getResourceAsStream("preferences");
            Preferences preferences2 = preferences = inputStream == null ? Preferences.createNew() : Preferences.load(inputStream);
            if (inputStream != null) {
                inputStream.close();
            }
            pluginInfoArray[i] = new PluginInfo(clazz, preferences);
        }
        return pluginInfoArray;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getParameter(String string) {
        String string2 = this.autologinParams.getProperty(string);
        return string2 == null ? super.getParameter(string) : string2;
    }

    public Preferences getPrefs() {
        return this.prefs;
    }

    public Map getResources(String string, Plugin plugin) {
        HashMap<String, Resource> hashMap = new HashMap<String, Resource>();
        try {
            ZipEntry zipEntry;
            URL uRL = this.getCodeBase();
            URL uRL2 = new URL(uRL, "resources/" + string + "/definitions.zip");
            if (!IOUtilities.isURLCached(uRL2)) {
                IOUtilities.cacheURL(uRL2);
            }
            ZipInputStream zipInputStream = new ZipInputStream(IOUtilities.inputStreamForURL(uRL2, true));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string2 = zipEntry.getName();
                if (!string2.endsWith("definition") || zipEntry.isDirectory()) continue;
                String string3 = string2.substring(0, string2.length() - "/definition".length());
                byte[] byArray = IOUtilities.readToEnd(zipInputStream);
                URL uRL3 = new URL(uRL, "resources/" + string + "/" + string3 + "/");
                IOUtilities.cacheData(new URL(uRL3, "definition"), byArray);
                Resource resource = this.loadResource(uRL3, plugin);
                if (resource == null) continue;
                hashMap.put(resource.getId(), resource);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return hashMap;
    }

    public Resource getResource(String string, String string2, Plugin plugin) {
        try {
            URL uRL = new URL(this.getCodeBase(), "resources/" + string + "/" + string2 + "/");
            return this.loadResource(uRL, plugin);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private Resource loadResource(URL uRL, Plugin plugin) throws IOException {
        Properties properties;
        String string;
        URL uRL2 = new URL(uRL, "definition");
        if (!IOUtilities.isURLCached(uRL2)) {
            IOUtilities.cacheURL(uRL2);
        }
        if ((string = (properties = IOUtilities.loadProperties(uRL2, true)).getProperty("classname")) == null) {
            return null;
        }
        try {
            Class<?> clazz = plugin.getClass().getClassLoader().loadClass(string);
            Resource resource = (Resource)clazz.newInstance();
            if (resource.load(uRL, plugin)) {
                return resource;
            }
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return null;
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return null;
        }
    }

    public void shutdown() {
        if (this.username != null) {
            this.settingsUploadThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        Object object = null;
                        while (!"OK".equals(object = JinApplet.this.uploadSettings())) {
                            if (((String)object).toLowerCase().indexOf("password") != -1) {
                                if (this.showPasswordDialog((String)object)) continue;
                                break;
                            }
                            this.showErrorDialog((String)object);
                        }
                    }
                    catch (IOException iOException) {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        iOException.printStackTrace(new PrintStream(byteArrayOutputStream));
                        this.showErrorDialog(byteArrayOutputStream.toString());
                    }
                    finally {
                        JinApplet jinApplet = JinApplet.this;
                        synchronized (jinApplet) {
                            if (JinApplet.this.settingsUploadThread == Thread.currentThread()) {
                                JinApplet.this.settingsUploadThread = null;
                                if (JinApplet.this.settingsUploadDialog != null) {
                                    JinApplet.this.settingsUploadDialog.dispose();
                                    JinApplet.this.settingsUploadDialog = null;
                                }
                            }
                        }
                    }
                }

                private void showErrorDialog(String string) {
                    SettingsUploadErrorDialog settingsUploadErrorDialog = new SettingsUploadErrorDialog(AWTUtilities.frameForComponent(JinApplet.this), string);
                    AWTUtilities.centerWindow(settingsUploadErrorDialog, JinApplet.this);
                    settingsUploadErrorDialog.setVisible(true);
                }

                private boolean showPasswordDialog(String string) {
                    PasswordDialog passwordDialog = new PasswordDialog(AWTUtilities.frameForComponent(JinApplet.this), string, JinApplet.this.username);
                    AWTUtilities.centerWindow(passwordDialog, JinApplet.this);
                    boolean bl = passwordDialog.shouldRetry();
                    if (bl) {
                        JinApplet.this.username = passwordDialog.getUsername();
                        JinApplet.this.password = passwordDialog.getPassword();
                    }
                    return bl;
                }
            };
            this.settingsUploadDialog = new SettingsUploadDialog(AWTUtilities.frameForComponent(this)){

                public void addNotify() {
                    super.addNotify();
                    if (JinApplet.this.settingsUploadThread != null && !JinApplet.this.settingsUploadThread.isAlive()) {
                        JinApplet.this.settingsUploadThread.start();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void canceled() {
                    JinApplet jinApplet = JinApplet.this;
                    synchronized (jinApplet) {
                        this.dispose();
                    }
                }
            };
            AWTUtilities.centerWindow(this.settingsUploadDialog, this);
            this.settingsUploadDialog.setVisible(true);
        }
        this.restart();
    }

    private String uploadSettings() throws IOException {
        URL uRL = this.getPrefsUploadUrl();
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDoOutput(true);
        uRLConnection.setRequestProperty("Content-type", "application/binary");
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(uRLConnection.getOutputStream()));
        dataOutputStream.writeBytes(this.username + "\n");
        dataOutputStream.writeBytes(this.password + "\n");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.prefs.save(byteArrayOutputStream);
        dataOutputStream.writeInt(byteArrayOutputStream.size());
        byteArrayOutputStream.writeTo(dataOutputStream);
        this.writeUser(dataOutputStream, this.server.getGuest());
        dataOutputStream.writeInt(this.users.length);
        for (int i = 0; i < this.users.length; ++i) {
            this.writeUser(dataOutputStream, this.users[i]);
        }
        dataOutputStream.writeBytes("PREFS_UPLOAD_END");
        dataOutputStream.close();
        uRLConnection.connect();
        byteArrayOutputStream.reset();
        IOUtilities.pump(uRLConnection.getInputStream(), byteArrayOutputStream);
        String string = new String(byteArrayOutputStream.toByteArray());
        return string;
    }

    private void writeUser(DataOutputStream dataOutputStream, User user) throws IOException {
        dataOutputStream.writeUTF(user.getUsername());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        user.getPrefs().save(byteArrayOutputStream);
        dataOutputStream.writeInt(byteArrayOutputStream.size());
        byteArrayOutputStream.writeTo(dataOutputStream);
    }

    public Server[] getServers() {
        return new Server[]{this.server};
    }

    public User[] getUsers() {
        return this.users;
    }

    public void setUsers(User[] userArray) {
        this.users = userArray;
    }

    public ActionInfo[] getActions(Server server) {
        if (server != this.server) {
            throw new IllegalArgumentException("Unknown server: " + server);
        }
        return this.actions;
    }

    public PluginInfo[] getPlugins(Server server) {
        if (server != this.server) {
            throw new IllegalArgumentException("Unknown server: " + server);
        }
        return this.plugins;
    }

    public boolean isSavePrefsCapable() {
        return true;
    }

    public String getPasswordSaveWarning() {
        try {
            boolean bl;
            boolean bl2 = bl = this.getPrefsDownloadUrl().getProtocol().equals("https") && this.getPrefsUploadUrl().getProtocol().equals("https");
            if (bl) {
                return null;
            }
            return this.l10n.getString("passwordSaveWarning");
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return "Error: Your password will not be stored due to a configuration problem.";
        }
    }

    public boolean isUserExtensible() {
        return false;
    }

    private void createErrorUI(Throwable throwable) {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add((Component)new Label(this.l10n.getString("errorLabel.text")), "North");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        throwable.printStackTrace(new PrintStream(byteArrayOutputStream));
        TextArea textArea = new TextArea(byteArrayOutputStream.toString());
        this.add((Component)textArea, "Center");
        this.doLayout();
    }

    private URL getPrefsDownloadUrl() throws MalformedURLException {
        URL uRL = new URL(this.getDocumentBase(), this.getParameter("loadPrefsURL"));
        return new URL(this.getParameter("prefsProtocol"), uRL.getHost(), uRL.getPort(), uRL.getFile());
    }

    private URL getPrefsUploadUrl() throws MalformedURLException {
        URL uRL = new URL(this.getDocumentBase(), this.getParameter("savePrefsURL"));
        return new URL(this.getParameter("prefsProtocol"), uRL.getHost(), uRL.getPort(), uRL.getFile());
    }

    private class PasswordDialog
    extends Dialog {
        private final TextField usernameField;
        private final TextField passwordField;
        private boolean shouldRetry;

        public PasswordDialog(Frame frame, String string, String string2) {
            super(frame, JinApplet.this.l10n.getString("passwordPrefsUploadErrorDialog.title"), true);
            this.usernameField = new TextField(string2);
            this.passwordField = new TextField();
            this.passwordField.setEchoChar('*');
            this.createUI(string);
        }

        private void createUI(String string) {
            this.setLayout(new BorderLayout(5, 5));
            this.add("North", new Label(JinApplet.this.l10n.getString("passwordPrefsUploadErrorDialog.message")));
            Panel panel = new Panel(new BorderLayout(5, 5));
            TextArea textArea = new TextArea(string, 3, 40);
            textArea.setEditable(false);
            panel.add("Center", textArea);
            Panel panel2 = new Panel(new BorderLayout());
            Panel panel3 = new Panel(new GridLayout(2, 1, 10, 10));
            Panel panel4 = new Panel(new GridLayout(2, 1, 10, 10));
            panel3.add(new Label(JinApplet.this.l10n.getString("usernameLabel.text")));
            panel4.add(this.usernameField);
            panel3.add(new Label(JinApplet.this.l10n.getString("passwordLabel.text")));
            panel4.add(this.passwordField);
            panel2.add("West", panel3);
            panel2.add("Center", panel4);
            panel.add("South", panel2);
            this.add("Center", panel);
            Button button = new Button(JinApplet.this.l10n.getString("passwordPrefsUploadErrorDialog.retryButton.text"));
            Button button2 = new Button(JinApplet.this.l10n.getString("passwordPrefsUploadErrorDialog.closeButton.text"));
            Panel panel5 = new Panel(new FlowLayout());
            panel5.add(button);
            panel5.add(button2);
            this.add("South", panel5);
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PasswordDialog.this.shouldRetry = true;
                    PasswordDialog.this.dispose();
                }
            });
            button2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PasswordDialog.this.shouldRetry = false;
                    PasswordDialog.this.dispose();
                }
            });
        }

        public boolean shouldRetry() {
            this.setVisible(true);
            return this.shouldRetry;
        }

        public String getUsername() {
            return this.usernameField.getText();
        }

        public String getPassword() {
            return this.passwordField.getText();
        }
    }

    private class SettingsUploadErrorDialog
    extends Dialog {
        public SettingsUploadErrorDialog(Frame frame, String string) {
            super(frame, JinApplet.this.l10n.getString("prefsUploadErrorDialog.title"), true);
            this.createUI(string);
        }

        private void createUI(String string) {
            this.setLayout(new BorderLayout(5, 5));
            this.add("North", new Label(JinApplet.this.l10n.getString("prefsUploadErrorDialog.message")));
            TextArea textArea = new TextArea(string, 3, 40);
            textArea.setEditable(false);
            this.add("Center", textArea);
            Button button = new Button(JinApplet.this.l10n.getString("prefsUploadErrorDialog.closeButton.text"));
            Panel panel = new Panel(new FlowLayout());
            panel.add(button);
            this.add("South", panel);
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SettingsUploadErrorDialog.this.dispose();
                }
            });
        }
    }

    private abstract class SettingsUploadDialog
    extends Dialog {
        public SettingsUploadDialog(Frame frame) {
            super(frame, "", true);
            this.setTitle(JinApplet.this.l10n.getString("prefsUploadDialog.title"));
            this.setLayout(new GridLayout(2, 1));
            this.add(new Label(JinApplet.this.l10n.getString("prefsUploadDialog.message")));
            Button button = new Button(JinApplet.this.l10n.getString("prefsUploadDialog.cancelButton.text"));
            Panel panel = new Panel(new FlowLayout());
            panel.add(button);
            this.add(panel);
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SettingsUploadDialog.this.canceled();
                }
            });
        }

        public abstract void canceled();
    }

    private class UserAuthPanel
    extends Panel
    implements Runnable {
        private final TextField usernameField = new TextField(20);
        private final TextField passwordField = new TextField(20);
        private final Label statusLabel = new Label();
        private Button loginButton;
        private Button guestButton;
        private Thread authThread = null;
        private boolean isPainted = false;

        public UserAuthPanel() {
            this.passwordField.setEchoChar('*');
            this.createUI();
        }

        private void setStatus(String string, Color color) {
            this.statusLabel.setForeground(color);
            this.statusLabel.setText(string);
        }

        private void createUI() {
            this.setLayout(new BorderLayout(15, 15));
            this.add("North", new Label(JinApplet.this.l10n.getString("instructionsLabel.text")));
            Panel panel = new Panel(new BorderLayout());
            Panel panel2 = new Panel(new GridLayout(2, 1, 10, 10));
            Panel panel3 = new Panel(new GridLayout(2, 1, 10, 10));
            panel2.add(new Label(JinApplet.this.l10n.getString("usernameLabel.text")));
            panel3.add(this.usernameField);
            panel2.add(new Label(JinApplet.this.l10n.getString("passwordLabel.text")));
            panel3.add(this.passwordField);
            panel.add("West", panel2);
            Panel panel4 = new Panel(new BorderLayout());
            panel4.add("West", panel3);
            panel.add("Center", panel4);
            this.add("Center", panel);
            Panel panel5 = new Panel(new GridLayout(2, 1));
            panel5.add(this.statusLabel);
            this.loginButton = new Button(JinApplet.this.l10n.getString("loginButton.text"));
            this.guestButton = new Button(JinApplet.this.l10n.getString("loginAsGuestButton.text"));
            Panel panel6 = new Panel(new FlowLayout(1));
            panel6.add(this.loginButton);
            panel6.add(this.guestButton);
            panel5.add(panel6);
            this.add("South", panel5);
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = UserAuthPanel.this.usernameField.getText();
                    String string2 = UserAuthPanel.this.passwordField.getText();
                    if (string == null || "".equals(string)) {
                        UserAuthPanel.this.setStatus(JinApplet.this.l10n.getString("usernameUnspecifiedError"), Color.red);
                        UserAuthPanel.this.usernameField.requestFocus();
                    } else if (string2 == null || "".equals(string2)) {
                        UserAuthPanel.this.setStatus(JinApplet.this.l10n.getString("passwordUnspecifiedError"), Color.red);
                        UserAuthPanel.this.passwordField.requestFocus();
                    } else {
                        UserAuthPanel.this.loginButton.setEnabled(false);
                        UserAuthPanel.this.guestButton.setEnabled(false);
                        UserAuthPanel.this.retrievePrefs();
                    }
                }
            };
            this.loginButton.addActionListener(actionListener);
            this.usernameField.addActionListener(actionListener);
            this.passwordField.addActionListener(actionListener);
            this.guestButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    UserAuthPanel.this.setStatus(JinApplet.this.l10n.getString("startingJinStatus"), Color.black);
                    UserAuthPanel.this.loginButton.setEnabled(false);
                    UserAuthPanel.this.guestButton.setEnabled(false);
                    JinApplet.this.startAsGuest();
                    UserAuthPanel.this.setStatus(JinApplet.this.l10n.getString("stayOnPageStatus"), Color.black);
                }
            });
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (!this.isPainted) {
                this.isPainted = true;
                this.usernameField.requestFocus();
            }
        }

        private synchronized void retrievePrefs() {
            if (this.authThread == null) {
                this.authThread = new Thread(this);
                this.authThread.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                User[] userArray;
                User user;
                Preferences preferences;
                String string = this.usernameField.getText();
                String string2 = this.passwordField.getText();
                this.setStatus(JinApplet.this.l10n.getString("connectingStatus"), Color.black);
                URL uRL = JinApplet.this.getPrefsDownloadUrl();
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setDoOutput(true);
                uRLConnection.setRequestProperty("Content-type", "application/binary");
                DataOutputStream dataOutputStream = new DataOutputStream(uRLConnection.getOutputStream());
                dataOutputStream.writeBytes((String)string + "\n");
                dataOutputStream.writeBytes(string2 + "\n");
                dataOutputStream.close();
                uRLConnection.connect();
                this.setStatus(JinApplet.this.l10n.getString("authenticatingStatus"), Color.black);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
                DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
                String string3 = dataInputStream.readLine();
                if ("OK".equals(string3)) {
                    this.setStatus(JinApplet.this.l10n.getString("retrievingPreferencesStatus"), Color.black);
                    int n = dataInputStream.readInt();
                    preferences = Preferences.load(new ByteArrayInputStream(IOUtilities.read(bufferedInputStream, n)));
                    user = this.loadUser(dataInputStream);
                    int n2 = dataInputStream.readInt();
                    userArray = new User[n2];
                    for (int i = 0; i < userArray.length; ++i) {
                        userArray[i] = this.loadUser(dataInputStream);
                    }
                } else if ("NOPREFS".equals(string3)) {
                    preferences = Preferences.createNew();
                    user = null;
                    userArray = new User[]{};
                } else {
                    this.setStatus(string3, Color.red);
                    System.out.println(string3);
                    IOUtilities.pump(bufferedInputStream, System.out);
                    this.loginButton.setEnabled(true);
                    this.guestButton.setEnabled(true);
                    return;
                }
                this.setStatus(JinApplet.this.l10n.getString("startingJinStatus"), Color.black);
                JinApplet.this.start(preferences, user, userArray, string, string2);
                this.setStatus(JinApplet.this.l10n.getString("stayOnPageStatus"), Color.black);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                JinApplet.this.createErrorUI(iOException);
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
                JinApplet.this.createErrorUI(runtimeException);
            }
            finally {
                UserAuthPanel userAuthPanel = this;
                synchronized (userAuthPanel) {
                    this.authThread = null;
                }
            }
        }

        private User loadUser(DataInputStream dataInputStream) throws IOException {
            String string = dataInputStream.readUTF();
            int n = dataInputStream.readInt();
            Preferences preferences = Preferences.load(new ByteArrayInputStream(IOUtilities.read(dataInputStream, n)));
            Hashtable hashtable = new Hashtable();
            return new User(JinApplet.this.server, string, preferences, hashtable);
        }
    }
}

