/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ic.doc.scenebeans.input;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.NoninvertibleTransformException;
import java.util.List;
import uk.ac.ic.doc.scenebeans.MouseClick;
import uk.ac.ic.doc.scenebeans.MouseMotion;
import uk.ac.ic.doc.scenebeans.SceneGraph;
import uk.ac.ic.doc.scenebeans.pick.Picker;

public class MouseDispatcher
implements MouseListener,
MouseMotionListener {
    private SceneGraph _scene_graph;
    private Object _lock;

    public MouseDispatcher() {
        this._scene_graph = null;
        this._lock = null;
    }

    public MouseDispatcher(SceneGraph sceneGraph, Object object) {
        this._scene_graph = sceneGraph;
        this._lock = object;
    }

    public SceneGraph getSceneGraph() {
        return this._scene_graph;
    }

    public void setSceneGraph(SceneGraph sceneGraph) {
        this._scene_graph = sceneGraph;
    }

    public Object getLock() {
        return this._lock;
    }

    public void setLock(Object object) {
        this._lock = object;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this._scene_graph == null) {
            return;
        }
        try {
            Object object = this._lock;
            synchronized (object) {
                Component component = (Component)mouseEvent.getSource();
                Graphics2D graphics2D = (Graphics2D)component.getGraphics();
                List list = Picker.pick(graphics2D, this._scene_graph, mouseEvent.getX(), mouseEvent.getY());
                MouseClick.mousePressed(list);
                this.mouseDragged(mouseEvent);
            }
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this._scene_graph == null) {
            return;
        }
        try {
            Object object = this._lock;
            synchronized (object) {
                Component component = (Component)mouseEvent.getSource();
                Graphics2D graphics2D = (Graphics2D)component.getGraphics();
                List list = Picker.pick(graphics2D, this._scene_graph, mouseEvent.getX(), mouseEvent.getY());
                MouseClick.mouseReleased(list);
            }
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this._scene_graph == null) {
            return;
        }
        try {
            Object object = this._lock;
            synchronized (object) {
                MouseMotion.mouseMoved(this._scene_graph, mouseEvent.getX(), mouseEvent.getY());
            }
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this._scene_graph == null) {
            return;
        }
        try {
            Object object = this._lock;
            synchronized (object) {
                MouseMotion.mouseDragged(this._scene_graph, mouseEvent.getX(), mouseEvent.getY());
            }
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
    }

    public void attachTo(Component component) {
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
    }

    public void removeFrom(Component component) {
        component.removeMouseListener(this);
        component.removeMouseMotionListener(this);
    }
}

