.\" $Header: /home/vikas/netmgt/nocol/src/doc/RCS/genmon.8,v 1.4 1994/11/29 20:12:56 vikas Exp $
.\"
.TH GENMON 8 "May 1994"
.SH NAME
genmon \- Generic NOCOL monitoring interface
.SH SYNOPSIS
.B genmon
[
.B \-d
] [
.B \-e
.I prog-to-execute
] [
.B \-a
.I 'args to program'
]
.LP
The
.I genmon
program parses nocol LOG format
.I text 
strings and creates NOCOL format data files which can then be parsed 
by the various NOCOL post-processors.
.SH OPTIONS
.TP
.B \-d
For debug mode. Will not daemonize and writes errors to \fIstdout\fR.
.TP
.B \-e
.I <program to execute>
Full path to the program that is run
.TP
.B \-a
.I <arguments>
This is a list of arguments for the program to be executed. Enclose
multiple arguments within single quotes.

.SH DESCRIPTION
.LP
The
.B genmon
process provides a simple interface for developing additional monitors
for NOCOL. It reads in EVENT text lines (of the format generated by
.IR noclogd (8)
), and creates NOCOL data structures. Additionally, it recognizes the
.I LOG
keyword for logging the event to the noclogd daemon and the
.I APPEND
keyword for seeking to the end of the existing output datafile before
writing additional nocol events.
.LP
The typical format of the NOCOL text lines (of the
.I noclogd
format) are:
.RS
.I date
[
.I sender
]: SITE
.I sitename address
VAR
.I varname value threshold units
LEVEL
.I severity
LOGLEVEL
.I log severity
NOCOP
.I up down unknown test
.RE

Thus, any monitoring front-end process (could be a shell script) can
output text lines in the above format and create a NOCOL format datafile.
There are two ways to use this program:
.RS
    mymonitor | genmon  > DATADIR/mymonitor-output
.RE
In this mode, the 'APPEND' keyword is ignored since the output is written
to the stdout.
Alternatively, you can use:
.RS
    genmon  \-e mymonitor \-a 'mymonitors various flags'
.RE
In this mode, genmon forks and opens a datafile in the nocol data directory.
It then invokes the program specified on the command line and reads text
lines from the stdout of the process being called. If it scans an
APPEND keyword, it seeks to the end of the datafile before writing (it only
needs this once in each pass). It then sleeps for SLEEPTIME (15 secs)
and then calls the monitoring program again. Keep in mind that since
the monitoring process is re-invoked each time, it has no way of
remembering the state of the events it monitored in the previous passes.
Thus, the 'APPEND' keyword should be used with caution (as you don't want
to go on appending to the datafile each time).
.SH CAVEATS
It is perhaps easier to use the PERL interface to NOCOL\-
.BI perlnocol (3)
.SH AUTHOR
Vikas Aggarwal, vikas@navya.com.
.SH SEE ALSO
netconsole(1) nocol-prog(3) perlnocol(3)
etherload(8) eventselect(8) genmon(8) noclogd(8) nocol-overview(8)
nocol-utility(8) nsmon(8) pingmon(8) portmon(8) 
tpmon(8) trapmon(8)

