/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.ExtensionPopupMenu;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.SiteMap;
import org.parosproxy.paros.model.SiteNode;

public class PopupPurgeMenu
extends ExtensionPopupMenu {
    private Component invoker = null;

    public PopupPurgeMenu() {
        this.initialize();
    }

    private void initialize() {
        this.setText("Purge (from DB)");
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PopupPurgeMenu.this.invoker.getName().equals("treeSite")) {
                    JTree jTree = (JTree)PopupPurgeMenu.this.invoker;
                    TreePath[] treePathArray = jTree.getSelectionPaths();
                    SiteMap siteMap = (SiteMap)jTree.getModel();
                    for (int i = 0; i < treePathArray.length; ++i) {
                        SiteNode siteNode = (SiteNode)treePathArray[i].getLastPathComponent();
                        PopupPurgeMenu.purge(siteMap, siteNode);
                    }
                }
            }
        });
    }

    public boolean isEnableForComponent(Component component) {
        if (component.getName() != null && component.getName().equals("treeSite")) {
            this.invoker = component;
            return true;
        }
        this.invoker = null;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void purge(SiteMap siteMap, SiteNode siteNode) {
        SiteNode siteNode2 = null;
        SiteMap siteMap2 = siteMap;
        synchronized (siteMap2) {
            while (siteNode.getChildCount() > 0) {
                try {
                    siteNode2 = (SiteNode)siteNode.getChildAt(0);
                    PopupPurgeMenu.purge(siteMap, siteNode2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (siteNode.isRoot()) {
                return;
            }
            ExtensionHistory extensionHistory = (ExtensionHistory)Control.getSingleton().getExtensionLoader().getExtension("ExtensionHistory");
            extensionHistory.getHistoryList().removeElement(siteNode.getHistoryReference());
            if (siteNode.getHistoryReference() != null) {
                siteNode.getHistoryReference().delete();
            }
            while (siteNode.getPastHistoryReference().size() > 0) {
                HistoryReference historyReference = (HistoryReference)siteNode.getPastHistoryReference().get(0);
                extensionHistory.getHistoryList().removeElement(historyReference);
                historyReference.delete();
                siteNode.getPastHistoryReference().remove(0);
            }
            siteMap.removeNodeFromParent(siteNode);
        }
    }
}

