/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Map;
import java.util.WeakHashMap;

public class Thread
implements Runnable {
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    public static final int MAX_PRIORITY = 10;
    private static int numAnonymousThreadsCreated;
    volatile VMThread vmThread;
    volatile ThreadGroup group;
    final Runnable runnable;
    volatile String name;
    volatile boolean daemon;
    volatile int priority;
    private long stacksize;
    Throwable stillborn;
    private ClassLoader contextClassLoader;
    WeakHashMap locals;
    byte[] vmData;

    void callRun() {
        this.vmThread.callRun();
    }

    public static int activeCount() {
        return Thread.currentThread().group.activeCount();
    }

    public final void checkAccess() {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkAccess(this);
        }
    }

    public int countStackFrames() {
        VMThread t = this.vmThread;
        if (t == null || this.group == null) {
            throw new IllegalThreadStateException();
        }
        return t.countStackFrames();
    }

    public static Thread currentThread() {
        return VMThread.currentThread();
    }

    public void destroy() {
        throw new NoSuchMethodError();
    }

    public static void dumpStack() {
        new Throwable().printStackTrace();
    }

    public static int enumerate(Thread[] array) {
        return Thread.currentThread().group.enumerate(array);
    }

    public final String getName() {
        VMThread t = this.vmThread;
        return t == null ? this.name : t.getName();
    }

    public final synchronized int getPriority() {
        VMThread t = this.vmThread;
        return t == null ? this.priority : t.getPriority();
    }

    public final ThreadGroup getThreadGroup() {
        return this.group;
    }

    public static boolean holdsLock(Object obj) throws NullPointerException {
        if (obj != null) {
            return VMThread.holdsLock(obj);
        }
        throw new NullPointerException();
    }

    public synchronized void interrupt() {
        this.checkAccess();
        VMThread t = this.vmThread;
        if (t != null) {
            t.interrupt();
        }
    }

    public static boolean interrupted() {
        return VMThread.interrupted();
    }

    public boolean isInterrupted() {
        VMThread t = this.vmThread;
        boolean bl = false;
        if (t != null && t.isInterrupted()) {
            bl = true;
        }
        return bl;
    }

    public final boolean isAlive() {
        VMThread t = this.vmThread;
        boolean bl = false;
        if (t != null && t.isAlive()) {
            bl = true;
        }
        return bl;
    }

    public final boolean isDaemon() {
        VMThread t = this.vmThread;
        return t == null ? this.daemon : t.isDaemon();
    }

    public final void join() throws InterruptedException {
        this.join(0L, 0);
    }

    public final void join(long ms) throws InterruptedException {
        this.join(ms, 0);
    }

    public final void join(long ms, int ns) throws InterruptedException {
        if (ms < 0L || ns < 0 || ns > 999999) {
            throw new IllegalArgumentException();
        }
        VMThread t = this.vmThread;
        if (t != null) {
            t.join(ms, ns);
        }
    }

    public final synchronized void resume() {
        this.checkAccess();
        VMThread.resume(this.vmData);
    }

    public void run() {
        if (this.runnable != null) {
            this.runnable.run();
        }
    }

    public final synchronized void setDaemon(boolean daemon) {
        if (this.vmThread != null) {
            throw new IllegalThreadStateException();
        }
        this.checkAccess();
        this.daemon = daemon;
    }

    public synchronized ClassLoader getContextClassLoader() {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("getClassLoader"));
        }
        if (this.contextClassLoader == null) {
            this.contextClassLoader = ClassLoader.getSystemClassLoader();
        }
        return this.contextClassLoader;
    }

    public synchronized void setContextClassLoader(ClassLoader classloader) {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("setContextClassLoader"));
        }
        this.contextClassLoader = classloader;
    }

    public final synchronized void setName(String name) {
        this.checkAccess();
        if (name == null) {
            throw new NullPointerException();
        }
        VMThread t = this.vmThread;
        if (t != null) {
            t.setName(name);
        } else {
            this.name = name;
        }
    }

    public static void yield() {
        VMThread.yield();
    }

    public static void sleep(long ms) throws InterruptedException {
        Thread.sleep(ms, 0);
    }

    public static void sleep(long ms, int ns) throws InterruptedException {
        if (ms < 0L) {
            throw new IllegalArgumentException("Negative milliseconds: " + ms);
        }
        if (ns < 0 || ns > 999999) {
            throw new IllegalArgumentException("Nanoseconds ouf of range: " + ns);
        }
        VMThread.sleep(ms, ns);
    }

    public synchronized void start() {
        if (this.vmThread != null || this.group == null) {
            throw new IllegalThreadStateException();
        }
        VMThread.create(this, this.stacksize);
    }

    public final void stop() {
        this.stop(new ThreadDeath());
    }

    public final synchronized void stop(Throwable t) {
        VMThread vt;
        if (t == null) {
            throw new NullPointerException();
        }
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkAccess(this);
            if (this != Thread.currentThread()) {
                sm.checkPermission(new RuntimePermission("stopThread"));
            }
        }
        if ((vt = this.vmThread) != null) {
            vt.stop(t);
        } else {
            this.stillborn = t;
        }
    }

    public final synchronized void suspend() {
        this.checkAccess();
        VMThread.suspend(this.vmData);
    }

    public final synchronized void setPriority(int priority) {
        this.checkAccess();
        if (priority < 1 || priority > 10) {
            throw new IllegalArgumentException("Invalid thread priority value " + priority + '.');
        }
        priority = Math.min(priority, this.group.getMaxPriority());
        VMThread t = this.vmThread;
        if (t != null) {
            t.setPriority(priority);
        } else {
            this.priority = priority;
        }
    }

    public String toString() {
        return "Thread[" + this.name + ',' + this.priority + ',' + (this.group == null ? "" : this.group.getName()) + ']';
    }

    synchronized void die() {
        this.group.removeThread(this);
        this.vmThread = null;
        this.locals = null;
    }

    static Map getThreadLocals() {
        Thread thread = Thread.currentThread();
        WeakHashMap locals = thread.locals;
        if (locals == null) {
            locals = thread.locals = new WeakHashMap();
        }
        return locals;
    }

    public Thread() {
        this((ThreadGroup)null, (Runnable)null);
    }

    public Thread(Runnable target) {
        this(null, target);
    }

    public Thread(String name) {
        this(null, null, name, 0L);
    }

    public Thread(ThreadGroup group, Runnable target) {
        this(group, target, "Thread-" + ++numAnonymousThreadsCreated, 0L);
    }

    public Thread(ThreadGroup group, String name) {
        this(group, null, name, 0L);
    }

    public Thread(Runnable target, String name) {
        this(null, target, name, 0L);
    }

    public Thread(ThreadGroup group, Runnable target, String name) {
        this(group, target, name, 0L);
    }

    public Thread(ThreadGroup group, Runnable target, String name, long size) {
        SecurityManager sm = SecurityManager.current;
        Thread current = Thread.currentThread();
        if (group == null) {
            if (sm != null) {
                group = sm.getThreadGroup();
            }
            if (group == null) {
                group = current.group;
            }
        } else if (sm != null) {
            sm.checkAccess(group);
        }
        this.group = group;
        this.name = name.toString();
        this.runnable = target;
        this.stacksize = size;
        this.priority = current.priority;
        this.daemon = current.daemon;
        this.contextClassLoader = current.contextClassLoader;
        group.addThread(this);
        InheritableThreadLocal.newChildThread(this);
    }

    Thread(VMThread vmThread, String name, int priority, boolean daemon) {
        this.vmThread = vmThread;
        this.runnable = null;
        if (name == null) {
            name = "Thread-" + ++numAnonymousThreadsCreated;
        }
        this.name = name;
        this.priority = priority;
        this.daemon = daemon;
        this.contextClassLoader = ClassLoader.getSystemClassLoader();
    }

    Thread(String name, ThreadGroup group) {
        this.group = group;
        this.name = name;
        this.runnable = null;
        this.priority = 10;
        this.vmThread = new VMThread(this);
        group.addThread(this);
    }
}

