/*
 * forkarp.h
 *
 * Function and constant definitions for forkarp.c
 *
 * Copyright (c) 2002, 2003 Todd MacDermid <tmacd@synacklabs.net>
 *
 */

#ifndef FORKARP_H
#define FORKARP_H
#define PACKETSIZE 1518 /* No, I don't expect to get that big */
#define PACKETWAIT 10   /* In milliseconds */
#define FILTERSIZE 512
#define ARP_TIMEOUT 400
#include "packetp.h"

/* arpd_end_handler is the function that will be called when the arp daemon
 * dies. Use it to signal to your process that it's time to end, cleanly
 * shut down, or restart a new arp daemon, whatever
 */
typedef void (*arpd_end_handler)(int);
int packetp_fork_arpd(struct addr *, arpd_end_handler, char *);

int packetp_get_mac_nonblock(struct packetp_ctx *ctx, 
			     struct arp_entry *entry); 
void packetp_arp_update(struct packetp_ctx *ctx, uint8_t *packet);
void * packetp_arp_wait(void *thread_arg);


#endif /* FORKARP_H */
