.TH FBSAMPLE 1 25-Jun-90
.CM 3
.SH NAME
fbsample \- convert 1bit image to grayscale by sampling
.SH SYNOPSIS
.nf
fbsample [ -t'title' -c'credits' -g'grain' -n'nbr']
         [ -<type> ] < bitmap > image
.fi
.SH DESCRIPTION
.PP
Samples a 1 bit deep pbm file using a square neighborhood of the
specified size, and outputs an 8 bit file.  You will want to run
.I fbnorm
on the output to expand the scale to 255, and there will be a small
loss of sharpness, so
.I fbsharp
will also be useful.  Once you have an 8 bit file, you can resize it
arbitrarily, and then convert it back to a 1 bit file, if need be.
The default neighborhood size is 8 by 8, which gives 65 different gray
levels.
.SH OPTIONS
.TP
.B -g
.I grain
size.  The sample is taken every
.I grain
pixels.
.TP
.B -n
.I neighborhood
size.  The value will be the number of light pixels in the nearby NxN
square.  The values can range from 1 to 16.
.TP
.BR -t'title'
.I title,
specify a character string (up to 80 characters) to describe the image.
The default is no title.
.TP
.BR -c'credits'
.I credits or subtitle,
specify a second character string (up to 80 characters) to describe the
image.  The default is no credit string.
.TP
.BR -B
.I face
format, as used by Bennet Yee's
.I face
program at CMU. 
.TP
.BR -F
.I FBM,
format (by default, the default).  You are guaranteed not
to lose information by specifying FBM as the default.
.TP
.BR -G
.I GIF,
Compuserve GIF format.
.TP
.BR -I
.I IFF
format, interleaved bitmaps (ILBM), used by Amigas.
.TP
.BR -P
.I PBM,
Jef Poskanzer's bitmap format.
.TP
.BR -S
.I sun,
Sun rasterfiles (not run length encoded).
.PP
.SH EXAMPLE
.PP
Suppose you have a 480 by 600 face format file (-B) that you wish to
shrink to 300 by 375 and convert to PostScript (say for inclusion 
in your door label).  Here's a pipeline to do that:
.sp
.nf
    % fbsample -n5 -g1 < my.face | \    # sample 5x5
      fbnorm -b4 -w1 |                  # normalize
      fbext -w300 | \                   # make 300 pixels wide
      fbhalf -s20 | \                   # halftone and really sharpen
      pbm2ps -s 1 > sdoor.ps            # convert to postscript
.fi
.SH SEE ALSO
fbnorm(1) to normalize the output,
fbm(1) for general discussion, pbm(1) for PBM routines.
.SH BUGS
None known.
.SH HISTORY
Copyright (C) 1989,1990 by Michael Mauldin.  Permission is granted
to use this file in whole or in part for any purpose, educational,
recreational or commercial, provided that this copyright notice
is retained unchanged.  This software is available to all free of
charge by anonymous FTP and in the UUNET archives.
.TP
25-Jun-90  Michael Mauldin at Carnegie Mellon University
Release 1.0 mlm@cs.cmu.edu
.TP
07-Mar-89  Michael L. Mauldin at Carnegie Mellon University
Beta release (version 0.9) mlm@cs.cmu.edu
