require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&lauxlib_h)) {
    eval 'sub lauxlib_h () {1;}' unless defined(&lauxlib_h);
    unless(defined(&_KERNEL)) {
	require 'stddef.ph';
	require 'stdio.ph';
    }
    require './luaconf.ph';
    require './lua.ph';
    eval 'sub LUA_GNAME () {"_G";}' unless defined(&LUA_GNAME);
    eval 'sub LUA_ERRFILE () {( &LUA_ERRERR+1);}' unless defined(&LUA_ERRFILE);
    eval 'sub LUA_LOADED_TABLE () {"_LOADED";}' unless defined(&LUA_LOADED_TABLE);
    eval 'sub LUA_PRELOAD_TABLE () {"_PRELOAD";}' unless defined(&LUA_PRELOAD_TABLE);
    eval 'sub LUAL_NUMSIZES () {($sizeof{ &lua_Integer}*16+ $sizeof{ &lua_Number});}' unless defined(&LUAL_NUMSIZES);
    eval 'sub luaL_checkversion {
        my($L) = @_;
	    eval q( &luaL_checkversion_($L,  &LUA_VERSION_NUM,  &LUAL_NUMSIZES));
    }' unless defined(&luaL_checkversion);
    unless(defined(&_KERNEL)) {
    } else {
	eval 'sub luaL_checkinteger () { &luaL_checknumber;}' unless defined(&luaL_checkinteger);
	eval 'sub luaL_optinteger {
	    my($L,$a,$d) = @_;
    	    eval q( &luaL_optnumber($L, ($a), ( &lua_Number)($d)));
	}' unless defined(&luaL_optinteger);
    }
    unless(defined(&_KERNEL)) {
    }
    eval 'sub LUA_NOREF () {(-2);}' unless defined(&LUA_NOREF);
    eval 'sub LUA_REFNIL () {(-1);}' unless defined(&LUA_REFNIL);
    unless(defined(&_KERNEL)) {
	eval 'sub luaL_loadfile {
	    my($L,$f) = @_;
    	    eval q( &luaL_loadfilex($L,$f, &NULL));
	}' unless defined(&luaL_loadfile);
    }
    eval 'sub luaL_newlibtable {
        my($L,$l) = @_;
	    eval q( &lua_createtable($L, 0, $sizeof{$l}/$sizeof{($l)[0]} - 1));
    }' unless defined(&luaL_newlibtable);
    eval 'sub luaL_newlib {
        my($L,$l) = @_;
	    eval q(( &luaL_checkversion($L),  &luaL_newlibtable($L,$l),  &luaL_setfuncs($L,$l,0)));
    }' unless defined(&luaL_newlib);
    eval 'sub luaL_argcheck {
        my($L, $cond,$arg,$extramsg) = @_;
	    eval q((( &void)( &luai_likely($cond) ||  &luaL_argerror($L, ($arg), ($extramsg)))));
    }' unless defined(&luaL_argcheck);
    eval 'sub luaL_argexpected {
        my($L,$cond,$arg,$tname) = @_;
	    eval q((( &void)( &luai_likely($cond) ||  &luaL_typeerror($L, ($arg), ($tname)))));
    }' unless defined(&luaL_argexpected);
    eval 'sub luaL_checkstring {
        my($L,$n) = @_;
	    eval q(( &luaL_checklstring($L, ($n),  &NULL)));
    }' unless defined(&luaL_checkstring);
    eval 'sub luaL_optstring {
        my($L,$n,$d) = @_;
	    eval q(( &luaL_optlstring($L, ($n), ($d),  &NULL)));
    }' unless defined(&luaL_optstring);
    eval 'sub luaL_typename {
        my($L,$i) = @_;
	    eval q( &lua_typename($L,  &lua_type($L,($i))));
    }' unless defined(&luaL_typename);
    unless(defined(&_KERNEL)) {
	eval 'sub luaL_dofile {
	    my($L, $fn) = @_;
    	    eval q(( &luaL_loadfile($L, $fn) ||  &lua_pcall($L, 0,  &LUA_MULTRET, 0)));
	}' unless defined(&luaL_dofile);
    }
    eval 'sub luaL_dostring {
        my($L, $s) = @_;
	    eval q(( &luaL_loadstring($L, $s) ||  &lua_pcall($L, 0,  &LUA_MULTRET, 0)));
    }' unless defined(&luaL_dostring);
    eval 'sub luaL_getmetatable {
        my($L,$n) = @_;
	    eval q(( &lua_getfield($L,  &LUA_REGISTRYINDEX, ($n))));
    }' unless defined(&luaL_getmetatable);
    eval 'sub luaL_opt {
        my($L,$f,$n,$d) = @_;
	    eval q(( &lua_isnoneornil($L,($n)) ? ($d) : $f($L,($n))));
    }' unless defined(&luaL_opt);
    eval 'sub luaL_loadbuffer {
        my($L,$s,$sz,$n) = @_;
	    eval q( &luaL_loadbufferx($L,$s,$sz,$n, &NULL));
    }' unless defined(&luaL_loadbuffer);
    eval 'sub luaL_intop {
        my($op,$v1,$v2) = @_;
	    eval q((( &lua_Integer)(( &lua_Unsigned)($v1) $op ( &lua_Unsigned)($v2))));
    }' unless defined(&luaL_intop);
    eval 'sub luaL_pushfail {
        my($L) = @_;
	    eval q( &lua_pushnil($L));
    }' unless defined(&luaL_pushfail);
    if(!defined(&lua_assert)) {
	if(defined (&LUAI_ASSERT)) {
	    require 'assert.ph';
	    eval 'sub lua_assert {
	        my($c) = @_;
    		eval q( &assert($c));
	    }' unless defined(&lua_assert);
	} else {
	    eval 'sub lua_assert {
	        my($c) = @_;
    		eval q((( &void)0));
	    }' unless defined(&lua_assert);
	}
    }
    eval 'sub luaL_bufflen {
        my($bf) = @_;
	    eval q((($bf)-> &n));
    }' unless defined(&luaL_bufflen);
    eval 'sub luaL_buffaddr {
        my($bf) = @_;
	    eval q((($bf)-> &b));
    }' unless defined(&luaL_buffaddr);
    eval 'sub luaL_addchar {
        my($B,$c) = @_;
	    eval q((( &void)(($B)-> &n < ($B)-> &size ||  &luaL_prepbuffsize(($B), 1)), (($B)-> $b[($B)-> &n++] = ($c))));
    }' unless defined(&luaL_addchar);
    eval 'sub luaL_addsize {
        my($B,$s) = @_;
	    eval q((($B)-> &n += ($s)));
    }' unless defined(&luaL_addsize);
    eval 'sub luaL_buffsub {
        my($B,$s) = @_;
	    eval q((($B)-> &n -= ($s)));
    }' unless defined(&luaL_buffsub);
    eval 'sub luaL_prepbuffer {
        my($B) = @_;
	    eval q( &luaL_prepbuffsize($B,  &LUAL_BUFFERSIZE));
    }' unless defined(&luaL_prepbuffer);
    unless(defined(&_KERNEL)) {
	eval 'sub LUA_FILEHANDLE () {"FILE*";}' unless defined(&LUA_FILEHANDLE);
    }
    unless(defined(&_KERNEL)) {
	if(!defined(&lua_writestring)) {
	    eval 'sub lua_writestring {
	        my($s,$l) = @_;
    		eval q( &fwrite(($s), $sizeof{\'char\'}, ($l),  &stdout));
	    }' unless defined(&lua_writestring);
	}
	if(!defined(&lua_writeline)) {
	    eval 'sub lua_writeline () {
	        eval q(( &lua_writestring(\\"\\\\n\\", 1),  &fflush( &stdout)));
	    }' unless defined(&lua_writeline);
	}
	if(!defined(&lua_writestringerror)) {
	    eval 'sub lua_writestringerror {
	        my($s,$p) = @_;
    		eval q(( &fprintf( &stderr, ($s), ($p)),  &fflush( &stderr)));
	    }' unless defined(&lua_writestringerror);
	}
    }
    if(defined(&LUA_COMPAT_APIINTCASTS)) {
	eval 'sub luaL_checkunsigned {
	    my($L,$a) = @_;
    	    eval q((( &lua_Unsigned) &luaL_checkinteger($L,$a)));
	}' unless defined(&luaL_checkunsigned);
	eval 'sub luaL_optunsigned {
	    my($L,$a,$d) = @_;
    	    eval q((( &lua_Unsigned) &luaL_optinteger($L,$a,( &lua_Integer)($d))));
	}' unless defined(&luaL_optunsigned);
	eval 'sub luaL_checkint {
	    my($L,$n) = @_;
    	    eval q(( &luaL_checkinteger($L, ($n))));
	}' unless defined(&luaL_checkint);
	eval 'sub luaL_optint {
	    my($L,$n,$d) = @_;
    	    eval q(( &luaL_optinteger($L, ($n), ($d))));
	}' unless defined(&luaL_optint);
	eval 'sub luaL_checklong {
	    my($L,$n) = @_;
    	    eval q(( &luaL_checkinteger($L, ($n))));
	}' unless defined(&luaL_checklong);
	eval 'sub luaL_optlong {
	    my($L,$n,$d) = @_;
    	    eval q(( &luaL_optinteger($L, ($n), ($d))));
	}' unless defined(&luaL_optlong);
    }
}
1;
