: /usr/pkg/etc/etsh.login - " Modify to taste. "
:
: "  The author of this file, J.A. Neitzel <jan (at) etsh (dot) nl>,  "
: "  hereby grants it to the public domain.                           "
:
: "  From:  https://etsh.nl/examples  "
:

trap : 1 2 3 13 14 15 ; : " Ignore HUP, INT, QUIT, PIPE, ALRM, and TERM. "
trap : 18 21 22 ;       : " Ignore job-control signals: TSTP, TTIN, TTOU "

: fd2 -e echo "debug: Executing `/usr/pkg/etc/etsh.login' now..."
: fd2 -e echo
: fd2 -e echo "debug: Initial value of PATH == $p"
: fd2 -e echo

unset X L
set   X "/usr/pkg" ; : " etsh install PREFIX; it    "
		   ; : " could be /etroot, /usr/local/etlocal, /usr/local,     "
		   ; : " or something else altogether.                         "
set   L  after     ; : " L, /usr/local/bin, `before' or `after' /usr/X11R6/bin "

: " Check if /tmp is writable and if egrep is available. "
umask 0077
setenv PATH /bin:/usr/bin:/sbin:/usr/sbin:$X/bin
if ! {\
   fd2 etsh -c '(:)>/tmp/etsh-$1-$2;rm -f /tmp/etsh-$1-$2' "$u" "$$" >/dev/null\
} goto error
	: fallthrough
if ! { fd2 which egrep >/dev/null } goto error
	: fallthrough
: error
	: but we are still here

:
: " Set a default umask and PATH for all (root & !root) users. "
:
umask 0022
if "$k" -ne 0 -a "$u" != root goto NotRoot
	: " The desire here is to use the default OpenBSD root PATH. "
	: fd2 -e echo "debug: \$X == $X"
	setenv	PATH	/sbin:/usr/sbin:/bin:/usr/bin:/usr/X11R6/bin
	setenv	PATH	$p:/usr/local/sbin:/usr/local/bin
	goto Continue

: NotRoot
	: " The desire here is that etsh & tsh are in the 1st PATH directory "
	: " (or as close to the beginning of the user's PATH as possible)... "
	if "$X" != "/etroot" goto nr-/usr/local/etlocal
		: fd2 -e echo "debug: \$X == $X"
		setenv	PATH	/bin:/usr/bin:/sbin:/usr/sbin:/usr/X11R6/bin
		setenv	PATH	$p:/usr/local/bin:/usr/local/sbin:/usr/games
		goto nr-done
	: nr-/usr/local/etlocal
	: nr-...etc...
	: " See egrep(1) and/or re_format(7) regarding pattern if needed. "
	echo $X | egrep 'ethome|/usr/local/etlocal|/v6shell/idir' >/dev/null
	if $? -ne 0 goto nr-/usr/local
	    : fd2 -e echo "debug: \$X == $X"
	    if "$L" == after goto nr-L-after
		: fd2 -e echo "debug: \$L == $L"
		setenv	PATH	$X/bin:/usr/local/bin:/bin:/usr/bin:/sbin:/usr/sbin
		setenv	PATH	$p:/usr/X11R6/bin:/usr/local/sbin:/usr/games
		goto nr-done
	    : nr-L-after
		: fd2 -e echo "debug: \$L == $L"
		setenv	PATH	/bin:/usr/bin:/sbin:/usr/sbin:/usr/X11R6/bin
		setenv	PATH	$p:$X/bin:/usr/local/bin:/usr/local/sbin:/usr/games
		goto nr-done
	: nr-/usr/local
	if "$X" != /usr/local goto nr-something-else
	    : fd2 -e echo "debug: \$X == $X"
	    if "$L" == after goto nr-L-after1
		: fd2 -e echo "debug: \$L == $L"
		setenv	PATH	$X/bin:/bin:/usr/bin:/sbin:/usr/sbin:/usr/X11R6/bin
		setenv	PATH	$p:$X/sbin:/usr/games
		goto nr-done
	    : nr-L-after1
		: fd2 -e echo "debug: \$L == $L"
		setenv	PATH	/bin:/usr/bin:/sbin:/usr/sbin:/usr/X11R6/bin
		setenv	PATH	$p:$X/bin:$X/sbin:/usr/games
		goto nr-done
	: nr-something-else
		: " This is the default again; sysadmin can modify as desired. "
		: " This default is modified; /sbin and /usr/bin are flipped.  "
		: fd2 -e echo "debug: \$X == $X"
		setenv	PATH	/bin:/usr/bin:/sbin:/usr/sbin:/usr/X11R6/bin
		setenv	PATH	$p:/usr/local/bin:/usr/local/sbin:/usr/games
		: fallthrough
	: nr-done
		: setenv	PATH	$p:. ; : " . in PATH? not recommended! "

: Continue
	: fd2 -e echo
	: fd2 -e echo "debug: uid=$k($u) gid=$i($g): PATH == $p"

unset L

: " Notice that PATH may get additions in /usr/pkg/etc/etsh.etshrc . "

setenv MAIL /var/mail/$u
stty status '^T' <-

set D /tmp/etsh-$u-$$
if ! { mkdir -m 0700 $D } goto Finish

	:
	: " Set $T and/or setenv CTTY as needed. "
	:
	set S 0
	printenv CTTY | wc -l | tr -d ' ' | grep '^1$' >/dev/null
	if $? -ne 0 goto NoCtty
		( \
		   echo -n 'set T "' ; printenv CTTY | tr -d '\n' ; echo '"' \
		) >$D/TisCTTY
		source $D/TisCTTY
		set S 1
		rm $D/TisCTTY
		: fallthrough
	: NoCtty
		if $S -eq 1 goto TisCTTY
			setenv CTTY $t
			set    T    $t
		: TisCTTY
			: fallthrough
	unset S

	:
	: " Use the output from `hostname -s' to `setenv HOST value'. "
	:
	( \
	   echo -n 'setenv HOST "' ; hostname -s | tr -d '\n' ; echo '"' \
	) >$D/HOST
	source $D/HOST
	rm -rf $D

: Finish

unset D
trap - 1 2 3 13 14 15 ; : " Reset the ignored, non-job-control signals. "
