require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&OPENSSL_PKCS12_H)) {
    eval 'sub OPENSSL_PKCS12_H () {1;}' unless defined(&OPENSSL_PKCS12_H);
    require 'openssl/macros.ph';
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	eval 'sub HEADER_PKCS12_H () {1;}' unless defined(&HEADER_PKCS12_H);
    }
    require 'openssl/bio.ph';
    require 'openssl/core.ph';
    require 'openssl/x509.ph';
    require 'openssl/pkcs12err.ph';
    unless(defined(&OPENSSL_NO_STDIO)) {
	require 'stdio.ph';
    }
    if(defined(&__cplusplus)) {
    }
    eval 'sub PKCS12_KEY_ID () {1;}' unless defined(&PKCS12_KEY_ID);
    eval 'sub PKCS12_IV_ID () {2;}' unless defined(&PKCS12_IV_ID);
    eval 'sub PKCS12_MAC_ID () {3;}' unless defined(&PKCS12_MAC_ID);
    unless(defined(&PKCS12_DEFAULT_ITER)) {
	eval 'sub PKCS12_DEFAULT_ITER () { &PKCS5_DEFAULT_ITER;}' unless defined(&PKCS12_DEFAULT_ITER);
    }
    eval 'sub PKCS12_MAC_KEY_LENGTH () {20;}' unless defined(&PKCS12_MAC_KEY_LENGTH);
    eval 'sub PKCS12_SALT_LEN () {8;}' unless defined(&PKCS12_SALT_LEN);
    eval 'sub PKCS12_key_gen () { &PKCS12_key_gen_utf8;}' unless defined(&PKCS12_key_gen);
    eval 'sub PKCS12_add_friendlyname () { &PKCS12_add_friendlyname_utf8;}' unless defined(&PKCS12_add_friendlyname);
    eval 'sub KEY_EX () {0x10;}' unless defined(&KEY_EX);
    eval 'sub KEY_SIG () {0x80;}' unless defined(&KEY_SIG);
    eval 'sub sk_PKCS12_SAFEBAG_num {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_num( &ossl_check_const_PKCS12_SAFEBAG_sk_type($sk)));
    }' unless defined(&sk_PKCS12_SAFEBAG_num);
    eval 'sub sk_PKCS12_SAFEBAG_value {
        my($sk, $idx) = @_;
	    eval q((( &PKCS12_SAFEBAG *) &OPENSSL_sk_value( &ossl_check_const_PKCS12_SAFEBAG_sk_type($sk), ($idx))));
    }' unless defined(&sk_PKCS12_SAFEBAG_value);
    eval 'sub sk_PKCS12_SAFEBAG_new {
        my($cmp) = @_;
	    eval q((( &STACK_OF( &PKCS12_SAFEBAG) *) &OPENSSL_sk_new( &ossl_check_PKCS12_SAFEBAG_compfunc_type($cmp))));
    }' unless defined(&sk_PKCS12_SAFEBAG_new);
    eval 'sub sk_PKCS12_SAFEBAG_new_null () {
        eval q((( &STACK_OF( &PKCS12_SAFEBAG) *) &OPENSSL_sk_new_null()));
    }' unless defined(&sk_PKCS12_SAFEBAG_new_null);
    eval 'sub sk_PKCS12_SAFEBAG_new_reserve {
        my($cmp, $n) = @_;
	    eval q((( &STACK_OF( &PKCS12_SAFEBAG) *) &OPENSSL_sk_new_reserve( &ossl_check_PKCS12_SAFEBAG_compfunc_type($cmp), ($n))));
    }' unless defined(&sk_PKCS12_SAFEBAG_new_reserve);
    eval 'sub sk_PKCS12_SAFEBAG_reserve {
        my($sk, $n) = @_;
	    eval q( &OPENSSL_sk_reserve( &ossl_check_PKCS12_SAFEBAG_sk_type($sk), ($n)));
    }' unless defined(&sk_PKCS12_SAFEBAG_reserve);
    eval 'sub sk_PKCS12_SAFEBAG_free {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_free( &ossl_check_PKCS12_SAFEBAG_sk_type($sk)));
    }' unless defined(&sk_PKCS12_SAFEBAG_free);
    eval 'sub sk_PKCS12_SAFEBAG_zero {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_zero( &ossl_check_PKCS12_SAFEBAG_sk_type($sk)));
    }' unless defined(&sk_PKCS12_SAFEBAG_zero);
    eval 'sub sk_PKCS12_SAFEBAG_delete {
        my($sk, $i) = @_;
	    eval q((( &PKCS12_SAFEBAG *) &OPENSSL_sk_delete( &ossl_check_PKCS12_SAFEBAG_sk_type($sk), ($i))));
    }' unless defined(&sk_PKCS12_SAFEBAG_delete);
    eval 'sub sk_PKCS12_SAFEBAG_delete_ptr {
        my($sk, $ptr) = @_;
	    eval q((( &PKCS12_SAFEBAG *) &OPENSSL_sk_delete_ptr( &ossl_check_PKCS12_SAFEBAG_sk_type($sk),  &ossl_check_PKCS12_SAFEBAG_type($ptr))));
    }' unless defined(&sk_PKCS12_SAFEBAG_delete_ptr);
    eval 'sub sk_PKCS12_SAFEBAG_push {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_push( &ossl_check_PKCS12_SAFEBAG_sk_type($sk),  &ossl_check_PKCS12_SAFEBAG_type($ptr)));
    }' unless defined(&sk_PKCS12_SAFEBAG_push);
    eval 'sub sk_PKCS12_SAFEBAG_unshift {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_unshift( &ossl_check_PKCS12_SAFEBAG_sk_type($sk),  &ossl_check_PKCS12_SAFEBAG_type($ptr)));
    }' unless defined(&sk_PKCS12_SAFEBAG_unshift);
    eval 'sub sk_PKCS12_SAFEBAG_pop {
        my($sk) = @_;
	    eval q((( &PKCS12_SAFEBAG *) &OPENSSL_sk_pop( &ossl_check_PKCS12_SAFEBAG_sk_type($sk))));
    }' unless defined(&sk_PKCS12_SAFEBAG_pop);
    eval 'sub sk_PKCS12_SAFEBAG_shift {
        my($sk) = @_;
	    eval q((( &PKCS12_SAFEBAG *) &OPENSSL_sk_shift( &ossl_check_PKCS12_SAFEBAG_sk_type($sk))));
    }' unless defined(&sk_PKCS12_SAFEBAG_shift);
    eval 'sub sk_PKCS12_SAFEBAG_pop_free {
        my($sk, $freefunc) = @_;
	    eval q( &OPENSSL_sk_pop_free( &ossl_check_PKCS12_SAFEBAG_sk_type($sk), &ossl_check_PKCS12_SAFEBAG_freefunc_type($freefunc)));
    }' unless defined(&sk_PKCS12_SAFEBAG_pop_free);
    eval 'sub sk_PKCS12_SAFEBAG_insert {
        my($sk, $ptr, $idx) = @_;
	    eval q( &OPENSSL_sk_insert( &ossl_check_PKCS12_SAFEBAG_sk_type($sk),  &ossl_check_PKCS12_SAFEBAG_type($ptr), ($idx)));
    }' unless defined(&sk_PKCS12_SAFEBAG_insert);
    eval 'sub sk_PKCS12_SAFEBAG_set {
        my($sk, $idx, $ptr) = @_;
	    eval q((( &PKCS12_SAFEBAG *) &OPENSSL_sk_set( &ossl_check_PKCS12_SAFEBAG_sk_type($sk), ($idx),  &ossl_check_PKCS12_SAFEBAG_type($ptr))));
    }' unless defined(&sk_PKCS12_SAFEBAG_set);
    eval 'sub sk_PKCS12_SAFEBAG_find {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find( &ossl_check_PKCS12_SAFEBAG_sk_type($sk),  &ossl_check_PKCS12_SAFEBAG_type($ptr)));
    }' unless defined(&sk_PKCS12_SAFEBAG_find);
    eval 'sub sk_PKCS12_SAFEBAG_find_ex {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find_ex( &ossl_check_PKCS12_SAFEBAG_sk_type($sk),  &ossl_check_PKCS12_SAFEBAG_type($ptr)));
    }' unless defined(&sk_PKCS12_SAFEBAG_find_ex);
    eval 'sub sk_PKCS12_SAFEBAG_find_all {
        my($sk, $ptr, $pnum) = @_;
	    eval q( &OPENSSL_sk_find_all( &ossl_check_PKCS12_SAFEBAG_sk_type($sk),  &ossl_check_PKCS12_SAFEBAG_type($ptr), $pnum));
    }' unless defined(&sk_PKCS12_SAFEBAG_find_all);
    eval 'sub sk_PKCS12_SAFEBAG_sort {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_sort( &ossl_check_PKCS12_SAFEBAG_sk_type($sk)));
    }' unless defined(&sk_PKCS12_SAFEBAG_sort);
    eval 'sub sk_PKCS12_SAFEBAG_is_sorted {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_PKCS12_SAFEBAG_sk_type($sk)));
    }' unless defined(&sk_PKCS12_SAFEBAG_is_sorted);
    eval 'sub sk_PKCS12_SAFEBAG_dup {
        my($sk) = @_;
	    eval q((( &STACK_OF( &PKCS12_SAFEBAG) *) &OPENSSL_sk_dup( &ossl_check_const_PKCS12_SAFEBAG_sk_type($sk))));
    }' unless defined(&sk_PKCS12_SAFEBAG_dup);
    eval 'sub sk_PKCS12_SAFEBAG_deep_copy {
        my($sk, $copyfunc, $freefunc) = @_;
	    eval q((( &STACK_OF( &PKCS12_SAFEBAG) *) &OPENSSL_sk_deep_copy( &ossl_check_const_PKCS12_SAFEBAG_sk_type($sk),  &ossl_check_PKCS12_SAFEBAG_copyfunc_type($copyfunc),  &ossl_check_PKCS12_SAFEBAG_freefunc_type($freefunc))));
    }' unless defined(&sk_PKCS12_SAFEBAG_deep_copy);
    eval 'sub sk_PKCS12_SAFEBAG_set_cmp_func {
        my($sk, $cmp) = @_;
	    eval q((( &sk_PKCS12_SAFEBAG_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_PKCS12_SAFEBAG_sk_type($sk),  &ossl_check_PKCS12_SAFEBAG_compfunc_type($cmp))));
    }' unless defined(&sk_PKCS12_SAFEBAG_set_cmp_func);
    eval 'sub PKCS12_ERROR () {0;}' unless defined(&PKCS12_ERROR);
    eval 'sub PKCS12_OK () {1;}' unless defined(&PKCS12_OK);
    unless(defined(&OPENSSL_NO_DEPRECATED_1_1_0)) {
	eval 'sub M_PKCS12_bag_type () { &PKCS12_bag_type;}' unless defined(&M_PKCS12_bag_type);
	eval 'sub M_PKCS12_cert_bag_type () { &PKCS12_cert_bag_type;}' unless defined(&M_PKCS12_cert_bag_type);
	eval 'sub M_PKCS12_crl_bag_type () { &PKCS12_cert_bag_type;}' unless defined(&M_PKCS12_crl_bag_type);
	eval 'sub PKCS12_certbag2x509 () { &PKCS12_SAFEBAG_get1_cert;}' unless defined(&PKCS12_certbag2x509);
	eval 'sub PKCS12_certbag2scrl () { &PKCS12_SAFEBAG_get1_crl;}' unless defined(&PKCS12_certbag2scrl);
	eval 'sub PKCS12_bag_type () { &PKCS12_SAFEBAG_get_nid;}' unless defined(&PKCS12_bag_type);
	eval 'sub PKCS12_cert_bag_type () { &PKCS12_SAFEBAG_get_bag_nid;}' unless defined(&PKCS12_cert_bag_type);
	eval 'sub PKCS12_x5092certbag () { &PKCS12_SAFEBAG_create_cert;}' unless defined(&PKCS12_x5092certbag);
	eval 'sub PKCS12_x509crl2certbag () { &PKCS12_SAFEBAG_create_crl;}' unless defined(&PKCS12_x509crl2certbag);
	eval 'sub PKCS12_MAKE_KEYBAG () { &PKCS12_SAFEBAG_create0_p8inf;}' unless defined(&PKCS12_MAKE_KEYBAG);
	eval 'sub PKCS12_MAKE_SHKEYBAG () { &PKCS12_SAFEBAG_create_pkcs8_encrypt;}' unless defined(&PKCS12_MAKE_SHKEYBAG);
    }
    unless(defined(&OPENSSL_NO_DEPRECATED_1_1_0)) {
    }
    unless(defined(&OPENSSL_NO_STDIO)) {
    }
    unless(defined(&OPENSSL_NO_STDIO)) {
    }
    if(defined(&__cplusplus)) {
    }
}
1;
