/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.util.pool;

import java.util.LinkedList;
import java.util.Queue;
import org.campagnelab.goby.util.pool.Resettable;
import org.campagnelab.goby.util.pool.ResettableObjectPoolInterface;

public abstract class QueueResettableObjectPool<T extends Resettable>
implements ResettableObjectPoolInterface<T> {
    private final Queue<T> queue = new LinkedList<T>();
    private int numActive;

    @Override
    public abstract T makeObject();

    @Override
    public T borrowObject() {
        Object t = this.queue.isEmpty() ? this.makeObject() : (Resettable)this.queue.poll();
        ++this.numActive;
        return t;
    }

    @Override
    public void returnObject(T t) {
        t.reset();
        this.queue.add(t);
        --this.numActive;
    }

    @Override
    public void invalidateObject(T t) {
        t.reset();
        --this.numActive;
    }

    @Override
    public int getNumIdle() {
        return this.queue.size();
    }

    @Override
    public int getNumActive() {
        return this.numActive;
    }

    @Override
    public void clear() {
        this.queue.clear();
    }
}

