// Copyright (c) 1999-2018 David Muse
// See the COPYING file for more information.

#ifndef RUDIMENTS_SHA1_H
#define RUDIMENTS_SHA1_H

#include <rudiments/private/sha1includes.h>

/** The sha1 class provides a simple sha1 implementation. */
class RUDIMENTS_DLLSPEC sha1 : public hash {
	public:
		/** Creates an instance of the sha1 class. */
		sha1();

		/** Deletes this instance of the sha1 class. */
		virtual	~sha1();

		/** Appends "size" bytes of "data" to the data to be
		 *  hashed.  Returns true on success or false if an error
		 *  occurred. */
		bool	append(const unsigned char *data, uint32_t size);

		/** Returns the current hash on success or NULL if an error
		 *  occurred.  Note that the current hash will be an empty
		 *  string if no data has been appended yet. */
		const unsigned char	*getHash();

		/** Returns the number of bytes in the hash. */
		uint64_t	getHashSize();

		/** Clears the current hash and any data that had
 		 *  previously been appended.  Returns true on success or
 		 *  false if an error occurred. */
		bool	clear();

		/** Returns the most recent error. */
		hasherror_t	getError();

	#include <rudiments/private/sha1.h>
};

#endif
