require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_AMIGA_BUS_H_)) {
    eval 'sub _AMIGA_BUS_H_ () {1;}' unless defined(&_AMIGA_BUS_H_);
    require 'sys/types.ph';
    eval 'sub PRIxBUSADDR () {"x";}' unless defined(&PRIxBUSADDR);
    eval 'sub PRIxBUSSIZE () {"x";}' unless defined(&PRIxBUSSIZE);
    eval 'sub PRIuBUSSIZE () {"u";}' unless defined(&PRIuBUSSIZE);
    eval 'sub PRIxBSH () {"lx";}' unless defined(&PRIxBSH);
    eval 'sub bsr {
        my($what, $typ) = @_;
	    eval q($typ ($what)( &bus_space_handle_t,  &bus_addr_t));
    }' unless defined(&bsr);
    eval 'sub bsw {
        my($what, $typ) = @_;
	    eval q( &void ($what)( &bus_space_handle_t,  &bus_addr_t, \'unsigned\'));
    }' unless defined(&bsw);
    eval 'sub bsrm {
        my($what, $typ) = @_;
	    eval q( &void ($what)( &bus_space_handle_t,  &bus_size_t, $typ *,  &bus_size_t));
    }' unless defined(&bsrm);
    eval 'sub bswm {
        my($what, $typ) = @_;
	    eval q( &void ($what)( &bus_space_handle_t,  &bus_size_t,  &const $typ *,  &bus_size_t));
    }' unless defined(&bswm);
    eval 'sub bssr {
        my($what, $typ) = @_;
	    eval q( &void ($what)( &bus_space_handle_t,  &bus_size_t, \'unsigned\',  &bus_size_t));
    }' unless defined(&bssr);
    eval 'sub bscr {
        my($what, $typ) = @_;
	    eval q( &void ($what)( &bus_space_handle_t,  &bus_size_t,  &bus_space_handle_t,  &bus_size_t,  &bus_size_t));
    }' unless defined(&bscr);
    eval 'sub bus_space_map {
        my($t, $o, $s, $f, $hp) = @_;
	    eval q((($t)-> ($absm->{b$sm}))(($t), ($o), ($s), ($f), ($hp)));
    }' unless defined(&bus_space_map);
    eval 'sub bus_space_subregion {
        my($t, $h, $o, $s, $hp) = @_;
	    eval q((($t)-> ($absm->{b$sms}))(($h), ($o), ($s), ($hp)));
    }' unless defined(&bus_space_subregion);
    eval 'sub bus_space_unmap {
        my($t, $h, $s) = @_;
	    eval q((($t)-> ($absm->{b$su}))(($h), ($s)));
    }' unless defined(&bus_space_unmap);
    eval 'sub dbsdr {
        my($n, $t, $h, $o) = @_;
	    eval q((($t)-> ($absm->{n}))(($h), ($o)));
    }' unless defined(&dbsdr);
    eval 'sub dbsdw {
        my($n, $t, $h, $o, $v) = @_;
	    eval q((($t)-> ($absm->{n}))(($h), ($o), ($v)));
    }' unless defined(&dbsdw);
    eval 'sub dbsm {
        my($n, $t, $h, $o, $p, $c) = @_;
	    eval q((($t)-> ($absm->{n}))(($h), ($o), ($p), ($c)));
    }' unless defined(&dbsm);
    eval 'sub dbss {
        my($n, $t, $h, $o, $v, $c) = @_;
	    eval q((($t)-> ($absm->{n}))(($h), ($o), ($v), ($c)));
    }' unless defined(&dbss);
    eval 'sub dbsc {
        my($n, $t, $h, $o, $v, $c) = @_;
	    eval q((($t)-> ($absm->{n}))(($h), ($o), ($v), ($c)));
    }' unless defined(&dbsc);
    eval 'sub bus_space_read_1 {
        my($t, $h, $o) = @_;
	    eval q( &dbsdr( &bsr1, $t, $h, $o));
    }' unless defined(&bus_space_read_1);
    eval 'sub bus_space_write_1 {
        my($t, $h, $o, $v) = @_;
	    eval q( &dbsdw( &bsw1, $t, $h, $o, $v));
    }' unless defined(&bus_space_write_1);
    eval 'sub bus_space_read_multi_1 {
        my($t, $h, $o, $p, $c) = @_;
	    eval q( &dbsm( &bsrm1, $t, $h, $o, $p, $c));
    }' unless defined(&bus_space_read_multi_1);
    eval 'sub bus_space_write_multi_1 {
        my($t, $h, $o, $p, $c) = @_;
	    eval q( &dbsm( &bswm1, $t, $h, $o, $p, $c));
    }' unless defined(&bus_space_write_multi_1);
    eval 'sub bus_space_read_region_1 {
        my($t, $h, $o, $p, $c) = @_;
	    eval q( &dbsm( &bsrr1, $t, $h, $o, $p, $c));
    }' unless defined(&bus_space_read_region_1);
    eval 'sub bus_space_write_region_1 {
        my($t, $h, $o, $p, $c) = @_;
	    eval q( &dbsm( &bswr1, $t, $h, $o, $p, $c));
    }' unless defined(&bus_space_write_region_1);
    eval 'sub bus_space_set_region_1 {
        my($t, $h, $o, $v, $c) = @_;
	    eval q( &dbss( &bssr1, $t, $h, $o, $v, $c));
    }' unless defined(&bus_space_set_region_1);
    eval 'sub bus_space_copy_region_1 {
        my($t, $h, $o, $g, $q, $c) = @_;
	    eval q( &dbss( &bscr1, $t, $h, $o, $g, $q, $c));
    }' unless defined(&bus_space_copy_region_1);
    eval 'sub bus_space_read_2 {
        my($t, $h, $o) = @_;
	    eval q( &dbsdr( &bsr2, $t, $h, $o));
    }' unless defined(&bus_space_read_2);
    eval 'sub bus_space_write_2 {
        my($t, $h, $o, $v) = @_;
	    eval q( &dbsdw( &bsw2, $t, $h, $o, $v));
    }' unless defined(&bus_space_write_2);
    eval 'sub bus_space_read_stream_2 {
        my($t, $h, $o) = @_;
	    eval q( &dbsdr( &bsrs2, $t, $h, $o));
    }' unless defined(&bus_space_read_stream_2);
    eval 'sub bus_space_write_stream_2 {
        my($t, $h, $o, $v) = @_;
	    eval q( &dbsdw( &bsws2, $t, $h, $o, $v));
    }' unless defined(&bus_space_write_stream_2);
    eval 'sub bus_space_read_multi_2 {
        my($t, $h, $o, $p, $c) = @_;
	    eval q( &dbsm( &bsrm2, $t, $h, $o, $p, $c));
    }' unless defined(&bus_space_read_multi_2);
    eval 'sub bus_space_write_multi_2 {
        my($t, $h, $o, $p, $c) = @_;
	    eval q( &dbsm( &bswm2, $t, $h, $o, $p, $c));
    }' unless defined(&bus_space_write_multi_2);
    eval 'sub bus_space_read_multi_stream_2 {
        my($t, $h, $o, $p, $c) = @_;
	    eval q( &dbsm( &bsrms2, $t, $h, $o, $p, $c));
    }' unless defined(&bus_space_read_multi_stream_2);
    eval 'sub bus_space_write_multi_stream_2 {
        my($t, $h, $o, $p, $c) = @_;
	    eval q( &dbsm( &bswms2, $t, $h, $o, $p, $c));
    }' unless defined(&bus_space_write_multi_stream_2);
    eval 'sub bus_space_read_region_2 {
        my($t, $h, $o, $p, $c) = @_;
	    eval q( &dbsm( &bsrr2, $t, $h, $o, $p, $c));
    }' unless defined(&bus_space_read_region_2);
    eval 'sub bus_space_write_region_2 {
        my($t, $h, $o, $p, $c) = @_;
	    eval q( &dbsm( &bswr2, $t, $h, $o, $p, $c));
    }' unless defined(&bus_space_write_region_2);
    eval 'sub bus_space_read_region_stream_2 {
        my($t, $h, $o, $p, $c) = @_;
	    eval q( &dbsm( &bsrrs2, $t, $h, $o, $p, $c));
    }' unless defined(&bus_space_read_region_stream_2);
    eval 'sub bus_space_write_region_stream_2 {
        my($t, $h, $o, $p, $c) = @_;
	    eval q( &dbsm( &bswrs2, $t, $h, $o, $p, $c));
    }' unless defined(&bus_space_write_region_stream_2);
    eval 'sub bus_space_set_region_2 {
        my($t, $h, $o, $v, $c) = @_;
	    eval q( &dbss( &bssr2, $t, $h, $o, $v, $c));
    }' unless defined(&bus_space_set_region_2);
    eval 'sub bus_space_copy_region_2 {
        my($t, $h, $o, $g, $q, $c) = @_;
	    eval q( &dbss( &bscr2, $t, $h, $o, $g, $q, $c));
    }' unless defined(&bus_space_copy_region_2);
    eval 'sub bus_space_read_4 {
        my($t, $h, $o) = @_;
	    eval q( &dbsdr( &bsr4, $t, $h, $o));
    }' unless defined(&bus_space_read_4);
    eval 'sub bus_space_write_4 {
        my($t, $h, $o, $v) = @_;
	    eval q( &dbsdw( &bsw4, $t, $h, $o, $v));
    }' unless defined(&bus_space_write_4);
    eval 'sub bus_space_read_stream_4 {
        my($t, $h, $o) = @_;
	    eval q( &dbsdr( &bsrs4, $t, $h, $o));
    }' unless defined(&bus_space_read_stream_4);
    eval 'sub bus_space_write_stream_4 {
        my($t, $h, $o, $v) = @_;
	    eval q( &dbsdw( &bsws4, $t, $h, $o, $v));
    }' unless defined(&bus_space_write_stream_4);
    eval 'sub bus_space_read_multi_4 {
        my($t, $h, $o, $p, $c) = @_;
	    eval q( &dbsm( &bsrm4, $t, $h, $o, $p, $c));
    }' unless defined(&bus_space_read_multi_4);
    eval 'sub bus_space_write_multi_4 {
        my($t, $h, $o, $p, $c) = @_;
	    eval q( &dbsm( &bswm4, $t, $h, $o, $p, $c));
    }' unless defined(&bus_space_write_multi_4);
    eval 'sub bus_space_read_multi_stream_4 {
        my($t, $h, $o, $p, $c) = @_;
	    eval q( &dbsm( &bsrms4, $t, $h, $o, $p, $c));
    }' unless defined(&bus_space_read_multi_stream_4);
    eval 'sub bus_space_write_multi_stream_4 {
        my($t, $h, $o, $p, $c) = @_;
	    eval q( &dbsm( &bswms4, $t, $h, $o, $p, $c));
    }' unless defined(&bus_space_write_multi_stream_4);
    eval 'sub bus_space_read_region_4 {
        my($t, $h, $o, $p, $c) = @_;
	    eval q( &dbsm( &bsrr4, $t, $h, $o, $p, $c));
    }' unless defined(&bus_space_read_region_4);
    eval 'sub bus_space_write_region_4 {
        my($t, $h, $o, $p, $c) = @_;
	    eval q( &dbsm( &bswr4, $t, $h, $o, $p, $c));
    }' unless defined(&bus_space_write_region_4);
    eval 'sub bus_space_read_region_stream_4 {
        my($t, $h, $o, $p, $c) = @_;
	    eval q( &dbsm( &bsrrs4, $t, $h, $o, $p, $c));
    }' unless defined(&bus_space_read_region_stream_4);
    eval 'sub bus_space_write_region_stream_4 {
        my($t, $h, $o, $p, $c) = @_;
	    eval q( &dbsm( &bswrs4, $t, $h, $o, $p, $c));
    }' unless defined(&bus_space_write_region_stream_4);
    eval 'sub bus_space_set_region_4 {
        my($t, $h, $o, $v, $c) = @_;
	    eval q( &dbss( &bssr4, $t, $h, $o, $v, $c));
    }' unless defined(&bus_space_set_region_4);
    eval 'sub bus_space_copy_region_4 {
        my($t, $h, $o, $g, $q, $c) = @_;
	    eval q( &dbss( &bscr4, $t, $h, $o, $g, $q, $c));
    }' unless defined(&bus_space_copy_region_4);
    eval 'sub BUS_SPACE_BARRIER_READ () {0x1;}' unless defined(&BUS_SPACE_BARRIER_READ);
    eval 'sub BUS_SPACE_BARRIER_WRITE () {0x2;}' unless defined(&BUS_SPACE_BARRIER_WRITE);
    eval 'sub BUS_SPACE_ALIGNED_POINTER {
        my($p, $t) = @_;
	    eval q( &ALIGNED_POINTER($p, $t));
    }' unless defined(&BUS_SPACE_ALIGNED_POINTER);
    eval 'sub __BUS_SPACE_HAS_STREAM_METHODS () {1;}' unless defined(&__BUS_SPACE_HAS_STREAM_METHODS);
    eval 'sub BUS_SPACE_MAP_CACHEABLE () {0x1;}' unless defined(&BUS_SPACE_MAP_CACHEABLE);
    eval 'sub BUS_SPACE_MAP_LINEAR () {0x2;}' unless defined(&BUS_SPACE_MAP_LINEAR);
    eval 'sub BUS_SPACE_MAP_PREFETCHABLE () {0x4;}' unless defined(&BUS_SPACE_MAP_PREFETCHABLE);
    eval 'sub amiga_bus_reorder_protect () {
        eval q();
    }' unless defined(&amiga_bus_reorder_protect);
    require 'm68k/bus_dma.ph';
}
1;
