/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.event.SearchableEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class TableSearchable
extends Searchable
implements TableModelListener,
PropertyChangeListener {
    private int[] _searchColumnIndices = new int[]{0};

    public TableSearchable(JTable table) {
        super(table);
    }

    @Override
    public void installListeners() {
        super.installListeners();
        if (this._component instanceof JTable) {
            ((JTable)this._component).getModel().addTableModelListener(this);
            this._component.addPropertyChangeListener("model", this);
        }
    }

    @Override
    public void uninstallListeners() {
        super.uninstallListeners();
        if (this._component instanceof JTable) {
            ((JTable)this._component).getModel().removeTableModelListener(this);
            this._component.removePropertyChangeListener("model", this);
        }
    }

    @Override
    protected void setSelectedIndex(int index, boolean incremental) {
        JTable table = (JTable)this._component;
        if (this.isColumnSelectionAllowed(table)) {
            int minorIndex = index;
            int majorIndex = this.getMainIndex();
            this.addTableSelection(table, majorIndex, minorIndex, incremental);
        } else if (this.isRowSelectionAllowed(table)) {
            int majorIndex = index;
            int minorIndex = table.convertColumnIndexToView(this.getMainIndex());
            this.addTableSelection(table, majorIndex, minorIndex, incremental);
        } else {
            int columnCount = table.getColumnCount();
            if (columnCount == 0) {
                return;
            }
            int majorIndex = index / columnCount;
            int minorIndex = index % columnCount;
            this.addTableSelection(table, majorIndex, minorIndex, incremental);
        }
    }

    protected void addTableSelection(JTable table, int rowIndex, int columnIndex, boolean incremental) {
        if (!incremental) {
            table.clearSelection();
        }
        if (rowIndex >= 0 && columnIndex >= 0 && rowIndex < table.getRowCount() && columnIndex < table.getColumnCount() && !table.isCellSelected(rowIndex, columnIndex)) {
            table.changeSelection(rowIndex, columnIndex, true, false);
        }
    }

    protected boolean isColumnSelectionAllowed(JTable table) {
        return this.getSearchColumnIndices().length == 1 && table.getColumnSelectionAllowed() && !table.getRowSelectionAllowed();
    }

    protected boolean isRowSelectionAllowed(JTable table) {
        return this.getSearchColumnIndices().length == 1 && !table.getColumnSelectionAllowed() && table.getRowSelectionAllowed();
    }

    protected boolean isSearchSelectedRows() {
        return this.getSearchColumnIndices().length > 1;
    }

    @Override
    protected int getSelectedIndex() {
        JTable table = (JTable)this._component;
        if (this.isColumnSelectionAllowed(table)) {
            return table.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
        }
        if (this.isRowSelectionAllowed(table)) {
            return table.getSelectionModel().getAnchorSelectionIndex();
        }
        return table.getSelectionModel().getAnchorSelectionIndex() * table.getColumnCount() + table.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
    }

    @Override
    protected Object getElementAt(int index) {
        JTable table = (JTable)this._component;
        if (this.isColumnSelectionAllowed(table)) {
            return this.getValueAt(table, this.getMainIndex(), index);
        }
        if (this.isRowSelectionAllowed(table)) {
            return this.getValueAt(table, index, table.convertColumnIndexToView(this.getMainIndex()));
        }
        if (this.isSearchSelectedRows()) {
            int columnIndex = index % table.getColumnCount();
            int modelIndex = table.convertColumnIndexToModel(columnIndex);
            boolean doNotSearch = true;
            for (int i : this.getSearchColumnIndices()) {
                if (i != modelIndex) continue;
                doNotSearch = false;
            }
            if (doNotSearch) {
                return null;
            }
            int rowIndex = index / table.getColumnCount();
            return this.getValueAt(table, rowIndex, columnIndex);
        }
        int columnIndex = index % table.getColumnCount();
        int rowIndex = index / table.getColumnCount();
        return this.getValueAt(table, rowIndex, columnIndex);
    }

    protected Object getValueAt(JTable table, int rowIndex, int columnIndex) {
        if (rowIndex >= 0 && rowIndex < table.getRowCount() && columnIndex >= 0 && columnIndex < table.getColumnCount()) {
            return table.getValueAt(rowIndex, columnIndex);
        }
        return null;
    }

    @Override
    protected int getElementCount() {
        JTable table = (JTable)this._component;
        if (this.isColumnSelectionAllowed(table)) {
            return table.getColumnCount();
        }
        if (this.isRowSelectionAllowed(table)) {
            return table.getRowCount();
        }
        return table.getColumnCount() * table.getRowCount();
    }

    @Override
    protected String convertElementToString(Object item) {
        if (item != null) {
            return item.toString();
        }
        return "";
    }

    public int[] getSearchColumnIndices() {
        return this._searchColumnIndices;
    }

    public int getMainIndex() {
        if (this._searchColumnIndices.length == 0) {
            return -1;
        }
        return this._searchColumnIndices[0];
    }

    public void setSearchColumnIndices(int[] columnIndices) {
        int[] old;
        if (columnIndices == null) {
            columnIndices = new int[]{};
        }
        if (!JideSwingUtilities.equals(old = this._searchColumnIndices, columnIndices, true)) {
            this._searchColumnIndices = columnIndices;
            this.hidePopup();
        }
    }

    public void setMainIndex(int mainIndex) {
        int[] old;
        int[] temp = new int[]{mainIndex};
        if (mainIndex < 0) {
            temp = new int[]{};
        }
        if ((old = this._searchColumnIndices) != temp) {
            this._searchColumnIndices = temp;
            this.hidePopup();
        }
    }

    @Override
    protected boolean isFindNextKey(KeyEvent e) {
        int keyCode = e.getKeyCode();
        JTable table = (JTable)this._component;
        if (this.isColumnSelectionAllowed(table)) {
            return keyCode == 39;
        }
        if (this.isRowSelectionAllowed(table)) {
            return keyCode == 40;
        }
        return keyCode == 40 || keyCode == 39;
    }

    @Override
    protected boolean isFindPreviousKey(KeyEvent e) {
        int keyCode = e.getKeyCode();
        JTable table = (JTable)this._component;
        if (this.isColumnSelectionAllowed(table)) {
            return keyCode == 37;
        }
        if (this.isRowSelectionAllowed(table)) {
            return keyCode == 38;
        }
        return keyCode == 38 || keyCode == 37;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.isProcessModelChangeEvent()) {
            this.hidePopup();
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("model".equals(evt.getPropertyName())) {
            this.hidePopup();
            if (evt.getOldValue() instanceof TableModel) {
                ((TableModel)evt.getOldValue()).removeTableModelListener(this);
            }
            if (evt.getNewValue() instanceof TableModel) {
                ((TableModel)evt.getNewValue()).addTableModelListener(this);
            }
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    @Override
    protected boolean isActivateKey(KeyEvent e) {
        boolean editable = this.isSelectedCellEditable();
        return !editable && super.isActivateKey(e);
    }

    protected boolean isSelectedCellEditable() {
        int selectedRow = ((JTable)this._component).getSelectedRow();
        int selectedColumn = ((JTable)this._component).getSelectedColumn();
        return selectedRow != -1 && selectedColumn != -1 && ((JTable)this._component).isCellEditable(selectedRow, selectedColumn);
    }
}

