/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.Option;
import com.martiansoftware.jsap.StringParser;

public final class UnflaggedOption
extends Option {
    private boolean greedy = false;

    public UnflaggedOption(String id) {
        super(id);
    }

    public UnflaggedOption(String id, StringParser stringParser, String defaultValue, boolean required, boolean greedy, String help) {
        this(id);
        this.setStringParser(stringParser);
        this.setDefault(defaultValue);
        this.setRequired(required);
        this.setGreedy(greedy);
        this.setHelp(help);
    }

    public UnflaggedOption(String id, StringParser stringParser, String defaultValue, boolean required, boolean greedy) {
        this(id);
        this.setStringParser(stringParser);
        this.setDefault(defaultValue);
        this.setRequired(required);
        this.setGreedy(greedy);
    }

    public UnflaggedOption(String id, StringParser stringParser, boolean required, String help) {
        this(id);
        this.setStringParser(stringParser);
        this.setRequired(required);
        this.setGreedy(false);
        this.setHelp(help);
    }

    public UnflaggedOption setGreedy(boolean greedy) {
        this.enforceParameterLock();
        this.greedy = greedy;
        return this;
    }

    public UnflaggedOption setUsageName(String usageName) {
        this._setUsageName(usageName);
        return this;
    }

    public boolean isGreedy() {
        return this.greedy;
    }

    @Override
    public String getSyntax() {
        StringBuffer result = new StringBuffer();
        if (!this.required()) {
            result.append("[");
        }
        String un = this.getUsageName();
        if (this.isGreedy()) {
            result.append(un + "1" + JSAP.SYNTAX_SPACECHAR + un + "2" + JSAP.SYNTAX_SPACECHAR + "..." + JSAP.SYNTAX_SPACECHAR + un + "N");
        } else {
            result.append("<" + un + ">");
        }
        if (!this.required()) {
            result.append("]");
        }
        return result.toString();
    }

    public UnflaggedOption setList(boolean isList) {
        super.internalSetList(isList);
        return this;
    }

    public UnflaggedOption setListSeparator(char listSeparator) {
        super.internalSetListSeparator(listSeparator);
        return this;
    }

    public UnflaggedOption setRequired(boolean required) {
        super.internalSetRequired(required);
        return this;
    }

    public UnflaggedOption setStringParser(StringParser stringParser) {
        super.internalSetStringParser(stringParser);
        return this;
    }

    public UnflaggedOption setDefault(String defaultValue) {
        this._setDefault(defaultValue);
        return this;
    }

    public UnflaggedOption setDefault(String[] defaultValues) {
        this._setDefault(defaultValues);
        return this;
    }
}

