#ifndef	_ETM_H

#define	_ETM_H

/*
 * etm.h - Exception and Termination Manager header file
 */


/*
 * Values that can be passed to ETMSetSignalProc() to turn off signals
 * or restore to default action.  Pretty ugly.  Hope no one ever uses
 * them!  (Because depending on the compiler, it's possible these may
 * actually be the same...)
 */

# define	ETMSigDefault	(void (*)())0
# define	ETMSigIgnore	(void (*)())1


typedef	void	ETMProcRetType;
typedef	ETMProcRetType (*ETMProcPtr) ();


/*
 * These defines cause failure at link time if this header
 * file wasn't included in each source file using ETM functions.
 */

# define	ETMInit			_ETMInit
# define	ETMEnd			_ETMEnd
# define	ETMAddShutdownProc	_ETMAddShutdownProc
# define	ETMRemoveShutdownProc	_ETMRemoveShutdownProc
# define	ETMSetSignalProc	_ETMSetSignalProc
# define	ETMGetSignalProc	_ETMGetSignalProc
# define	ETMSetPrintProc		_ETMSetPrintProc
# define	ETMGetPrintProc		_ETMGetPrintProc
# define	ETMSetExitStatus	_ETMSetExitStatus
# define	ETMGetExitStatus	_ETMGetExitStatus
# define	ETMSetAbort		_ETMSetAbort
# define	ETMGetAbort		_ETMGetAbort
# define	ETMPanic		_ETMPanic
# define	ETMMsg			_ETMMsg


/* Public routines */

extern ETMProcRetType	ETMInit ();
extern ETMProcRetType	ETMEnd ();
extern ETMProcRetType	ETMAddShutdownProc ();
extern ETMProcRetType	ETMRemoveShutdownProc ();
extern ETMProcRetType	ETMSetSignalProc ();
extern ETMProcPtr	ETMGetSignalProc ();
extern ETMProcRetType	ETMSetPrintProc ();
extern ETMProcPtr	ETMGetPrintProc ();
extern ETMProcRetType	ETMSetExitStatus ();
extern int		ETMGetExitStatus ();
extern ETMProcRetType	ETMSetAbort ();
extern int		ETMGetAbort ();
#if __STDC__
extern ETMProcRetType	ETMPanic (char *fmt,...);
extern ETMProcRetType	ETMMsg (char *fmt,...);
#else
extern ETMProcRetType	ETMPanic ();
extern ETMProcRetType	ETMMsg ();
#endif

/* backward-compatibility defines */

# define	ETMShutdownRegister	ETMAddShutdownProc
# define	ETMShutdownDeregister	ETMRemoveShutdownProc
# define	ETMSignalRegister	ETMSetSignalProc
# define	ETMPrintRegister	ETMSetPrintProc
# define	ETMStatusRegister	ETMSetExitStatus

#endif	/* _ETM_H */
