/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.dom.bootstrap;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DOMImplementationList;
import org.w3c.dom.DOMImplementationSource;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class DOMImplementationRegistry {
    public static final String PROPERTY = "org.w3c.dom.DOMImplementationSourceList";
    private static final int DEFAULT_LINE_LENGTH = 80;
    private Vector sources;
    static /* synthetic */ Class class$org$w3c$dom$bootstrap$DOMImplementationRegistry;

    public static final DOMImplementationRegistry newInstance() throws ClassNotFoundException, InstantiationException, IllegalAccessException, ClassCastException {
        Vector sources = new Vector();
        ClassLoader classLoader = DOMImplementationRegistry.getClassLoader();
        String p = DOMImplementationRegistry.getSystemProperty(PROPERTY);
        if (p == null) {
            p = DOMImplementationRegistry.getServiceValue(classLoader);
        }
        if (p == null) {
            p = "gnu.xml.dom.ImplementationSource";
        }
        if (p != null) {
            StringTokenizer st = new StringTokenizer(p);
            while (st.hasMoreTokens()) {
                String sourceName = st.nextToken();
                Class sourceClass = null;
                sourceClass = classLoader != null ? classLoader.loadClass(sourceName) : Class.forName(sourceName);
                DOMImplementationSource source = (DOMImplementationSource)sourceClass.newInstance();
                sources.addElement(source);
            }
        }
        return new DOMImplementationRegistry(sources);
    }

    public final DOMImplementation getDOMImplementation(String features) {
        int size = this.sources.size();
        Object name = null;
        int i = 0;
        while (i < size) {
            DOMImplementationSource source = (DOMImplementationSource)this.sources.elementAt(i);
            DOMImplementation impl = source.getDOMImplementation(features);
            if (impl != null) {
                return impl;
            }
            ++i;
        }
        return null;
    }

    public final DOMImplementationList getDOMImplementationList(String features) {
        final Vector implementations = new Vector();
        int size = this.sources.size();
        int i = 0;
        while (i < size) {
            DOMImplementationSource source = (DOMImplementationSource)this.sources.elementAt(i);
            DOMImplementationList impls = source.getDOMImplementationList(features);
            int j = 0;
            while (j < impls.getLength()) {
                DOMImplementation impl = impls.item(j);
                implementations.addElement(impl);
                ++j;
            }
            ++i;
        }
        return new DOMImplementationList(){

            public final DOMImplementation item(int index) {
                if (index >= 0 && index < implementations.size()) {
                    try {
                        return (DOMImplementation)implementations.elementAt(index);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        return null;
                    }
                }
                return null;
            }

            public final int getLength() {
                return implementations.size();
            }
        };
    }

    public final void addSource(DOMImplementationSource s) {
        if (s == null) {
            throw new NullPointerException();
        }
        if (!this.sources.contains(s)) {
            this.sources.addElement(s);
        }
    }

    private static final ClassLoader getClassLoader() {
        try {
            ClassLoader contextClassLoader = DOMImplementationRegistry.getContextClassLoader();
            if (contextClassLoader != null) {
                return contextClassLoader;
            }
        }
        catch (Exception e) {
            Class clazz = class$org$w3c$dom$bootstrap$DOMImplementationRegistry;
            if (clazz == null) {
                clazz = class$org$w3c$dom$bootstrap$DOMImplementationRegistry = DOMImplementationRegistry.class("[Lorg.w3c.dom.bootstrap.DOMImplementationRegistry;", false);
            }
            return clazz.getClassLoader();
        }
        Class clazz = class$org$w3c$dom$bootstrap$DOMImplementationRegistry;
        if (clazz == null) {
            clazz = class$org$w3c$dom$bootstrap$DOMImplementationRegistry = DOMImplementationRegistry.class("[Lorg.w3c.dom.bootstrap.DOMImplementationRegistry;", false);
        }
        return clazz.getClassLoader();
    }

    private static final String getServiceValue(ClassLoader classLoader) {
        block5: {
            String serviceId = "META-INF/services/org.w3c.dom.DOMImplementationSourceList";
            try {
                BufferedReader rd;
                InputStream is = DOMImplementationRegistry.getResourceAsStream(classLoader, serviceId);
                if (is == null) break block5;
                try {
                    rd = new BufferedReader(new InputStreamReader(is, "UTF-8"), 80);
                }
                catch (UnsupportedEncodingException e) {
                    rd = new BufferedReader(new InputStreamReader(is), 80);
                }
                String serviceValue = rd.readLine();
                rd.close();
                if (serviceValue != null && serviceValue.length() > 0) {
                    return serviceValue;
                }
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    private static final boolean isJRE11() {
        try {
            Class c = Class.forName("java.security.AccessController");
            return false;
        }
        catch (Exception exception) {
            return true;
        }
    }

    private static final ClassLoader getContextClassLoader() {
        return DOMImplementationRegistry.isJRE11() ? null : (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public final Object run() {
                ClassLoader classLoader = null;
                try {
                    classLoader = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return classLoader;
            }
        });
    }

    private static final String getSystemProperty(final String name) {
        return DOMImplementationRegistry.isJRE11() ? System.getProperty(name) : (String)AccessController.doPrivileged(new PrivilegedAction(){

            public final Object run() {
                return System.getProperty(name);
            }
        });
    }

    private static final InputStream getResourceAsStream(final ClassLoader classLoader, final String name) {
        if (DOMImplementationRegistry.isJRE11()) {
            InputStream ris = classLoader == null ? ClassLoader.getSystemResourceAsStream(name) : classLoader.getResourceAsStream(name);
            return ris;
        }
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public final Object run() {
                InputStream ris = classLoader == null ? ClassLoader.getSystemResourceAsStream(name) : classLoader.getResourceAsStream(name);
                return ris;
            }
        });
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private DOMImplementationRegistry(Vector srcs) {
        this.sources = srcs;
    }
}

