/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.XYPlotRenderer;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;

public class LineplotRenderer
extends XYPlotRenderer {
    @Override
    public void renderScores(Track track, List<LocusScore> locusScores, RenderContext context, Rectangle arect) {
        if (locusScores.size() == 0) {
            return;
        }
        Rectangle adjustedRect = this.calculateDrawingRect(arect);
        double origin = context.getOrigin();
        double locScale = context.getScale();
        Color posColor = track.getColor();
        Color negColor = track.getAltColor();
        Graphics2D gPos = context.getGraphic2DForColor(posColor);
        Graphics2D gNeg = context.getGraphic2DForColor(negColor);
        DataRange axisDefinition = track.getDataRange();
        float maxValue = axisDefinition.getMaximum();
        float baseValue = axisDefinition.getBaseline();
        float minValue = axisDefinition.getMinimum();
        double yScaleFactor = adjustedRect.getHeight() / (double)(maxValue - minValue);
        int lastPx = (int)(((double)locusScores.get(0).getStart() - origin) / locScale);
        int lastPy = (int)(adjustedRect.getY() + (double)(maxValue - 0.0f) * yScaleFactor);
        for (LocusScore score : locusScores) {
            float dataY = score.getScore();
            if (Float.isNaN(dataY)) continue;
            double x = ((double)score.getStart() - origin) / locScale;
            double dx = (double)(score.getEnd() - score.getStart()) / locScale;
            int pX = (int)x;
            int pY = (int)(adjustedRect.getY() + (double)(maxValue - dataY) * yScaleFactor);
            double slope = ((double)pY - (double)lastPy) / (double)(pX - lastPx);
            int clippedLastPX = lastPx;
            int clippedLastPY = lastPy;
            if (lastPy < adjustedRect.y || lastPy > adjustedRect.y + adjustedRect.height) {
                clippedLastPY = lastPy < adjustedRect.y ? adjustedRect.y : adjustedRect.y + adjustedRect.height;
                clippedLastPX = lastPx + (int)((double)(clippedLastPY - lastPy) / slope);
            }
            int clippedPX = pX;
            int clippedPY = pY;
            if (pY < adjustedRect.y || pY > adjustedRect.y + adjustedRect.height) {
                clippedPY = (double)pY < adjustedRect.getMinY() ? adjustedRect.y : adjustedRect.y + adjustedRect.height;
                clippedPX = lastPx + (int)((double)(clippedPY - lastPy) / slope);
            }
            Graphics2D g = dataY >= 0.0f ? gPos : gNeg;
            g.drawLine(clippedLastPX, clippedLastPY, clippedPX, clippedPY);
            if (dx >= 1.0 && clippedPY == pY) {
                g.drawLine(pX, clippedPY, (int)((double)pX + dx), clippedPY);
            }
            lastPx = (int)((double)pX + dx);
            lastPy = pY;
            if (!((double)lastPx > adjustedRect.getMaxX())) continue;
            break;
        }
    }
}

