require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&HEADER_BIO_H)) {
    eval 'sub HEADER_BIO_H () {1;}' unless defined(&HEADER_BIO_H);
    require 'openssl/e_os2.ph';
    unless(defined(&OPENSSL_NO_STDIO)) {
	require 'stdio.ph';
    }
    require 'stdarg.ph';
    require 'openssl/crypto.ph';
    require 'openssl/bioerr.ph';
    if(defined(&__cplusplus)) {
    }
    eval 'sub BIO_TYPE_DESCRIPTOR () {0x100;}' unless defined(&BIO_TYPE_DESCRIPTOR);
    eval 'sub BIO_TYPE_FILTER () {0x200;}' unless defined(&BIO_TYPE_FILTER);
    eval 'sub BIO_TYPE_SOURCE_SINK () {0x400;}' unless defined(&BIO_TYPE_SOURCE_SINK);
    eval 'sub BIO_TYPE_NONE () {0;}' unless defined(&BIO_TYPE_NONE);
    eval 'sub BIO_TYPE_MEM () {( 1| &BIO_TYPE_SOURCE_SINK);}' unless defined(&BIO_TYPE_MEM);
    eval 'sub BIO_TYPE_FILE () {( 2| &BIO_TYPE_SOURCE_SINK);}' unless defined(&BIO_TYPE_FILE);
    eval 'sub BIO_TYPE_FD () {( 4| &BIO_TYPE_SOURCE_SINK| &BIO_TYPE_DESCRIPTOR);}' unless defined(&BIO_TYPE_FD);
    eval 'sub BIO_TYPE_SOCKET () {( 5| &BIO_TYPE_SOURCE_SINK| &BIO_TYPE_DESCRIPTOR);}' unless defined(&BIO_TYPE_SOCKET);
    eval 'sub BIO_TYPE_NULL () {( 6| &BIO_TYPE_SOURCE_SINK);}' unless defined(&BIO_TYPE_NULL);
    eval 'sub BIO_TYPE_SSL () {( 7| &BIO_TYPE_FILTER);}' unless defined(&BIO_TYPE_SSL);
    eval 'sub BIO_TYPE_MD () {( 8| &BIO_TYPE_FILTER);}' unless defined(&BIO_TYPE_MD);
    eval 'sub BIO_TYPE_BUFFER () {( 9| &BIO_TYPE_FILTER);}' unless defined(&BIO_TYPE_BUFFER);
    eval 'sub BIO_TYPE_CIPHER () {(10| &BIO_TYPE_FILTER);}' unless defined(&BIO_TYPE_CIPHER);
    eval 'sub BIO_TYPE_BASE64 () {(11| &BIO_TYPE_FILTER);}' unless defined(&BIO_TYPE_BASE64);
    eval 'sub BIO_TYPE_CONNECT () {(12| &BIO_TYPE_SOURCE_SINK| &BIO_TYPE_DESCRIPTOR);}' unless defined(&BIO_TYPE_CONNECT);
    eval 'sub BIO_TYPE_ACCEPT () {(13| &BIO_TYPE_SOURCE_SINK| &BIO_TYPE_DESCRIPTOR);}' unless defined(&BIO_TYPE_ACCEPT);
    eval 'sub BIO_TYPE_NBIO_TEST () {(16| &BIO_TYPE_FILTER);}' unless defined(&BIO_TYPE_NBIO_TEST);
    eval 'sub BIO_TYPE_NULL_FILTER () {(17| &BIO_TYPE_FILTER);}' unless defined(&BIO_TYPE_NULL_FILTER);
    eval 'sub BIO_TYPE_BIO () {(19| &BIO_TYPE_SOURCE_SINK);}' unless defined(&BIO_TYPE_BIO);
    eval 'sub BIO_TYPE_LINEBUFFER () {(20| &BIO_TYPE_FILTER);}' unless defined(&BIO_TYPE_LINEBUFFER);
    eval 'sub BIO_TYPE_DGRAM () {(21| &BIO_TYPE_SOURCE_SINK| &BIO_TYPE_DESCRIPTOR);}' unless defined(&BIO_TYPE_DGRAM);
    eval 'sub BIO_TYPE_ASN1 () {(22| &BIO_TYPE_FILTER);}' unless defined(&BIO_TYPE_ASN1);
    eval 'sub BIO_TYPE_COMP () {(23| &BIO_TYPE_FILTER);}' unless defined(&BIO_TYPE_COMP);
    unless(defined(&OPENSSL_NO_SCTP)) {
	eval 'sub BIO_TYPE_DGRAM_SCTP () {(24| &BIO_TYPE_SOURCE_SINK| &BIO_TYPE_DESCRIPTOR);}' unless defined(&BIO_TYPE_DGRAM_SCTP);
    }
    eval 'sub BIO_TYPE_START () {128;}' unless defined(&BIO_TYPE_START);
    eval 'sub BIO_NOCLOSE () {0x;}' unless defined(&BIO_NOCLOSE);
    eval 'sub BIO_CLOSE () {0x1;}' unless defined(&BIO_CLOSE);
    eval 'sub BIO_CTRL_RESET () {1;}' unless defined(&BIO_CTRL_RESET);
    eval 'sub BIO_CTRL_EOF () {2;}' unless defined(&BIO_CTRL_EOF);
    eval 'sub BIO_CTRL_INFO () {3;}' unless defined(&BIO_CTRL_INFO);
    eval 'sub BIO_CTRL_SET () {4;}' unless defined(&BIO_CTRL_SET);
    eval 'sub BIO_CTRL_GET () {5;}' unless defined(&BIO_CTRL_GET);
    eval 'sub BIO_CTRL_PUSH () {6;}' unless defined(&BIO_CTRL_PUSH);
    eval 'sub BIO_CTRL_POP () {7;}' unless defined(&BIO_CTRL_POP);
    eval 'sub BIO_CTRL_GET_CLOSE () {8;}' unless defined(&BIO_CTRL_GET_CLOSE);
    eval 'sub BIO_CTRL_SET_CLOSE () {9;}' unless defined(&BIO_CTRL_SET_CLOSE);
    eval 'sub BIO_CTRL_PENDING () {10;}' unless defined(&BIO_CTRL_PENDING);
    eval 'sub BIO_CTRL_FLUSH () {11;}' unless defined(&BIO_CTRL_FLUSH);
    eval 'sub BIO_CTRL_DUP () {12;}' unless defined(&BIO_CTRL_DUP);
    eval 'sub BIO_CTRL_WPENDING () {13;}' unless defined(&BIO_CTRL_WPENDING);
    eval 'sub BIO_CTRL_SET_CALLBACK () {14;}' unless defined(&BIO_CTRL_SET_CALLBACK);
    eval 'sub BIO_CTRL_GET_CALLBACK () {15;}' unless defined(&BIO_CTRL_GET_CALLBACK);
    eval 'sub BIO_CTRL_PEEK () {29;}' unless defined(&BIO_CTRL_PEEK);
    eval 'sub BIO_CTRL_SET_FILENAME () {30;}' unless defined(&BIO_CTRL_SET_FILENAME);
    eval 'sub BIO_CTRL_DGRAM_CONNECT () {31;}' unless defined(&BIO_CTRL_DGRAM_CONNECT);
    eval 'sub BIO_CTRL_DGRAM_SET_CONNECTED () {32;}' unless defined(&BIO_CTRL_DGRAM_SET_CONNECTED);
    eval 'sub BIO_CTRL_DGRAM_SET_RECV_TIMEOUT () {33;}' unless defined(&BIO_CTRL_DGRAM_SET_RECV_TIMEOUT);
    eval 'sub BIO_CTRL_DGRAM_GET_RECV_TIMEOUT () {34;}' unless defined(&BIO_CTRL_DGRAM_GET_RECV_TIMEOUT);
    eval 'sub BIO_CTRL_DGRAM_SET_SEND_TIMEOUT () {35;}' unless defined(&BIO_CTRL_DGRAM_SET_SEND_TIMEOUT);
    eval 'sub BIO_CTRL_DGRAM_GET_SEND_TIMEOUT () {36;}' unless defined(&BIO_CTRL_DGRAM_GET_SEND_TIMEOUT);
    eval 'sub BIO_CTRL_DGRAM_GET_RECV_TIMER_EXP () {37;}' unless defined(&BIO_CTRL_DGRAM_GET_RECV_TIMER_EXP);
    eval 'sub BIO_CTRL_DGRAM_GET_SEND_TIMER_EXP () {38;}' unless defined(&BIO_CTRL_DGRAM_GET_SEND_TIMER_EXP);
    eval 'sub BIO_CTRL_DGRAM_MTU_DISCOVER () {39;}' unless defined(&BIO_CTRL_DGRAM_MTU_DISCOVER);
    eval 'sub BIO_CTRL_DGRAM_QUERY_MTU () {40;}' unless defined(&BIO_CTRL_DGRAM_QUERY_MTU);
    eval 'sub BIO_CTRL_DGRAM_GET_FALLBACK_MTU () {47;}' unless defined(&BIO_CTRL_DGRAM_GET_FALLBACK_MTU);
    eval 'sub BIO_CTRL_DGRAM_GET_MTU () {41;}' unless defined(&BIO_CTRL_DGRAM_GET_MTU);
    eval 'sub BIO_CTRL_DGRAM_SET_MTU () {42;}' unless defined(&BIO_CTRL_DGRAM_SET_MTU);
    eval 'sub BIO_CTRL_DGRAM_MTU_EXCEEDED () {43;}' unless defined(&BIO_CTRL_DGRAM_MTU_EXCEEDED);
    eval 'sub BIO_CTRL_DGRAM_GET_PEER () {46;}' unless defined(&BIO_CTRL_DGRAM_GET_PEER);
    eval 'sub BIO_CTRL_DGRAM_SET_PEER () {44;}' unless defined(&BIO_CTRL_DGRAM_SET_PEER);
    eval 'sub BIO_CTRL_DGRAM_SET_NEXT_TIMEOUT () {45;}' unless defined(&BIO_CTRL_DGRAM_SET_NEXT_TIMEOUT);
    eval 'sub BIO_CTRL_DGRAM_SET_DONT_FRAG () {48;}' unless defined(&BIO_CTRL_DGRAM_SET_DONT_FRAG);
    eval 'sub BIO_CTRL_DGRAM_GET_MTU_OVERHEAD () {49;}' unless defined(&BIO_CTRL_DGRAM_GET_MTU_OVERHEAD);
    eval 'sub BIO_CTRL_DGRAM_SCTP_SET_IN_HANDSHAKE () {50;}' unless defined(&BIO_CTRL_DGRAM_SCTP_SET_IN_HANDSHAKE);
    unless(defined(&OPENSSL_NO_SCTP)) {
	eval 'sub BIO_CTRL_DGRAM_SCTP_ADD_AUTH_KEY () {51;}' unless defined(&BIO_CTRL_DGRAM_SCTP_ADD_AUTH_KEY);
	eval 'sub BIO_CTRL_DGRAM_SCTP_NEXT_AUTH_KEY () {52;}' unless defined(&BIO_CTRL_DGRAM_SCTP_NEXT_AUTH_KEY);
	eval 'sub BIO_CTRL_DGRAM_SCTP_AUTH_CCS_RCVD () {53;}' unless defined(&BIO_CTRL_DGRAM_SCTP_AUTH_CCS_RCVD);
	eval 'sub BIO_CTRL_DGRAM_SCTP_GET_SNDINFO () {60;}' unless defined(&BIO_CTRL_DGRAM_SCTP_GET_SNDINFO);
	eval 'sub BIO_CTRL_DGRAM_SCTP_SET_SNDINFO () {61;}' unless defined(&BIO_CTRL_DGRAM_SCTP_SET_SNDINFO);
	eval 'sub BIO_CTRL_DGRAM_SCTP_GET_RCVINFO () {62;}' unless defined(&BIO_CTRL_DGRAM_SCTP_GET_RCVINFO);
	eval 'sub BIO_CTRL_DGRAM_SCTP_SET_RCVINFO () {63;}' unless defined(&BIO_CTRL_DGRAM_SCTP_SET_RCVINFO);
	eval 'sub BIO_CTRL_DGRAM_SCTP_GET_PRINFO () {64;}' unless defined(&BIO_CTRL_DGRAM_SCTP_GET_PRINFO);
	eval 'sub BIO_CTRL_DGRAM_SCTP_SET_PRINFO () {65;}' unless defined(&BIO_CTRL_DGRAM_SCTP_SET_PRINFO);
	eval 'sub BIO_CTRL_DGRAM_SCTP_SAVE_SHUTDOWN () {70;}' unless defined(&BIO_CTRL_DGRAM_SCTP_SAVE_SHUTDOWN);
    }
    eval 'sub BIO_CTRL_DGRAM_SET_PEEK_MODE () {71;}' unless defined(&BIO_CTRL_DGRAM_SET_PEEK_MODE);
    eval 'sub BIO_FP_READ () {0x2;}' unless defined(&BIO_FP_READ);
    eval 'sub BIO_FP_WRITE () {0x4;}' unless defined(&BIO_FP_WRITE);
    eval 'sub BIO_FP_APPEND () {0x8;}' unless defined(&BIO_FP_APPEND);
    eval 'sub BIO_FP_TEXT () {0x10;}' unless defined(&BIO_FP_TEXT);
    eval 'sub BIO_FLAGS_READ () {0x1;}' unless defined(&BIO_FLAGS_READ);
    eval 'sub BIO_FLAGS_WRITE () {0x2;}' unless defined(&BIO_FLAGS_WRITE);
    eval 'sub BIO_FLAGS_IO_SPECIAL () {0x4;}' unless defined(&BIO_FLAGS_IO_SPECIAL);
    eval 'sub BIO_FLAGS_RWS () {( &BIO_FLAGS_READ| &BIO_FLAGS_WRITE| &BIO_FLAGS_IO_SPECIAL);}' unless defined(&BIO_FLAGS_RWS);
    eval 'sub BIO_FLAGS_SHOULD_RETRY () {0x8;}' unless defined(&BIO_FLAGS_SHOULD_RETRY);
    unless(defined(&BIO_FLAGS_UPLINK)) {
	eval 'sub BIO_FLAGS_UPLINK () {0;}' unless defined(&BIO_FLAGS_UPLINK);
    }
    eval 'sub BIO_FLAGS_BASE64_NO_NL () {0x100;}' unless defined(&BIO_FLAGS_BASE64_NO_NL);
    eval 'sub BIO_FLAGS_MEM_RDONLY () {0x200;}' unless defined(&BIO_FLAGS_MEM_RDONLY);
    eval 'sub BIO_FLAGS_NONCLEAR_RST () {0x400;}' unless defined(&BIO_FLAGS_NONCLEAR_RST);
    eval 'sub BIO_FLAGS_IN_EOF () {0x800;}' unless defined(&BIO_FLAGS_IN_EOF);
    eval 'sub BIO_get_flags {
        my($b) = @_;
	    eval q( &BIO_test_flags($b, ~(0x)));
    }' unless defined(&BIO_get_flags);
    eval 'sub BIO_set_retry_special {
        my($b) = @_;
	    eval q( &BIO_set_flags($b, ( &BIO_FLAGS_IO_SPECIAL| &BIO_FLAGS_SHOULD_RETRY)));
    }' unless defined(&BIO_set_retry_special);
    eval 'sub BIO_set_retry_read {
        my($b) = @_;
	    eval q( &BIO_set_flags($b, ( &BIO_FLAGS_READ| &BIO_FLAGS_SHOULD_RETRY)));
    }' unless defined(&BIO_set_retry_read);
    eval 'sub BIO_set_retry_write {
        my($b) = @_;
	    eval q( &BIO_set_flags($b, ( &BIO_FLAGS_WRITE| &BIO_FLAGS_SHOULD_RETRY)));
    }' unless defined(&BIO_set_retry_write);
    eval 'sub BIO_clear_retry_flags {
        my($b) = @_;
	    eval q( &BIO_clear_flags($b, ( &BIO_FLAGS_RWS| &BIO_FLAGS_SHOULD_RETRY)));
    }' unless defined(&BIO_clear_retry_flags);
    eval 'sub BIO_get_retry_flags {
        my($b) = @_;
	    eval q( &BIO_test_flags($b, ( &BIO_FLAGS_RWS| &BIO_FLAGS_SHOULD_RETRY)));
    }' unless defined(&BIO_get_retry_flags);
    eval 'sub BIO_should_read {
        my($a) = @_;
	    eval q( &BIO_test_flags($a,  &BIO_FLAGS_READ));
    }' unless defined(&BIO_should_read);
    eval 'sub BIO_should_write {
        my($a) = @_;
	    eval q( &BIO_test_flags($a,  &BIO_FLAGS_WRITE));
    }' unless defined(&BIO_should_write);
    eval 'sub BIO_should_io_special {
        my($a) = @_;
	    eval q( &BIO_test_flags($a,  &BIO_FLAGS_IO_SPECIAL));
    }' unless defined(&BIO_should_io_special);
    eval 'sub BIO_retry_type {
        my($a) = @_;
	    eval q( &BIO_test_flags($a,  &BIO_FLAGS_RWS));
    }' unless defined(&BIO_retry_type);
    eval 'sub BIO_should_retry {
        my($a) = @_;
	    eval q( &BIO_test_flags($a,  &BIO_FLAGS_SHOULD_RETRY));
    }' unless defined(&BIO_should_retry);
    eval 'sub BIO_RR_SSL_X509_LOOKUP () {0x1;}' unless defined(&BIO_RR_SSL_X509_LOOKUP);
    eval 'sub BIO_RR_CONNECT () {0x2;}' unless defined(&BIO_RR_CONNECT);
    eval 'sub BIO_RR_ACCEPT () {0x3;}' unless defined(&BIO_RR_ACCEPT);
    eval 'sub BIO_CB_FREE () {0x1;}' unless defined(&BIO_CB_FREE);
    eval 'sub BIO_CB_READ () {0x2;}' unless defined(&BIO_CB_READ);
    eval 'sub BIO_CB_WRITE () {0x3;}' unless defined(&BIO_CB_WRITE);
    eval 'sub BIO_CB_PUTS () {0x4;}' unless defined(&BIO_CB_PUTS);
    eval 'sub BIO_CB_GETS () {0x5;}' unless defined(&BIO_CB_GETS);
    eval 'sub BIO_CB_CTRL () {0x6;}' unless defined(&BIO_CB_CTRL);
    eval 'sub BIO_CB_RETURN () {0x80;}' unless defined(&BIO_CB_RETURN);
    eval 'sub BIO_CB_return {
        my($a) = @_;
	    eval q((($a)| &BIO_CB_RETURN));
    }' unless defined(&BIO_CB_return);
    eval 'sub BIO_cb_pre {
        my($a) = @_;
	    eval q((!(($a) &BIO_CB_RETURN)));
    }' unless defined(&BIO_cb_pre);
    eval 'sub BIO_cb_post {
        my($a) = @_;
	    eval q((($a) &BIO_CB_RETURN));
    }' unless defined(&BIO_cb_post);
    unless(defined(&OPENSSL_NO_SCTP)) {
    }
    eval 'sub BIO_C_SET_CONNECT () {100;}' unless defined(&BIO_C_SET_CONNECT);
    eval 'sub BIO_C_DO_STATE_MACHINE () {101;}' unless defined(&BIO_C_DO_STATE_MACHINE);
    eval 'sub BIO_C_SET_NBIO () {102;}' unless defined(&BIO_C_SET_NBIO);
    eval 'sub BIO_C_SET_FD () {104;}' unless defined(&BIO_C_SET_FD);
    eval 'sub BIO_C_GET_FD () {105;}' unless defined(&BIO_C_GET_FD);
    eval 'sub BIO_C_SET_FILE_PTR () {106;}' unless defined(&BIO_C_SET_FILE_PTR);
    eval 'sub BIO_C_GET_FILE_PTR () {107;}' unless defined(&BIO_C_GET_FILE_PTR);
    eval 'sub BIO_C_SET_FILENAME () {108;}' unless defined(&BIO_C_SET_FILENAME);
    eval 'sub BIO_C_SET_SSL () {109;}' unless defined(&BIO_C_SET_SSL);
    eval 'sub BIO_C_GET_SSL () {110;}' unless defined(&BIO_C_GET_SSL);
    eval 'sub BIO_C_SET_MD () {111;}' unless defined(&BIO_C_SET_MD);
    eval 'sub BIO_C_GET_MD () {112;}' unless defined(&BIO_C_GET_MD);
    eval 'sub BIO_C_GET_CIPHER_STATUS () {113;}' unless defined(&BIO_C_GET_CIPHER_STATUS);
    eval 'sub BIO_C_SET_BUF_MEM () {114;}' unless defined(&BIO_C_SET_BUF_MEM);
    eval 'sub BIO_C_GET_BUF_MEM_PTR () {115;}' unless defined(&BIO_C_GET_BUF_MEM_PTR);
    eval 'sub BIO_C_GET_BUFF_NUM_LINES () {116;}' unless defined(&BIO_C_GET_BUFF_NUM_LINES);
    eval 'sub BIO_C_SET_BUFF_SIZE () {117;}' unless defined(&BIO_C_SET_BUFF_SIZE);
    eval 'sub BIO_C_SET_ACCEPT () {118;}' unless defined(&BIO_C_SET_ACCEPT);
    eval 'sub BIO_C_SSL_MODE () {119;}' unless defined(&BIO_C_SSL_MODE);
    eval 'sub BIO_C_GET_MD_CTX () {120;}' unless defined(&BIO_C_GET_MD_CTX);
    eval 'sub BIO_C_SET_BUFF_READ_DATA () {122;}' unless defined(&BIO_C_SET_BUFF_READ_DATA);
    eval 'sub BIO_C_GET_CONNECT () {123;}' unless defined(&BIO_C_GET_CONNECT);
    eval 'sub BIO_C_GET_ACCEPT () {124;}' unless defined(&BIO_C_GET_ACCEPT);
    eval 'sub BIO_C_SET_SSL_RENEGOTIATE_BYTES () {125;}' unless defined(&BIO_C_SET_SSL_RENEGOTIATE_BYTES);
    eval 'sub BIO_C_GET_SSL_NUM_RENEGOTIATES () {126;}' unless defined(&BIO_C_GET_SSL_NUM_RENEGOTIATES);
    eval 'sub BIO_C_SET_SSL_RENEGOTIATE_TIMEOUT () {127;}' unless defined(&BIO_C_SET_SSL_RENEGOTIATE_TIMEOUT);
    eval 'sub BIO_C_FILE_SEEK () {128;}' unless defined(&BIO_C_FILE_SEEK);
    eval 'sub BIO_C_GET_CIPHER_CTX () {129;}' unless defined(&BIO_C_GET_CIPHER_CTX);
    eval 'sub BIO_C_SET_BUF_MEM_EOF_RETURN () {130;}' unless defined(&BIO_C_SET_BUF_MEM_EOF_RETURN);
    eval 'sub BIO_C_SET_BIND_MODE () {131;}' unless defined(&BIO_C_SET_BIND_MODE);
    eval 'sub BIO_C_GET_BIND_MODE () {132;}' unless defined(&BIO_C_GET_BIND_MODE);
    eval 'sub BIO_C_FILE_TELL () {133;}' unless defined(&BIO_C_FILE_TELL);
    eval 'sub BIO_C_GET_SOCKS () {134;}' unless defined(&BIO_C_GET_SOCKS);
    eval 'sub BIO_C_SET_SOCKS () {135;}' unless defined(&BIO_C_SET_SOCKS);
    eval 'sub BIO_C_SET_WRITE_BUF_SIZE () {136;}' unless defined(&BIO_C_SET_WRITE_BUF_SIZE);
    eval 'sub BIO_C_GET_WRITE_BUF_SIZE () {137;}' unless defined(&BIO_C_GET_WRITE_BUF_SIZE);
    eval 'sub BIO_C_MAKE_BIO_PAIR () {138;}' unless defined(&BIO_C_MAKE_BIO_PAIR);
    eval 'sub BIO_C_DESTROY_BIO_PAIR () {139;}' unless defined(&BIO_C_DESTROY_BIO_PAIR);
    eval 'sub BIO_C_GET_WRITE_GUARANTEE () {140;}' unless defined(&BIO_C_GET_WRITE_GUARANTEE);
    eval 'sub BIO_C_GET_READ_REQUEST () {141;}' unless defined(&BIO_C_GET_READ_REQUEST);
    eval 'sub BIO_C_SHUTDOWN_WR () {142;}' unless defined(&BIO_C_SHUTDOWN_WR);
    eval 'sub BIO_C_NREAD0 () {143;}' unless defined(&BIO_C_NREAD0);
    eval 'sub BIO_C_NREAD () {144;}' unless defined(&BIO_C_NREAD);
    eval 'sub BIO_C_NWRITE0 () {145;}' unless defined(&BIO_C_NWRITE0);
    eval 'sub BIO_C_NWRITE () {146;}' unless defined(&BIO_C_NWRITE);
    eval 'sub BIO_C_RESET_READ_REQUEST () {147;}' unless defined(&BIO_C_RESET_READ_REQUEST);
    eval 'sub BIO_C_SET_MD_CTX () {148;}' unless defined(&BIO_C_SET_MD_CTX);
    eval 'sub BIO_C_SET_PREFIX () {149;}' unless defined(&BIO_C_SET_PREFIX);
    eval 'sub BIO_C_GET_PREFIX () {150;}' unless defined(&BIO_C_GET_PREFIX);
    eval 'sub BIO_C_SET_SUFFIX () {151;}' unless defined(&BIO_C_SET_SUFFIX);
    eval 'sub BIO_C_GET_SUFFIX () {152;}' unless defined(&BIO_C_GET_SUFFIX);
    eval 'sub BIO_C_SET_EX_ARG () {153;}' unless defined(&BIO_C_SET_EX_ARG);
    eval 'sub BIO_C_GET_EX_ARG () {154;}' unless defined(&BIO_C_GET_EX_ARG);
    eval 'sub BIO_C_SET_CONNECT_MODE () {155;}' unless defined(&BIO_C_SET_CONNECT_MODE);
    eval 'sub BIO_set_app_data {
        my($s,$arg) = @_;
	    eval q( &BIO_set_ex_data($s,0,$arg));
    }' unless defined(&BIO_set_app_data);
    eval 'sub BIO_get_app_data {
        my($s) = @_;
	    eval q( &BIO_get_ex_data($s,0));
    }' unless defined(&BIO_get_app_data);
    eval 'sub BIO_set_nbio {
        my($b,$n) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_NBIO,($n), &NULL));
    }' unless defined(&BIO_set_nbio);
    unless(defined(&OPENSSL_NO_SOCK)) {
	eval 'sub BIO_FAMILY_IPV4 () {4;}' unless defined(&BIO_FAMILY_IPV4);
	eval 'sub BIO_FAMILY_IPV6 () {6;}' unless defined(&BIO_FAMILY_IPV6);
	eval 'sub BIO_FAMILY_IPANY () {256;}' unless defined(&BIO_FAMILY_IPANY);
	eval 'sub BIO_set_conn_hostname {
	    my($b,$name) = @_;
    	    eval q( &BIO_ctrl($b, &BIO_C_SET_CONNECT,0, ($name)));
	}' unless defined(&BIO_set_conn_hostname);
	eval 'sub BIO_set_conn_port {
	    my($b,$port) = @_;
    	    eval q( &BIO_ctrl($b, &BIO_C_SET_CONNECT,1, ($port)));
	}' unless defined(&BIO_set_conn_port);
	eval 'sub BIO_set_conn_address {
	    my($b,$addr) = @_;
    	    eval q( &BIO_ctrl($b, &BIO_C_SET_CONNECT,2, ($addr)));
	}' unless defined(&BIO_set_conn_address);
	eval 'sub BIO_set_conn_ip_family {
	    my($b,$f) = @_;
    	    eval q( &BIO_int_ctrl($b, &BIO_C_SET_CONNECT,3,$f));
	}' unless defined(&BIO_set_conn_ip_family);
	eval 'sub BIO_get_conn_hostname {
	    my($b) = @_;
    	    eval q((( &const \'char\' *) &BIO_ptr_ctrl($b, &BIO_C_GET_CONNECT,0)));
	}' unless defined(&BIO_get_conn_hostname);
	eval 'sub BIO_get_conn_port {
	    my($b) = @_;
    	    eval q((( &const \'char\' *) &BIO_ptr_ctrl($b, &BIO_C_GET_CONNECT,1)));
	}' unless defined(&BIO_get_conn_port);
	eval 'sub BIO_get_conn_address {
	    my($b) = @_;
    	    eval q((( &const  &BIO_ADDR *) &BIO_ptr_ctrl($b, &BIO_C_GET_CONNECT,2)));
	}' unless defined(&BIO_get_conn_address);
	eval 'sub BIO_get_conn_ip_family {
	    my($b) = @_;
    	    eval q( &BIO_ctrl($b, &BIO_C_GET_CONNECT,3, &NULL));
	}' unless defined(&BIO_get_conn_ip_family);
	eval 'sub BIO_set_conn_mode {
	    my($b,$n) = @_;
    	    eval q( &BIO_ctrl($b, &BIO_C_SET_CONNECT_MODE,($n), &NULL));
	}' unless defined(&BIO_set_conn_mode);
	eval 'sub BIO_set_accept_name {
	    my($b,$name) = @_;
    	    eval q( &BIO_ctrl($b, &BIO_C_SET_ACCEPT,0, ($name)));
	}' unless defined(&BIO_set_accept_name);
	eval 'sub BIO_set_accept_port {
	    my($b,$port) = @_;
    	    eval q( &BIO_ctrl($b, &BIO_C_SET_ACCEPT,1, ($port)));
	}' unless defined(&BIO_set_accept_port);
	eval 'sub BIO_get_accept_name {
	    my($b) = @_;
    	    eval q((( &const \'char\' *) &BIO_ptr_ctrl($b, &BIO_C_GET_ACCEPT,0)));
	}' unless defined(&BIO_get_accept_name);
	eval 'sub BIO_get_accept_port {
	    my($b) = @_;
    	    eval q((( &const \'char\' *) &BIO_ptr_ctrl($b, &BIO_C_GET_ACCEPT,1)));
	}' unless defined(&BIO_get_accept_port);
	eval 'sub BIO_get_peer_name {
	    my($b) = @_;
    	    eval q((( &const \'char\' *) &BIO_ptr_ctrl($b, &BIO_C_GET_ACCEPT,2)));
	}' unless defined(&BIO_get_peer_name);
	eval 'sub BIO_get_peer_port {
	    my($b) = @_;
    	    eval q((( &const \'char\' *) &BIO_ptr_ctrl($b, &BIO_C_GET_ACCEPT,3)));
	}' unless defined(&BIO_get_peer_port);
	eval 'sub BIO_set_nbio_accept {
	    my($b,$n) = @_;
    	    eval q( &BIO_ctrl($b, &BIO_C_SET_ACCEPT,2,($n)?( &void *)\\"a\\": &NULL));
	}' unless defined(&BIO_set_nbio_accept);
	eval 'sub BIO_set_accept_bios {
	    my($b,$bio) = @_;
    	    eval q( &BIO_ctrl($b, &BIO_C_SET_ACCEPT,3, ($bio)));
	}' unless defined(&BIO_set_accept_bios);
	eval 'sub BIO_set_accept_ip_family {
	    my($b,$f) = @_;
    	    eval q( &BIO_int_ctrl($b, &BIO_C_SET_ACCEPT,4,$f));
	}' unless defined(&BIO_set_accept_ip_family);
	eval 'sub BIO_get_accept_ip_family {
	    my($b) = @_;
    	    eval q( &BIO_ctrl($b, &BIO_C_GET_ACCEPT,4, &NULL));
	}' unless defined(&BIO_get_accept_ip_family);
	eval 'sub BIO_BIND_NORMAL () {0;}' unless defined(&BIO_BIND_NORMAL);
	eval 'sub BIO_BIND_REUSEADDR () { &BIO_SOCK_REUSEADDR;}' unless defined(&BIO_BIND_REUSEADDR);
	eval 'sub BIO_BIND_REUSEADDR_IF_UNUSED () { &BIO_SOCK_REUSEADDR;}' unless defined(&BIO_BIND_REUSEADDR_IF_UNUSED);
	eval 'sub BIO_set_bind_mode {
	    my($b,$mode) = @_;
    	    eval q( &BIO_ctrl($b, &BIO_C_SET_BIND_MODE,$mode, &NULL));
	}' unless defined(&BIO_set_bind_mode);
	eval 'sub BIO_get_bind_mode {
	    my($b) = @_;
    	    eval q( &BIO_ctrl($b, &BIO_C_GET_BIND_MODE,0, &NULL));
	}' unless defined(&BIO_get_bind_mode);
	eval 'sub BIO_do_connect {
	    my($b) = @_;
    	    eval q( &BIO_do_handshake($b));
	}' unless defined(&BIO_do_connect);
	eval 'sub BIO_do_accept {
	    my($b) = @_;
    	    eval q( &BIO_do_handshake($b));
	}' unless defined(&BIO_do_accept);
    }
    eval 'sub BIO_do_handshake {
        my($b) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_DO_STATE_MACHINE,0, &NULL));
    }' unless defined(&BIO_do_handshake);
    eval 'sub BIO_set_fd {
        my($b,$fd,$c) = @_;
	    eval q( &BIO_int_ctrl($b, &BIO_C_SET_FD,$c,$fd));
    }' unless defined(&BIO_set_fd);
    eval 'sub BIO_get_fd {
        my($b,$c) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_GET_FD,0,($c)));
    }' unless defined(&BIO_get_fd);
    eval 'sub BIO_set_fp {
        my($b,$fp,$c) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_FILE_PTR,$c,($fp)));
    }' unless defined(&BIO_set_fp);
    eval 'sub BIO_get_fp {
        my($b,$fpp) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_GET_FILE_PTR,0,($fpp)));
    }' unless defined(&BIO_get_fp);
    eval 'sub BIO_seek {
        my($b,$ofs) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_FILE_SEEK,$ofs, &NULL));
    }' unless defined(&BIO_seek);
    eval 'sub BIO_tell {
        my($b) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_FILE_TELL,0, &NULL));
    }' unless defined(&BIO_tell);
    if(defined(&CONST_STRICT)) {
    } else {
	eval 'sub BIO_read_filename {
	    my($b,$name) = @_;
    	    eval q( &BIO_ctrl($b, &BIO_C_SET_FILENAME,  &BIO_CLOSE| &BIO_FP_READ,($name)));
	}' unless defined(&BIO_read_filename);
    }
    eval 'sub BIO_write_filename {
        my($b,$name) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_FILENAME,  &BIO_CLOSE| &BIO_FP_WRITE,$name));
    }' unless defined(&BIO_write_filename);
    eval 'sub BIO_append_filename {
        my($b,$name) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_FILENAME,  &BIO_CLOSE| &BIO_FP_APPEND,$name));
    }' unless defined(&BIO_append_filename);
    eval 'sub BIO_rw_filename {
        my($b,$name) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_FILENAME,  &BIO_CLOSE| &BIO_FP_READ| &BIO_FP_WRITE,$name));
    }' unless defined(&BIO_rw_filename);
    eval 'sub BIO_set_ssl {
        my($b,$ssl,$c) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_SSL,$c,($ssl)));
    }' unless defined(&BIO_set_ssl);
    eval 'sub BIO_get_ssl {
        my($b,$sslp) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_GET_SSL,0,($sslp)));
    }' unless defined(&BIO_get_ssl);
    eval 'sub BIO_set_ssl_mode {
        my($b,$client) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SSL_MODE,$client, &NULL));
    }' unless defined(&BIO_set_ssl_mode);
    eval 'sub BIO_set_ssl_renegotiate_bytes {
        my($b,$num) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_SSL_RENEGOTIATE_BYTES,$num, &NULL));
    }' unless defined(&BIO_set_ssl_renegotiate_bytes);
    eval 'sub BIO_get_num_renegotiates {
        my($b) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_GET_SSL_NUM_RENEGOTIATES,0, &NULL));
    }' unless defined(&BIO_get_num_renegotiates);
    eval 'sub BIO_set_ssl_renegotiate_timeout {
        my($b,$seconds) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_SSL_RENEGOTIATE_TIMEOUT,$seconds, &NULL));
    }' unless defined(&BIO_set_ssl_renegotiate_timeout);
    eval 'sub BIO_get_mem_data {
        my($b,$pp) = @_;
	    eval q( &BIO_ctrl($b, &BIO_CTRL_INFO,0,($pp)));
    }' unless defined(&BIO_get_mem_data);
    eval 'sub BIO_set_mem_buf {
        my($b,$bm,$c) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_BUF_MEM,$c,($bm)));
    }' unless defined(&BIO_set_mem_buf);
    eval 'sub BIO_get_mem_ptr {
        my($b,$pp) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_GET_BUF_MEM_PTR,0, ($pp)));
    }' unless defined(&BIO_get_mem_ptr);
    eval 'sub BIO_set_mem_eof_return {
        my($b,$v) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_BUF_MEM_EOF_RETURN,$v, &NULL));
    }' unless defined(&BIO_set_mem_eof_return);
    eval 'sub BIO_get_buffer_num_lines {
        my($b) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_GET_BUFF_NUM_LINES,0, &NULL));
    }' unless defined(&BIO_get_buffer_num_lines);
    eval 'sub BIO_set_buffer_size {
        my($b,$size) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_BUFF_SIZE,$size, &NULL));
    }' unless defined(&BIO_set_buffer_size);
    eval 'sub BIO_set_read_buffer_size {
        my($b,$size) = @_;
	    eval q( &BIO_int_ctrl($b, &BIO_C_SET_BUFF_SIZE,$size,0));
    }' unless defined(&BIO_set_read_buffer_size);
    eval 'sub BIO_set_write_buffer_size {
        my($b,$size) = @_;
	    eval q( &BIO_int_ctrl($b, &BIO_C_SET_BUFF_SIZE,$size,1));
    }' unless defined(&BIO_set_write_buffer_size);
    eval 'sub BIO_set_buffer_read_data {
        my($b,$buf,$num) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_BUFF_READ_DATA,$num,$buf));
    }' unless defined(&BIO_set_buffer_read_data);
    eval 'sub BIO_dup_state {
        my($b,$ret) = @_;
	    eval q( &BIO_ctrl($b, &BIO_CTRL_DUP,0,($ret)));
    }' unless defined(&BIO_dup_state);
    eval 'sub BIO_reset {
        my($b) = @_;
	    eval q( &BIO_ctrl($b, &BIO_CTRL_RESET,0, &NULL));
    }' unless defined(&BIO_reset);
    eval 'sub BIO_eof {
        my($b) = @_;
	    eval q( &BIO_ctrl($b, &BIO_CTRL_EOF,0, &NULL));
    }' unless defined(&BIO_eof);
    eval 'sub BIO_set_close {
        my($b,$c) = @_;
	    eval q( &BIO_ctrl($b, &BIO_CTRL_SET_CLOSE,($c), &NULL));
    }' unless defined(&BIO_set_close);
    eval 'sub BIO_get_close {
        my($b) = @_;
	    eval q( &BIO_ctrl($b, &BIO_CTRL_GET_CLOSE,0, &NULL));
    }' unless defined(&BIO_get_close);
    eval 'sub BIO_pending {
        my($b) = @_;
	    eval q( &BIO_ctrl($b, &BIO_CTRL_PENDING,0, &NULL));
    }' unless defined(&BIO_pending);
    eval 'sub BIO_wpending {
        my($b) = @_;
	    eval q( &BIO_ctrl($b, &BIO_CTRL_WPENDING,0, &NULL));
    }' unless defined(&BIO_wpending);
    eval 'sub BIO_flush {
        my($b) = @_;
	    eval q( &BIO_ctrl($b, &BIO_CTRL_FLUSH,0, &NULL));
    }' unless defined(&BIO_flush);
    eval 'sub BIO_get_info_callback {
        my($b,$cbp) = @_;
	    eval q( &BIO_ctrl($b, &BIO_CTRL_GET_CALLBACK,0, $cbp));
    }' unless defined(&BIO_get_info_callback);
    eval 'sub BIO_set_info_callback {
        my($b,$cb) = @_;
	    eval q( &BIO_callback_ctrl($b, &BIO_CTRL_SET_CALLBACK,$cb));
    }' unless defined(&BIO_set_info_callback);
    eval 'sub BIO_buffer_get_num_lines {
        my($b) = @_;
	    eval q( &BIO_ctrl($b, &BIO_CTRL_GET,0, &NULL));
    }' unless defined(&BIO_buffer_get_num_lines);
    eval 'sub BIO_buffer_peek {
        my($b,$s,$l) = @_;
	    eval q( &BIO_ctrl($b, &BIO_CTRL_PEEK,($l),($s)));
    }' unless defined(&BIO_buffer_peek);
    eval 'sub BIO_set_write_buf_size {
        my($b,$size) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_SET_WRITE_BUF_SIZE,$size, &NULL));
    }' unless defined(&BIO_set_write_buf_size);
    eval 'sub BIO_get_write_buf_size {
        my($b,$size) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_GET_WRITE_BUF_SIZE,$size, &NULL));
    }' unless defined(&BIO_get_write_buf_size);
    eval 'sub BIO_make_bio_pair {
        my($b1,$b2) = @_;
	    eval q( &BIO_ctrl($b1, &BIO_C_MAKE_BIO_PAIR,0,$b2));
    }' unless defined(&BIO_make_bio_pair);
    eval 'sub BIO_destroy_bio_pair {
        my($b) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_DESTROY_BIO_PAIR,0, &NULL));
    }' unless defined(&BIO_destroy_bio_pair);
    eval 'sub BIO_shutdown_wr {
        my($b) = @_;
	    eval q( &BIO_ctrl($b,  &BIO_C_SHUTDOWN_WR, 0,  &NULL));
    }' unless defined(&BIO_shutdown_wr);
    eval 'sub BIO_get_write_guarantee {
        my($b) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_GET_WRITE_GUARANTEE,0, &NULL));
    }' unless defined(&BIO_get_write_guarantee);
    eval 'sub BIO_get_read_request {
        my($b) = @_;
	    eval q( &BIO_ctrl($b, &BIO_C_GET_READ_REQUEST,0, &NULL));
    }' unless defined(&BIO_get_read_request);
    eval 'sub BIO_ctrl_dgram_connect {
        my($b,$peer) = @_;
	    eval q( &BIO_ctrl($b, &BIO_CTRL_DGRAM_CONNECT,0, ($peer)));
    }' unless defined(&BIO_ctrl_dgram_connect);
    eval 'sub BIO_ctrl_set_connected {
        my($b,$peer) = @_;
	    eval q( &BIO_ctrl($b,  &BIO_CTRL_DGRAM_SET_CONNECTED, 0, ($peer)));
    }' unless defined(&BIO_ctrl_set_connected);
    eval 'sub BIO_dgram_recv_timedout {
        my($b) = @_;
	    eval q( &BIO_ctrl($b,  &BIO_CTRL_DGRAM_GET_RECV_TIMER_EXP, 0,  &NULL));
    }' unless defined(&BIO_dgram_recv_timedout);
    eval 'sub BIO_dgram_send_timedout {
        my($b) = @_;
	    eval q( &BIO_ctrl($b,  &BIO_CTRL_DGRAM_GET_SEND_TIMER_EXP, 0,  &NULL));
    }' unless defined(&BIO_dgram_send_timedout);
    eval 'sub BIO_dgram_get_peer {
        my($b,$peer) = @_;
	    eval q( &BIO_ctrl($b,  &BIO_CTRL_DGRAM_GET_PEER, 0, ($peer)));
    }' unless defined(&BIO_dgram_get_peer);
    eval 'sub BIO_dgram_set_peer {
        my($b,$peer) = @_;
	    eval q( &BIO_ctrl($b,  &BIO_CTRL_DGRAM_SET_PEER, 0, ($peer)));
    }' unless defined(&BIO_dgram_set_peer);
    eval 'sub BIO_dgram_get_mtu_overhead {
        my($b) = @_;
	    eval q( &BIO_ctrl(($b),  &BIO_CTRL_DGRAM_GET_MTU_OVERHEAD, 0,  &NULL));
    }' unless defined(&BIO_dgram_get_mtu_overhead);
    eval 'sub BIO_get_ex_new_index {
        my($l, $p, $newf, $dupf, $freef) = @_;
	    eval q( &CRYPTO_get_ex_new_index( &CRYPTO_EX_INDEX_BIO, $l, $p, $newf, $dupf, $freef));
    }' unless defined(&BIO_get_ex_new_index);
    unless(defined(&OPENSSL_NO_STDIO)) {
    }
    unless(defined(&OPENSSL_NO_SOCK)) {
    }
    unless(defined(&OPENSSL_NO_DGRAM)) {
	unless(defined(&OPENSSL_NO_SCTP)) {
	}
    }
    unless(defined(&OPENSSL_NO_SOCK)) {
    }
    unless(defined(&OPENSSL_NO_STDIO)) {
    }
    unless(defined(&OPENSSL_NO_SOCK)) {
	eval("sub BIO_PARSE_PRIO_HOST () { 0; }") unless defined(&BIO_PARSE_PRIO_HOST);
	eval("sub BIO_PARSE_PRIO_SERV () { 1; }") unless defined(&BIO_PARSE_PRIO_SERV);
	eval("sub BIO_LOOKUP_CLIENT () { 0; }") unless defined(&BIO_LOOKUP_CLIENT);
	eval("sub BIO_LOOKUP_SERVER () { 1; }") unless defined(&BIO_LOOKUP_SERVER);
	if((defined(&OPENSSL_API_COMPAT) ? &OPENSSL_API_COMPAT : undef) < 0x10100000) {
	    eval 'sub BIO_sock_cleanup () {
	        eval q( &while(0)  &continue);
	    }' unless defined(&BIO_sock_cleanup);
	}
	eval("sub BIO_SOCK_INFO_ADDRESS () { 0; }") unless defined(&BIO_SOCK_INFO_ADDRESS);
	eval 'sub BIO_SOCK_REUSEADDR () {0x1;}' unless defined(&BIO_SOCK_REUSEADDR);
	eval 'sub BIO_SOCK_V6_ONLY () {0x2;}' unless defined(&BIO_SOCK_V6_ONLY);
	eval 'sub BIO_SOCK_KEEPALIVE () {0x4;}' unless defined(&BIO_SOCK_KEEPALIVE);
	eval 'sub BIO_SOCK_NONBLOCK () {0x8;}' unless defined(&BIO_SOCK_NONBLOCK);
	eval 'sub BIO_SOCK_NODELAY () {0x10;}' unless defined(&BIO_SOCK_NODELAY);
    }
    eval 'sub ossl_bio__attr__ {
        my($x) = @_;
	    eval q();
    }' unless defined(&ossl_bio__attr__);
    if(defined(&__GNUC__)  && defined(&__STDC_VERSION__)  && !defined(&__APPLE__)) {
	if((defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : undef) >= 199901) {
	    undef(&ossl_bio__attr__) if defined(&ossl_bio__attr__);
	    eval 'sub ossl_bio__attr__ () { &__attribute__;}' unless defined(&ossl_bio__attr__);
	    if((defined(&__GNUC__) ? &__GNUC__ : undef)*10+ (defined(&__GNUC_MINOR__) ? &__GNUC_MINOR__ : undef) >= 44) {
		eval 'sub ossl_bio__printf__ () { &__gnu_printf__;}' unless defined(&ossl_bio__printf__);
	    } else {
		eval 'sub ossl_bio__printf__ () { &__printf__;}' unless defined(&ossl_bio__printf__);
	    }
	}
    }
    undef(&ossl_bio__attr__) if defined(&ossl_bio__attr__);
    undef(&ossl_bio__printf__) if defined(&ossl_bio__printf__);
    if(defined(&__cplusplus)) {
    }
}
1;
