require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_USB_H_)) {
    eval 'sub _USB_H_ () {1;}' unless defined(&_USB_H_);
    require 'sys/types.ph';
    require 'sys/time.ph';
    require 'sys/ioctl.ph';
    if(defined(&_KERNEL)) {
	require 'sys/device.ph';
    }
    if(defined(&USB_DEBUG)) {
	eval 'sub Static () {1;}' unless defined(&Static);
    } else {
	eval 'sub Static () { &static;}' unless defined(&Static);
    }
    eval 'sub USB_STACK_VERSION () {2;}' unless defined(&USB_STACK_VERSION);
    eval 'sub USB_MAX_DEVICES () {128;}' unless defined(&USB_MAX_DEVICES);
    eval 'sub USB_MIN_DEVICES () {2;}' unless defined(&USB_MIN_DEVICES);
    eval 'sub USB_START_ADDR () {0;}' unless defined(&USB_START_ADDR);
    eval 'sub USB_CONTROL_ENDPOINT () {0;}' unless defined(&USB_CONTROL_ENDPOINT);
    eval 'sub USB_MAX_ENDPOINTS () {16;}' unless defined(&USB_MAX_ENDPOINTS);
    eval 'sub USB_FRAMES_PER_SECOND () {1000;}' unless defined(&USB_FRAMES_PER_SECOND);
    eval 'sub USB_UFRAMES_PER_FRAME () {8;}' unless defined(&USB_UFRAMES_PER_FRAME);
    eval 'sub USETW2 {
        my($w,$h,$l) = @_;
	    eval q((($w)[0] = ( &uint8_t)($l), ($w)[1] = ( &uint8_t)($h)));
    }' unless defined(&USETW2);
    eval 'sub UGETW {
        my($w) = @_;
	    eval q((($w)[0] | (($w)[1] << 8)));
    }' unless defined(&UGETW);
    eval 'sub USETW {
        my($w,$v) = @_;
	    eval q((($w)[0] = ( &uint8_t)($v), ($w)[1] = ( &uint8_t)(($v) >> 8)));
    }' unless defined(&USETW);
    eval 'sub USETWD {
        my($val) = @_;
	    eval q({ ( &uint8_t)($val), ( &uint8_t)(($val) >> 8) });
    }' unless defined(&USETWD);
    eval 'sub UGETDW {
        my($w) = @_;
	    eval q((($w)[0] | (($w)[1] << 8) | (($w)[2] << 16) | (($w)[3] << 24)));
    }' unless defined(&UGETDW);
    eval 'sub USETDW {
        my($w,$v) = @_;
	    eval q((($w)[0] = ( &uint8_t)($v), ($w)[1] = ( &uint8_t)(($v) >> 8), ($w)[2] = ( &uint8_t)(($v) >> 16), ($w)[3] = ( &uint8_t)(($v) >> 24)));
    }' unless defined(&USETDW);
    eval 'sub UPACKED () { &__packed;}' unless defined(&UPACKED);
    eval 'sub UT_GET_DIR {
        my($a) = @_;
	    eval q((($a) & 0x80));
    }' unless defined(&UT_GET_DIR);
    eval 'sub UT_WRITE () {0x;}' unless defined(&UT_WRITE);
    eval 'sub UT_READ () {0x80;}' unless defined(&UT_READ);
    eval 'sub UT_GET_TYPE {
        my($a) = @_;
	    eval q((($a) & 0x60));
    }' unless defined(&UT_GET_TYPE);
    eval 'sub UT_STANDARD () {0x;}' unless defined(&UT_STANDARD);
    eval 'sub UT_CLASS () {0x20;}' unless defined(&UT_CLASS);
    eval 'sub UT_VENDOR () {0x40;}' unless defined(&UT_VENDOR);
    eval 'sub UT_GET_RECIPIENT {
        my($a) = @_;
	    eval q((($a) & 0x1f));
    }' unless defined(&UT_GET_RECIPIENT);
    eval 'sub UT_DEVICE () {0x;}' unless defined(&UT_DEVICE);
    eval 'sub UT_INTERFACE () {0x1;}' unless defined(&UT_INTERFACE);
    eval 'sub UT_ENDPOINT () {0x2;}' unless defined(&UT_ENDPOINT);
    eval 'sub UT_OTHER () {0x3;}' unless defined(&UT_OTHER);
    eval 'sub UT_READ_DEVICE () {( &UT_READ |  &UT_STANDARD |  &UT_DEVICE);}' unless defined(&UT_READ_DEVICE);
    eval 'sub UT_READ_INTERFACE () {( &UT_READ |  &UT_STANDARD |  &UT_INTERFACE);}' unless defined(&UT_READ_INTERFACE);
    eval 'sub UT_READ_ENDPOINT () {( &UT_READ |  &UT_STANDARD |  &UT_ENDPOINT);}' unless defined(&UT_READ_ENDPOINT);
    eval 'sub UT_WRITE_DEVICE () {( &UT_WRITE |  &UT_STANDARD |  &UT_DEVICE);}' unless defined(&UT_WRITE_DEVICE);
    eval 'sub UT_WRITE_INTERFACE () {( &UT_WRITE |  &UT_STANDARD |  &UT_INTERFACE);}' unless defined(&UT_WRITE_INTERFACE);
    eval 'sub UT_WRITE_ENDPOINT () {( &UT_WRITE |  &UT_STANDARD |  &UT_ENDPOINT);}' unless defined(&UT_WRITE_ENDPOINT);
    eval 'sub UT_READ_CLASS_DEVICE () {( &UT_READ |  &UT_CLASS |  &UT_DEVICE);}' unless defined(&UT_READ_CLASS_DEVICE);
    eval 'sub UT_READ_CLASS_INTERFACE () {( &UT_READ |  &UT_CLASS |  &UT_INTERFACE);}' unless defined(&UT_READ_CLASS_INTERFACE);
    eval 'sub UT_READ_CLASS_OTHER () {( &UT_READ |  &UT_CLASS |  &UT_OTHER);}' unless defined(&UT_READ_CLASS_OTHER);
    eval 'sub UT_READ_CLASS_ENDPOINT () {( &UT_READ |  &UT_CLASS |  &UT_ENDPOINT);}' unless defined(&UT_READ_CLASS_ENDPOINT);
    eval 'sub UT_WRITE_CLASS_DEVICE () {( &UT_WRITE |  &UT_CLASS |  &UT_DEVICE);}' unless defined(&UT_WRITE_CLASS_DEVICE);
    eval 'sub UT_WRITE_CLASS_INTERFACE () {( &UT_WRITE |  &UT_CLASS |  &UT_INTERFACE);}' unless defined(&UT_WRITE_CLASS_INTERFACE);
    eval 'sub UT_WRITE_CLASS_OTHER () {( &UT_WRITE |  &UT_CLASS |  &UT_OTHER);}' unless defined(&UT_WRITE_CLASS_OTHER);
    eval 'sub UT_WRITE_CLASS_ENDPOINT () {( &UT_WRITE |  &UT_CLASS |  &UT_ENDPOINT);}' unless defined(&UT_WRITE_CLASS_ENDPOINT);
    eval 'sub UT_READ_VENDOR_DEVICE () {( &UT_READ |  &UT_VENDOR |  &UT_DEVICE);}' unless defined(&UT_READ_VENDOR_DEVICE);
    eval 'sub UT_READ_VENDOR_INTERFACE () {( &UT_READ |  &UT_VENDOR |  &UT_INTERFACE);}' unless defined(&UT_READ_VENDOR_INTERFACE);
    eval 'sub UT_READ_VENDOR_OTHER () {( &UT_READ |  &UT_VENDOR |  &UT_OTHER);}' unless defined(&UT_READ_VENDOR_OTHER);
    eval 'sub UT_READ_VENDOR_ENDPOINT () {( &UT_READ |  &UT_VENDOR |  &UT_ENDPOINT);}' unless defined(&UT_READ_VENDOR_ENDPOINT);
    eval 'sub UT_WRITE_VENDOR_DEVICE () {( &UT_WRITE |  &UT_VENDOR |  &UT_DEVICE);}' unless defined(&UT_WRITE_VENDOR_DEVICE);
    eval 'sub UT_WRITE_VENDOR_INTERFACE () {( &UT_WRITE |  &UT_VENDOR |  &UT_INTERFACE);}' unless defined(&UT_WRITE_VENDOR_INTERFACE);
    eval 'sub UT_WRITE_VENDOR_OTHER () {( &UT_WRITE |  &UT_VENDOR |  &UT_OTHER);}' unless defined(&UT_WRITE_VENDOR_OTHER);
    eval 'sub UT_WRITE_VENDOR_ENDPOINT () {( &UT_WRITE |  &UT_VENDOR |  &UT_ENDPOINT);}' unless defined(&UT_WRITE_VENDOR_ENDPOINT);
    eval 'sub UR_GET_STATUS () {0x;}' unless defined(&UR_GET_STATUS);
    eval 'sub UR_CLEAR_FEATURE () {0x1;}' unless defined(&UR_CLEAR_FEATURE);
    eval 'sub UR_SET_FEATURE () {0x3;}' unless defined(&UR_SET_FEATURE);
    eval 'sub UR_SET_ADDRESS () {0x5;}' unless defined(&UR_SET_ADDRESS);
    eval 'sub UR_GET_DESCRIPTOR () {0x6;}' unless defined(&UR_GET_DESCRIPTOR);
    eval 'sub UDESC_DEVICE () {0x1;}' unless defined(&UDESC_DEVICE);
    eval 'sub UDESC_CONFIG () {0x2;}' unless defined(&UDESC_CONFIG);
    eval 'sub UDESC_STRING () {0x3;}' unless defined(&UDESC_STRING);
    eval 'sub UDESC_INTERFACE () {0x4;}' unless defined(&UDESC_INTERFACE);
    eval 'sub UDESC_ENDPOINT () {0x5;}' unless defined(&UDESC_ENDPOINT);
    eval 'sub UDESC_DEVICE_QUALIFIER () {0x6;}' unless defined(&UDESC_DEVICE_QUALIFIER);
    eval 'sub UDESC_OTHER_SPEED_CONFIGURATION () {0x7;}' unless defined(&UDESC_OTHER_SPEED_CONFIGURATION);
    eval 'sub UDESC_INTERFACE_POWER () {0x8;}' unless defined(&UDESC_INTERFACE_POWER);
    eval 'sub UDESC_OTG () {0x9;}' unless defined(&UDESC_OTG);
    eval 'sub UDESC_DEBUG () {0xa;}' unless defined(&UDESC_DEBUG);
    eval 'sub UDESC_INTERFACE_ASSOC () {0xb;}' unless defined(&UDESC_INTERFACE_ASSOC);
    eval 'sub UDESC_BOS () {0xf;}' unless defined(&UDESC_BOS);
    eval 'sub UDESC_DEVICE_CAPABILITY () {0x10;}' unless defined(&UDESC_DEVICE_CAPABILITY);
    eval 'sub UDESC_CS_DEVICE () {0x21;}' unless defined(&UDESC_CS_DEVICE);
    eval 'sub UDESC_CS_CONFIG () {0x22;}' unless defined(&UDESC_CS_CONFIG);
    eval 'sub UDESC_CS_STRING () {0x23;}' unless defined(&UDESC_CS_STRING);
    eval 'sub UDESC_CS_INTERFACE () {0x24;}' unless defined(&UDESC_CS_INTERFACE);
    eval 'sub UDESC_CS_ENDPOINT () {0x25;}' unless defined(&UDESC_CS_ENDPOINT);
    eval 'sub UDESC_HUB () {0x29;}' unless defined(&UDESC_HUB);
    eval 'sub UDESC_SS_HUB () {0x2a;}' unless defined(&UDESC_SS_HUB);
    eval 'sub UDESC_ENDPOINT_SS_COMP () {0x30;}' unless defined(&UDESC_ENDPOINT_SS_COMP);
    eval 'sub UDESC_ENDPOINT_ISOCH_SSP_COMP () {0x31;}' unless defined(&UDESC_ENDPOINT_ISOCH_SSP_COMP);
    eval 'sub UR_SET_DESCRIPTOR () {0x7;}' unless defined(&UR_SET_DESCRIPTOR);
    eval 'sub UR_GET_CONFIG () {0x8;}' unless defined(&UR_GET_CONFIG);
    eval 'sub UR_SET_CONFIG () {0x9;}' unless defined(&UR_SET_CONFIG);
    eval 'sub UR_GET_INTERFACE () {0xa;}' unless defined(&UR_GET_INTERFACE);
    eval 'sub UR_SET_INTERFACE () {0xb;}' unless defined(&UR_SET_INTERFACE);
    eval 'sub UR_SYNCH_FRAME () {0xc;}' unless defined(&UR_SYNCH_FRAME);
    eval 'sub UR_SET_ENCRYPTION () {0xd;}' unless defined(&UR_SET_ENCRYPTION);
    eval 'sub UR_GET_ENCRYPTION () {0xe;}' unless defined(&UR_GET_ENCRYPTION);
    eval 'sub UR_SET_HANDSHAKE () {0xf;}' unless defined(&UR_SET_HANDSHAKE);
    eval 'sub UR_GET_HANDSHAKE () {0x10;}' unless defined(&UR_GET_HANDSHAKE);
    eval 'sub UR_SET_CONNECTION () {0x11;}' unless defined(&UR_SET_CONNECTION);
    eval 'sub UR_SET_SECURITY_DATA () {0x12;}' unless defined(&UR_SET_SECURITY_DATA);
    eval 'sub UR_GET_SECURITY_DATA () {0x13;}' unless defined(&UR_GET_SECURITY_DATA);
    eval 'sub UR_SET_WUSB_DATA () {0x14;}' unless defined(&UR_SET_WUSB_DATA);
    eval 'sub UR_LOOPBACK_DATA_WRITE () {0x15;}' unless defined(&UR_LOOPBACK_DATA_WRITE);
    eval 'sub UR_LOOPBACK_DATA_READ () {0x16;}' unless defined(&UR_LOOPBACK_DATA_READ);
    eval 'sub UR_SET_INTERFACE_DS () {0x17;}' unless defined(&UR_SET_INTERFACE_DS);
    eval 'sub UR_SET_SEL () {0x30;}' unless defined(&UR_SET_SEL);
    eval 'sub UR_SET_ISOCH_DELAY () {0x31;}' unless defined(&UR_SET_ISOCH_DELAY);
    eval 'sub UF_ENDPOINT_HALT () {0;}' unless defined(&UF_ENDPOINT_HALT);
    eval 'sub UF_INTERFACE_FUNCTION_SUSPEND () {0;}' unless defined(&UF_INTERFACE_FUNCTION_SUSPEND);
    eval 'sub UF_DEVICE_REMOTE_WAKEUP () {1;}' unless defined(&UF_DEVICE_REMOTE_WAKEUP);
    eval 'sub UF_TEST_MODE () {2;}' unless defined(&UF_TEST_MODE);
    eval 'sub UF_DEVICE_B_HNP_ENABLE () {3;}' unless defined(&UF_DEVICE_B_HNP_ENABLE);
    eval 'sub UF_DEVICE_A_HNP_SUPPORT () {4;}' unless defined(&UF_DEVICE_A_HNP_SUPPORT);
    eval 'sub UF_DEVICE_A_ALT_HNP_SUPPORT () {5;}' unless defined(&UF_DEVICE_A_ALT_HNP_SUPPORT);
    eval 'sub UF_DEVICE_WUSB_DEVICE () {6;}' unless defined(&UF_DEVICE_WUSB_DEVICE);
    eval 'sub UF_U1_ENABLE () {0x30;}' unless defined(&UF_U1_ENABLE);
    eval 'sub UF_U2_ENABLE () {0x31;}' unless defined(&UF_U2_ENABLE);
    eval 'sub UF_LTM_ENABLE () {0x32;}' unless defined(&UF_LTM_ENABLE);
    eval 'sub USB_MAX_IPACKET () {8;}' unless defined(&USB_MAX_IPACKET);
    eval 'sub USB_2_MAX_CTRL_PACKET () {64;}' unless defined(&USB_2_MAX_CTRL_PACKET);
    eval 'sub USB_2_MAX_BULK_PACKET () {512;}' unless defined(&USB_2_MAX_BULK_PACKET);
    eval 'sub USB_3_MAX_CTRL_PACKET () {512;}' unless defined(&USB_3_MAX_CTRL_PACKET);
    eval 'sub USB_DESCRIPTOR_SIZE () {3;}' unless defined(&USB_DESCRIPTOR_SIZE);
    eval 'sub UD_USB_2_0 () {0x200;}' unless defined(&UD_USB_2_0);
    eval 'sub UD_USB_3_0 () {0x300;}' unless defined(&UD_USB_3_0);
    eval 'sub UD_IS_USB2 {
        my($d) = @_;
	    eval q(( &UGETW(($d)-> &bcdUSB) >=  &UD_USB_2_0));
    }' unless defined(&UD_IS_USB2);
    eval 'sub UD_IS_USB3 {
        my($d) = @_;
	    eval q(( &UGETW(($d)-> &bcdUSB) >=  &UD_USB_3_0));
    }' unless defined(&UD_IS_USB3);
    eval 'sub USB_DEVICE_DESCRIPTOR_SIZE () {18;}' unless defined(&USB_DEVICE_DESCRIPTOR_SIZE);
    eval 'sub UC_ATTR_MBO () {0x80;}' unless defined(&UC_ATTR_MBO);
    eval 'sub UC_SELF_POWERED () {0x40;}' unless defined(&UC_SELF_POWERED);
    eval 'sub UC_REMOTE_WAKEUP () {0x20;}' unless defined(&UC_REMOTE_WAKEUP);
    eval 'sub UC_POWER_FACTOR () {2;}' unless defined(&UC_POWER_FACTOR);
    eval 'sub UC_POWER_FACTOR_SS () {8;}' unless defined(&UC_POWER_FACTOR_SS);
    eval 'sub USB_CONFIG_DESCRIPTOR_SIZE () {9;}' unless defined(&USB_CONFIG_DESCRIPTOR_SIZE);
    eval 'sub USB_INTERFACE_DESCRIPTOR_SIZE () {9;}' unless defined(&USB_INTERFACE_DESCRIPTOR_SIZE);
    eval 'sub USB_INTERFACE_ASSOC_DESCRIPTOR_SIZE () {8;}' unless defined(&USB_INTERFACE_ASSOC_DESCRIPTOR_SIZE);
    eval 'sub UE_GET_DIR {
        my($a) = @_;
	    eval q((($a) & 0x80));
    }' unless defined(&UE_GET_DIR);
    eval 'sub UE_SET_DIR {
        my($a,$d) = @_;
	    eval q((($a) | ((($d)&1) << 7)));
    }' unless defined(&UE_SET_DIR);
    eval 'sub UE_DIR_IN () {0x80;}' unless defined(&UE_DIR_IN);
    eval 'sub UE_DIR_OUT () {0x;}' unless defined(&UE_DIR_OUT);
    eval 'sub UE_ADDR () {0xf;}' unless defined(&UE_ADDR);
    eval 'sub UE_GET_ADDR {
        my($a) = @_;
	    eval q((($a) &  &UE_ADDR));
    }' unless defined(&UE_GET_ADDR);
    eval 'sub UE_XFERTYPE () {0x3;}' unless defined(&UE_XFERTYPE);
    eval 'sub UE_CONTROL () {0x;}' unless defined(&UE_CONTROL);
    eval 'sub UE_ISOCHRONOUS () {0x1;}' unless defined(&UE_ISOCHRONOUS);
    eval 'sub UE_BULK () {0x2;}' unless defined(&UE_BULK);
    eval 'sub UE_INTERRUPT () {0x3;}' unless defined(&UE_INTERRUPT);
    eval 'sub UE_GET_XFERTYPE {
        my($a) = @_;
	    eval q((($a) &  &UE_XFERTYPE));
    }' unless defined(&UE_GET_XFERTYPE);
    eval 'sub UE_ISO_TYPE () {0xc;}' unless defined(&UE_ISO_TYPE);
    eval 'sub UE_ISO_ASYNC () {0x4;}' unless defined(&UE_ISO_ASYNC);
    eval 'sub UE_ISO_ADAPT () {0x8;}' unless defined(&UE_ISO_ADAPT);
    eval 'sub UE_ISO_SYNC () {0xc;}' unless defined(&UE_ISO_SYNC);
    eval 'sub UE_GET_ISO_TYPE {
        my($a) = @_;
	    eval q((($a) &  &UE_ISO_TYPE));
    }' unless defined(&UE_GET_ISO_TYPE);
    eval 'sub UE_GET_TRANS {
        my($a) = @_;
	    eval q(((($a) >> 11) & 0x3));
    }' unless defined(&UE_GET_TRANS);
    eval 'sub UE_GET_SIZE {
        my($a) = @_;
	    eval q((($a) & 0x7ff));
    }' unless defined(&UE_GET_SIZE);
    eval 'sub USB_ENDPOINT_DESCRIPTOR_SIZE () {7;}' unless defined(&USB_ENDPOINT_DESCRIPTOR_SIZE);
    eval 'sub UE_GET_BULK_STREAMS_MASK () { &__BITS(4,0);}' unless defined(&UE_GET_BULK_STREAMS_MASK);
    eval 'sub UE_GET_BULK_STREAMS {
        my($x) = @_;
	    eval q( &__SHIFTOUT($x,  &UE_GET_BULK_STREAMS_MASK));
    }' unless defined(&UE_GET_BULK_STREAMS);
    eval 'sub UE_GET_SS_ISO_MULT_MASK () { &__BITS(1,0);}' unless defined(&UE_GET_SS_ISO_MULT_MASK);
    eval 'sub UE_GET_SS_ISO_MULT {
        my($x) = @_;
	    eval q( &__SHIFTOUT($x,  &UE_GET_SS_ISO_MULT_MASK));
    }' unless defined(&UE_GET_SS_ISO_MULT);
    eval 'sub UE_GET_SS_ISO_SSP_MASK () { &__BIT(7);}' unless defined(&UE_GET_SS_ISO_SSP_MASK);
    eval 'sub UE_GET_SS_ISO_SSP {
        my($x) = @_;
	    eval q( &__SHIFTOUT($x,  &UE_GET_SS_ISO_SSP_MASK));
    }' unless defined(&UE_GET_SS_ISO_SSP);
    eval 'sub USB_ENDPOINT_SS_COMP_DESCRIPTOR_SIZE () {6;}' unless defined(&USB_ENDPOINT_SS_COMP_DESCRIPTOR_SIZE);
    eval 'sub USB_BOS_DESCRIPTOR_SIZE () {5;}' unless defined(&USB_BOS_DESCRIPTOR_SIZE);
    eval 'sub USB_DEVCAP_RESERVED () {0x;}' unless defined(&USB_DEVCAP_RESERVED);
    eval 'sub USB_DEVCAP_WUSB () {0x1;}' unless defined(&USB_DEVCAP_WUSB);
    eval 'sub USB_DEVCAP_USB2EXT () {0x2;}' unless defined(&USB_DEVCAP_USB2EXT);
    eval 'sub USB_DEVCAP_SUPER_SPEED () {0x3;}' unless defined(&USB_DEVCAP_SUPER_SPEED);
    eval 'sub USB_DEVCAP_CONTAINER_ID () {0x4;}' unless defined(&USB_DEVCAP_CONTAINER_ID);
    eval 'sub USB_DEVCAP_PLATFORM () {0x5;}' unless defined(&USB_DEVCAP_PLATFORM);
    eval 'sub USB_DEVCAP_POWER_DELIVERY_CAPABILITY () {0x6;}' unless defined(&USB_DEVCAP_POWER_DELIVERY_CAPABILITY);
    eval 'sub USB_DEVCAP_BATTERY_INFO_CAPABILITY () {0x7;}' unless defined(&USB_DEVCAP_BATTERY_INFO_CAPABILITY);
    eval 'sub USB_DEVCAP_PD_CONSUMER_PORT_CAPABILITY () {0x8;}' unless defined(&USB_DEVCAP_PD_CONSUMER_PORT_CAPABILITY);
    eval 'sub USB_DEVCAP_PD_PROVIDER_PORT_CAPABILITY () {0x9;}' unless defined(&USB_DEVCAP_PD_PROVIDER_PORT_CAPABILITY);
    eval 'sub USB_DEVCAP_SUPERSPEED_PLUS () {0xa;}' unless defined(&USB_DEVCAP_SUPERSPEED_PLUS);
    eval 'sub USB_DEVCAP_PRECISION_TIME_MEASUREMENT () {0xb;}' unless defined(&USB_DEVCAP_PRECISION_TIME_MEASUREMENT);
    eval 'sub USB_DEVCAP_WUSB_EXT () {0xc;}' unless defined(&USB_DEVCAP_WUSB_EXT);
    eval 'sub USB_DEVICE_CAPABILITY_DESCRIPTOR_SIZE () {3;}' unless defined(&USB_DEVICE_CAPABILITY_DESCRIPTOR_SIZE);
    eval 'sub USB_DEVCAP_V2EXT_LPM () { &__BIT(1);}' unless defined(&USB_DEVCAP_V2EXT_LPM);
    eval 'sub USB_DEVCAP_V2EXT_BESL_SUPPORTED () { &__BIT(2);}' unless defined(&USB_DEVCAP_V2EXT_BESL_SUPPORTED);
    eval 'sub USB_DEVCAP_V2EXT_BESL_BASELINE_VALID () { &__BIT(3);}' unless defined(&USB_DEVCAP_V2EXT_BESL_BASELINE_VALID);
    eval 'sub USB_DEVCAP_V2EXT_BESL_DEEP_VALID () { &__BIT(4);}' unless defined(&USB_DEVCAP_V2EXT_BESL_DEEP_VALID);
    eval 'sub USB_DEVCAP_V2EXT_BESL_BASELINE_MASK () { &__BITS(11, 8);}' unless defined(&USB_DEVCAP_V2EXT_BESL_BASELINE_MASK);
    eval 'sub USB_DEVCAP_V2EXT_BESL_BASELINE_GET {
        my($x) = @_;
	    eval q( &__SHIFTOUT($x,  &USB_V2EXT_BESL_BASELINE_MASK));
    }' unless defined(&USB_DEVCAP_V2EXT_BESL_BASELINE_GET);
    eval 'sub USB_DEVCAP_V2EXT_BESL_DEEP_MASK () { &__BITS(15, 12);}' unless defined(&USB_DEVCAP_V2EXT_BESL_DEEP_MASK);
    eval 'sub USB_DEVCAP_V2EXT_BESL_DEEP_GET {
        my($x) = @_;
	    eval q( &__SHIFTOUT($x,  &USB_V2EXT_BESL_DEEP_MASK));
    }' unless defined(&USB_DEVCAP_V2EXT_BESL_DEEP_GET);
    eval 'sub USB_DEVCAP_USB2EXT_DESCRIPTOR_SIZE () {7;}' unless defined(&USB_DEVCAP_USB2EXT_DESCRIPTOR_SIZE);
    eval 'sub USB_DEVCAP_SS_LTM () { &__BIT(1);}' unless defined(&USB_DEVCAP_SS_LTM);
    eval 'sub USB_DEVCAP_SS_SPEED_LS () { &__BIT(0);}' unless defined(&USB_DEVCAP_SS_SPEED_LS);
    eval 'sub USB_DEVCAP_SS_SPEED_FS () { &__BIT(1);}' unless defined(&USB_DEVCAP_SS_SPEED_FS);
    eval 'sub USB_DEVCAP_SS_SPEED_HS () { &__BIT(2);}' unless defined(&USB_DEVCAP_SS_SPEED_HS);
    eval 'sub USB_DEVCAP_SS_SPEED_SS () { &__BIT(3);}' unless defined(&USB_DEVCAP_SS_SPEED_SS);
    eval 'sub USB_DEVCAP_SS_DESCRIPTOR_SIZE () {10;}' unless defined(&USB_DEVCAP_SS_DESCRIPTOR_SIZE);
    eval 'sub USB_DEVCAP_CONTAINER_ID_DESCRIPTOR_SIZE () {20;}' unless defined(&USB_DEVCAP_CONTAINER_ID_DESCRIPTOR_SIZE);
    eval 'sub USB_DEVCAP_PLATFORM_DESCRIPTOR_SIZE () {20;}' unless defined(&USB_DEVCAP_PLATFORM_DESCRIPTOR_SIZE);
    eval 'sub USB_DEVCAP_SSP_SSAC {
        my($x) = @_;
	    eval q( &__SHIFTOUT($x,  &__BITS(4,0)));
    }' unless defined(&USB_DEVCAP_SSP_SSAC);
    eval 'sub USB_DEVCAP_SSP_SSIC {
        my($x) = @_;
	    eval q( &__SHIFTOUT($x,  &__BITS(8,5)));
    }' unless defined(&USB_DEVCAP_SSP_SSIC);
    eval 'sub USB_DEVCAP_SSP_SSID {
        my($x) = @_;
	    eval q( &__SHIFTOUT($x,  &__BITS(3,0)));
    }' unless defined(&USB_DEVCAP_SSP_SSID);
    eval 'sub USB_DEVCAP_SSP_MIN_RXLANE_COUNT {
        my($x) = @_;
	    eval q( &__SHIFTOUT($x,  &__BITS(11,8)));
    }' unless defined(&USB_DEVCAP_SSP_MIN_RXLANE_COUNT);
    eval 'sub USB_DEVCAP_SSP_MIN_TXLANE_COUNT {
        my($x) = @_;
	    eval q( &__SHIFTOUT($x,  &__BITS(15,12)));
    }' unless defined(&USB_DEVCAP_SSP_MIN_TXLANE_COUNT);
    eval 'sub USB_DEVCAP_SSP_SSID {
        my($x) = @_;
	    eval q( &__SHIFTOUT($x,  &__BITS(3,0)));
    }' unless defined(&USB_DEVCAP_SSP_SSID);
    eval 'sub USB_DEVCAP_SSP_LSE {
        my($x) = @_;
	    eval q( &__SHIFTOUT($x,  &__BITS(5,4)));
    }' unless defined(&USB_DEVCAP_SSP_LSE);
    eval 'sub USB_DEVCAP_SSP_ST {
        my($x) = @_;
	    eval q( &__SHIFTOUT($x,  &__BITS(7,6)));
    }' unless defined(&USB_DEVCAP_SSP_ST);
    eval 'sub USB_DEVCAP_SSP_LP {
        my($x) = @_;
	    eval q( &__SHIFTOUT($x,  &__BITS(15,14)));
    }' unless defined(&USB_DEVCAP_SSP_LP);
    eval 'sub USB_DEVCAP_SSP_LSM {
        my($x) = @_;
	    eval q( &__SHIFTOUT($x,  &__BITS(31,16)));
    }' unless defined(&USB_DEVCAP_SSP_LSM);
    eval 'sub USB_DEVCAP_SSP_DESCRIPTOR_SIZE () {12;}' unless defined(&USB_DEVCAP_SSP_DESCRIPTOR_SIZE);
    eval 'sub USB_MAX_STRING_LEN () {128;}' unless defined(&USB_MAX_STRING_LEN);
    eval 'sub USB_LANGUAGE_TABLE () {0;}' unless defined(&USB_LANGUAGE_TABLE);
    eval 'sub USB_MAX_ENCODED_STRING_LEN () {( &USB_MAX_STRING_LEN * 3);}' unless defined(&USB_MAX_ENCODED_STRING_LEN);
    eval 'sub UR_GET_BUS_STATE () {0x2;}' unless defined(&UR_GET_BUS_STATE);
    eval 'sub UR_CLEAR_TT_BUFFER () {0x8;}' unless defined(&UR_CLEAR_TT_BUFFER);
    eval 'sub UR_RESET_TT () {0x9;}' unless defined(&UR_RESET_TT);
    eval 'sub UR_GET_TT_STATE () {0xa;}' unless defined(&UR_GET_TT_STATE);
    eval 'sub UR_STOP_TT () {0xb;}' unless defined(&UR_STOP_TT);
    eval 'sub UR_SET_AND_TEST () {0xc;}' unless defined(&UR_SET_AND_TEST);
    eval 'sub UR_SET_HUB_DEPTH () {0xc;}' unless defined(&UR_SET_HUB_DEPTH);
    eval 'sub UR_GET_PORT_ERR_COUNT () {0xd;}' unless defined(&UR_GET_PORT_ERR_COUNT);
    eval 'sub UR_PST_PORT_STATUS () {0;}' unless defined(&UR_PST_PORT_STATUS);
    eval 'sub UR_PST_PD_STATUS () {1;}' unless defined(&UR_PST_PD_STATUS);
    eval 'sub UR_PST_EXT_PORT_STATUS () {2;}' unless defined(&UR_PST_EXT_PORT_STATUS);
    eval 'sub UHF_C_HUB_LOCAL_POWER () {0;}' unless defined(&UHF_C_HUB_LOCAL_POWER);
    eval 'sub UHF_C_HUB_OVER_CURRENT () {1;}' unless defined(&UHF_C_HUB_OVER_CURRENT);
    eval 'sub UHF_PORT_CONNECTION () {0;}' unless defined(&UHF_PORT_CONNECTION);
    eval 'sub UHF_PORT_ENABLE () {1;}' unless defined(&UHF_PORT_ENABLE);
    eval 'sub UHF_PORT_SUSPEND () {2;}' unless defined(&UHF_PORT_SUSPEND);
    eval 'sub UHF_PORT_OVER_CURRENT () {3;}' unless defined(&UHF_PORT_OVER_CURRENT);
    eval 'sub UHF_PORT_RESET () {4;}' unless defined(&UHF_PORT_RESET);
    eval 'sub UHF_PORT_LINK_STATE () {5;}' unless defined(&UHF_PORT_LINK_STATE);
    eval 'sub UHF_PORT_POWER () {8;}' unless defined(&UHF_PORT_POWER);
    eval 'sub UHF_PORT_LOW_SPEED () {9;}' unless defined(&UHF_PORT_LOW_SPEED);
    eval 'sub UHF_PORT_L1 () {10;}' unless defined(&UHF_PORT_L1);
    eval 'sub UHF_C_PORT_CONNECTION () {16;}' unless defined(&UHF_C_PORT_CONNECTION);
    eval 'sub UHF_C_PORT_ENABLE () {17;}' unless defined(&UHF_C_PORT_ENABLE);
    eval 'sub UHF_C_PORT_SUSPEND () {18;}' unless defined(&UHF_C_PORT_SUSPEND);
    eval 'sub UHF_C_PORT_OVER_CURRENT () {19;}' unless defined(&UHF_C_PORT_OVER_CURRENT);
    eval 'sub UHF_C_PORT_RESET () {20;}' unless defined(&UHF_C_PORT_RESET);
    eval 'sub UHF_PORT_TEST () {21;}' unless defined(&UHF_PORT_TEST);
    eval 'sub UHF_PORT_INDICATOR () {22;}' unless defined(&UHF_PORT_INDICATOR);
    eval 'sub UHF_C_PORT_L1 () {23;}' unless defined(&UHF_C_PORT_L1);
    eval 'sub UHF_PORT_U1_TIMEOUT () {23;}' unless defined(&UHF_PORT_U1_TIMEOUT);
    eval 'sub UHF_PORT_U2_TIMEOUT () {24;}' unless defined(&UHF_PORT_U2_TIMEOUT);
    eval 'sub UHF_C_PORT_LINK_STATE () {25;}' unless defined(&UHF_C_PORT_LINK_STATE);
    eval 'sub UHF_C_PORT_CONFIG_ERROR () {26;}' unless defined(&UHF_C_PORT_CONFIG_ERROR);
    eval 'sub UHF_PORT_REMOTE_WAKE_MASK () {27;}' unless defined(&UHF_PORT_REMOTE_WAKE_MASK);
    eval 'sub UHF_BH_PORT_RESET () {28;}' unless defined(&UHF_BH_PORT_RESET);
    eval 'sub UHF_C_BH_PORT_RESET () {29;}' unless defined(&UHF_C_BH_PORT_RESET);
    eval 'sub UHF_FORCE_LINKPM_ACCEPT () {30;}' unless defined(&UHF_FORCE_LINKPM_ACCEPT);
    eval 'sub UHD_NPORTS_MAX () {255;}' unless defined(&UHD_NPORTS_MAX);
    eval 'sub UHD_PWR () {0x3;}' unless defined(&UHD_PWR);
    eval 'sub UHD_PWR_GANGED () {0x;}' unless defined(&UHD_PWR_GANGED);
    eval 'sub UHD_PWR_INDIVIDUAL () {0x1;}' unless defined(&UHD_PWR_INDIVIDUAL);
    eval 'sub UHD_PWR_NO_SWITCH () {0x2;}' unless defined(&UHD_PWR_NO_SWITCH);
    eval 'sub UHD_COMPOUND () {0x4;}' unless defined(&UHD_COMPOUND);
    eval 'sub UHD_OC () {0x18;}' unless defined(&UHD_OC);
    eval 'sub UHD_OC_GLOBAL () {0x;}' unless defined(&UHD_OC_GLOBAL);
    eval 'sub UHD_OC_INDIVIDUAL () {0x8;}' unless defined(&UHD_OC_INDIVIDUAL);
    eval 'sub UHD_OC_NONE () {0x10;}' unless defined(&UHD_OC_NONE);
    eval 'sub UHD_TT_THINK () {0x60;}' unless defined(&UHD_TT_THINK);
    eval 'sub UHD_TT_THINK_8 () {0x;}' unless defined(&UHD_TT_THINK_8);
    eval 'sub UHD_TT_THINK_16 () {0x20;}' unless defined(&UHD_TT_THINK_16);
    eval 'sub UHD_TT_THINK_24 () {0x40;}' unless defined(&UHD_TT_THINK_24);
    eval 'sub UHD_TT_THINK_32 () {0x60;}' unless defined(&UHD_TT_THINK_32);
    eval 'sub UHD_PORT_IND () {0x80;}' unless defined(&UHD_PORT_IND);
    eval 'sub UHD_PWRON_FACTOR () {2;}' unless defined(&UHD_PWRON_FACTOR);
    eval 'sub UHD_NOT_REMOV {
        my($desc, $i) = @_;
	    eval q(((($desc)-> $DeviceRemovable[($i)/8] >> (($i) % 8)) & 1));
    }' unless defined(&UHD_NOT_REMOV);
    eval 'sub USB_HUB_DESCRIPTOR_SIZE () {9;}' unless defined(&USB_HUB_DESCRIPTOR_SIZE);
    eval 'sub UHD_SS_NPORTS_MAX () {15;}' unless defined(&UHD_SS_NPORTS_MAX);
    eval 'sub USB_HUB_SS_DESCRIPTOR_SIZE () {12;}' unless defined(&USB_HUB_SS_DESCRIPTOR_SIZE);
    eval 'sub USB_DEVICE_QUALIFIER_SIZE () {10;}' unless defined(&USB_DEVICE_QUALIFIER_SIZE);
    eval 'sub UOTG_SRP () {0x1;}' unless defined(&UOTG_SRP);
    eval 'sub UOTG_HNP () {0x2;}' unless defined(&UOTG_HNP);
    eval 'sub UOTG_B_HNP_ENABLE () {3;}' unless defined(&UOTG_B_HNP_ENABLE);
    eval 'sub UOTG_A_HNP_SUPPORT () {4;}' unless defined(&UOTG_A_HNP_SUPPORT);
    eval 'sub UOTG_A_ALT_HNP_SUPPORT () {5;}' unless defined(&UOTG_A_ALT_HNP_SUPPORT);
    eval 'sub UDS_SELF_POWERED () {0x1;}' unless defined(&UDS_SELF_POWERED);
    eval 'sub UDS_REMOTE_WAKEUP () {0x2;}' unless defined(&UDS_REMOTE_WAKEUP);
    eval 'sub UES_HALT () {0x1;}' unless defined(&UES_HALT);
    eval 'sub UHS_LOCAL_POWER () {0x1;}' unless defined(&UHS_LOCAL_POWER);
    eval 'sub UHS_OVER_CURRENT () {0x2;}' unless defined(&UHS_OVER_CURRENT);
    eval 'sub UPS_CURRENT_CONNECT_STATUS () {0x1;}' unless defined(&UPS_CURRENT_CONNECT_STATUS);
    eval 'sub UPS_PORT_ENABLED () {0x2;}' unless defined(&UPS_PORT_ENABLED);
    eval 'sub UPS_SUSPEND () {0x4;}' unless defined(&UPS_SUSPEND);
    eval 'sub UPS_OVERCURRENT_INDICATOR () {0x8;}' unless defined(&UPS_OVERCURRENT_INDICATOR);
    eval 'sub UPS_RESET () {0x10;}' unless defined(&UPS_RESET);
    eval 'sub UPS_PORT_L1 () {0x20;}' unless defined(&UPS_PORT_L1);
    eval 'sub UPS_PORT_LS_MASK () { &__BITS(8,5);}' unless defined(&UPS_PORT_LS_MASK);
    eval 'sub UPS_PORT_LS_GET {
        my($x) = @_;
	    eval q( &__SHIFTOUT($x,  &UPS_PORT_LS_MASK));
    }' unless defined(&UPS_PORT_LS_GET);
    eval 'sub UPS_PORT_LS_SET {
        my($x) = @_;
	    eval q( &__SHIFTIN($x,  &UPS_PORT_LS_MASK));
    }' unless defined(&UPS_PORT_LS_SET);
    eval 'sub UPS_PORT_LS_U0 () {0x;}' unless defined(&UPS_PORT_LS_U0);
    eval 'sub UPS_PORT_LS_U1 () {0x1;}' unless defined(&UPS_PORT_LS_U1);
    eval 'sub UPS_PORT_LS_U2 () {0x2;}' unless defined(&UPS_PORT_LS_U2);
    eval 'sub UPS_PORT_LS_U3 () {0x3;}' unless defined(&UPS_PORT_LS_U3);
    eval 'sub UPS_PORT_LS_SS_DIS () {0x4;}' unless defined(&UPS_PORT_LS_SS_DIS);
    eval 'sub UPS_PORT_LS_RX_DET () {0x5;}' unless defined(&UPS_PORT_LS_RX_DET);
    eval 'sub UPS_PORT_LS_SS_INA () {0x6;}' unless defined(&UPS_PORT_LS_SS_INA);
    eval 'sub UPS_PORT_LS_POLL () {0x7;}' unless defined(&UPS_PORT_LS_POLL);
    eval 'sub UPS_PORT_LS_RECOVER () {0x8;}' unless defined(&UPS_PORT_LS_RECOVER);
    eval 'sub UPS_PORT_LS_HOT_RST () {0x9;}' unless defined(&UPS_PORT_LS_HOT_RST);
    eval 'sub UPS_PORT_LS_COMP_MODE () {0xa;}' unless defined(&UPS_PORT_LS_COMP_MODE);
    eval 'sub UPS_PORT_LS_LOOPBACK () {0xb;}' unless defined(&UPS_PORT_LS_LOOPBACK);
    eval 'sub UPS_PORT_LS_RESUME () {0xf;}' unless defined(&UPS_PORT_LS_RESUME);
    eval 'sub UPS_PORT_POWER () {0x100;}' unless defined(&UPS_PORT_POWER);
    eval 'sub UPS_PORT_POWER_SS () {0x200;}' unless defined(&UPS_PORT_POWER_SS);
    eval 'sub UPS_FULL_SPEED () {0x;}' unless defined(&UPS_FULL_SPEED);
    eval 'sub UPS_LOW_SPEED () {0x200;}' unless defined(&UPS_LOW_SPEED);
    eval 'sub UPS_HIGH_SPEED () {0x400;}' unless defined(&UPS_HIGH_SPEED);
    eval 'sub UPS_PORT_TEST () {0x800;}' unless defined(&UPS_PORT_TEST);
    eval 'sub UPS_PORT_INDICATOR () {0x1000;}' unless defined(&UPS_PORT_INDICATOR);
    eval 'sub UPS_OTHER_SPEED () {0x2000;}' unless defined(&UPS_OTHER_SPEED);
    eval 'sub UPS_C_CONNECT_STATUS () {0x1;}' unless defined(&UPS_C_CONNECT_STATUS);
    eval 'sub UPS_C_PORT_ENABLED () {0x2;}' unless defined(&UPS_C_PORT_ENABLED);
    eval 'sub UPS_C_SUSPEND () {0x4;}' unless defined(&UPS_C_SUSPEND);
    eval 'sub UPS_C_OVERCURRENT_INDICATOR () {0x8;}' unless defined(&UPS_C_OVERCURRENT_INDICATOR);
    eval 'sub UPS_C_PORT_RESET () {0x10;}' unless defined(&UPS_C_PORT_RESET);
    eval 'sub UPS_C_PORT_L1 () {0x20;}' unless defined(&UPS_C_PORT_L1);
    eval 'sub UPS_C_BH_PORT_RESET () {0x20;}' unless defined(&UPS_C_BH_PORT_RESET);
    eval 'sub UPS_C_PORT_LINK_STATE () {0x40;}' unless defined(&UPS_C_PORT_LINK_STATE);
    eval 'sub UPS_C_PORT_CONFIG_ERROR () {0x80;}' unless defined(&UPS_C_PORT_CONFIG_ERROR);
    eval 'sub UDCLASS_IN_INTERFACE () {0x;}' unless defined(&UDCLASS_IN_INTERFACE);
    eval 'sub UDCLASS_COMM () {0x2;}' unless defined(&UDCLASS_COMM);
    eval 'sub UDCLASS_HUB () {0x9;}' unless defined(&UDCLASS_HUB);
    eval 'sub UDSUBCLASS_HUB () {0x;}' unless defined(&UDSUBCLASS_HUB);
    eval 'sub UDPROTO_FSHUB () {0x;}' unless defined(&UDPROTO_FSHUB);
    eval 'sub UDPROTO_HSHUBSTT () {0x1;}' unless defined(&UDPROTO_HSHUBSTT);
    eval 'sub UDPROTO_HSHUBMTT () {0x2;}' unless defined(&UDPROTO_HSHUBMTT);
    eval 'sub UDPROTO_SSHUB () {0x3;}' unless defined(&UDPROTO_SSHUB);
    eval 'sub UDCLASS_DIAGNOSTIC () {0xdc;}' unless defined(&UDCLASS_DIAGNOSTIC);
    eval 'sub UDCLASS_WIRELESS () {0xe0;}' unless defined(&UDCLASS_WIRELESS);
    eval 'sub UDSUBCLASS_RF () {0x1;}' unless defined(&UDSUBCLASS_RF);
    eval 'sub UDPROTO_BLUETOOTH () {0x1;}' unless defined(&UDPROTO_BLUETOOTH);
    eval 'sub UDCLASS_VENDOR () {0xff;}' unless defined(&UDCLASS_VENDOR);
    eval 'sub UICLASS_UNSPEC () {0x;}' unless defined(&UICLASS_UNSPEC);
    eval 'sub UICLASS_AUDIO () {0x1;}' unless defined(&UICLASS_AUDIO);
    eval 'sub UISUBCLASS_AUDIOCONTROL () {1;}' unless defined(&UISUBCLASS_AUDIOCONTROL);
    eval 'sub UISUBCLASS_AUDIOSTREAM () {2;}' unless defined(&UISUBCLASS_AUDIOSTREAM);
    eval 'sub UISUBCLASS_MIDISTREAM () {3;}' unless defined(&UISUBCLASS_MIDISTREAM);
    eval 'sub UICLASS_VIDEO () {0xe;}' unless defined(&UICLASS_VIDEO);
    eval 'sub UISUBCLASS_VIDEOCONTROL () {1;}' unless defined(&UISUBCLASS_VIDEOCONTROL);
    eval 'sub UISUBCLASS_VIDEOSTREAMING () {2;}' unless defined(&UISUBCLASS_VIDEOSTREAMING);
    eval 'sub UISUBCLASS_VIDEOCOLLECTION () {3;}' unless defined(&UISUBCLASS_VIDEOCOLLECTION);
    eval 'sub UICLASS_CDC () {0x2;}' unless defined(&UICLASS_CDC);
    eval 'sub UISUBCLASS_DIRECT_LINE_CONTROL_MODEL () {1;}' unless defined(&UISUBCLASS_DIRECT_LINE_CONTROL_MODEL);
    eval 'sub UISUBCLASS_ABSTRACT_CONTROL_MODEL () {2;}' unless defined(&UISUBCLASS_ABSTRACT_CONTROL_MODEL);
    eval 'sub UISUBCLASS_TELEPHONE_CONTROL_MODEL () {3;}' unless defined(&UISUBCLASS_TELEPHONE_CONTROL_MODEL);
    eval 'sub UISUBCLASS_MULTICHANNEL_CONTROL_MODEL () {4;}' unless defined(&UISUBCLASS_MULTICHANNEL_CONTROL_MODEL);
    eval 'sub UISUBCLASS_CAPI_CONTROLMODEL () {5;}' unless defined(&UISUBCLASS_CAPI_CONTROLMODEL);
    eval 'sub UISUBCLASS_ETHERNET_NETWORKING_CONTROL_MODEL () {6;}' unless defined(&UISUBCLASS_ETHERNET_NETWORKING_CONTROL_MODEL);
    eval 'sub UISUBCLASS_ATM_NETWORKING_CONTROL_MODEL () {7;}' unless defined(&UISUBCLASS_ATM_NETWORKING_CONTROL_MODEL);
    eval 'sub UISUBCLASS_MOBILE_DIRECT_LINE_MODEL () {10;}' unless defined(&UISUBCLASS_MOBILE_DIRECT_LINE_MODEL);
    eval 'sub UISUBCLASS_NETWORK_CONTROL_MODEL () {13;}' unless defined(&UISUBCLASS_NETWORK_CONTROL_MODEL);
    eval 'sub UISUBCLASS_MOBILE_BROADBAND_INTERFACE_MODEL () {14;}' unless defined(&UISUBCLASS_MOBILE_BROADBAND_INTERFACE_MODEL);
    eval 'sub UIPROTO_CDC_NOCLASS () {0;}' unless defined(&UIPROTO_CDC_NOCLASS);
    eval 'sub UIPROTO_CDC_AT () {1;}' unless defined(&UIPROTO_CDC_AT);
    eval 'sub UICLASS_HID () {0x3;}' unless defined(&UICLASS_HID);
    eval 'sub UISUBCLASS_BOOT () {1;}' unless defined(&UISUBCLASS_BOOT);
    eval 'sub UIPROTO_BOOT_KEYBOARD () {1;}' unless defined(&UIPROTO_BOOT_KEYBOARD);
    eval 'sub UIPROTO_MOUSE () {2;}' unless defined(&UIPROTO_MOUSE);
    eval 'sub UICLASS_PHYSICAL () {0x5;}' unless defined(&UICLASS_PHYSICAL);
    eval 'sub UICLASS_IMAGE () {0x6;}' unless defined(&UICLASS_IMAGE);
    eval 'sub UICLASS_PRINTER () {0x7;}' unless defined(&UICLASS_PRINTER);
    eval 'sub UISUBCLASS_PRINTER () {1;}' unless defined(&UISUBCLASS_PRINTER);
    eval 'sub UIPROTO_PRINTER_UNI () {1;}' unless defined(&UIPROTO_PRINTER_UNI);
    eval 'sub UIPROTO_PRINTER_BI () {2;}' unless defined(&UIPROTO_PRINTER_BI);
    eval 'sub UIPROTO_PRINTER_1284 () {3;}' unless defined(&UIPROTO_PRINTER_1284);
    eval 'sub UICLASS_MASS () {0x8;}' unless defined(&UICLASS_MASS);
    eval 'sub UISUBCLASS_RBC () {1;}' unless defined(&UISUBCLASS_RBC);
    eval 'sub UISUBCLASS_SFF8020I () {2;}' unless defined(&UISUBCLASS_SFF8020I);
    eval 'sub UISUBCLASS_QIC157 () {3;}' unless defined(&UISUBCLASS_QIC157);
    eval 'sub UISUBCLASS_UFI () {4;}' unless defined(&UISUBCLASS_UFI);
    eval 'sub UISUBCLASS_SFF8070I () {5;}' unless defined(&UISUBCLASS_SFF8070I);
    eval 'sub UISUBCLASS_SCSI () {6;}' unless defined(&UISUBCLASS_SCSI);
    eval 'sub UIPROTO_MASS_CBI_I () {0;}' unless defined(&UIPROTO_MASS_CBI_I);
    eval 'sub UIPROTO_MASS_CBI () {1;}' unless defined(&UIPROTO_MASS_CBI);
    eval 'sub UIPROTO_MASS_BBB_OLD () {2;}' unless defined(&UIPROTO_MASS_BBB_OLD);
    eval 'sub UIPROTO_MASS_BBB () {80;}' unless defined(&UIPROTO_MASS_BBB);
    eval 'sub UIPROTO_MASS_UAS () {98;}' unless defined(&UIPROTO_MASS_UAS);
    eval 'sub UICLASS_HUB () {0x9;}' unless defined(&UICLASS_HUB);
    eval 'sub UISUBCLASS_HUB () {0;}' unless defined(&UISUBCLASS_HUB);
    eval 'sub UIPROTO_FSHUB () {0;}' unless defined(&UIPROTO_FSHUB);
    eval 'sub UIPROTO_HSHUBSTT () {0;}' unless defined(&UIPROTO_HSHUBSTT);
    eval 'sub UIPROTO_HSHUBMTT () {1;}' unless defined(&UIPROTO_HSHUBMTT);
    eval 'sub UICLASS_CDC_DATA () {0xa;}' unless defined(&UICLASS_CDC_DATA);
    eval 'sub UISUBCLASS_DATA () {0;}' unless defined(&UISUBCLASS_DATA);
    eval 'sub UIPROTO_DATA_MBIM () {0x2;}' unless defined(&UIPROTO_DATA_MBIM);
    eval 'sub UIPROTO_DATA_ISDNBRI () {0x30;}' unless defined(&UIPROTO_DATA_ISDNBRI);
    eval 'sub UIPROTO_DATA_HDLC () {0x31;}' unless defined(&UIPROTO_DATA_HDLC);
    eval 'sub UIPROTO_DATA_TRANSPARENT () {0x32;}' unless defined(&UIPROTO_DATA_TRANSPARENT);
    eval 'sub UIPROTO_DATA_Q921M () {0x50;}' unless defined(&UIPROTO_DATA_Q921M);
    eval 'sub UIPROTO_DATA_Q921 () {0x51;}' unless defined(&UIPROTO_DATA_Q921);
    eval 'sub UIPROTO_DATA_Q921TM () {0x52;}' unless defined(&UIPROTO_DATA_Q921TM);
    eval 'sub UIPROTO_DATA_V42BIS () {0x90;}' unless defined(&UIPROTO_DATA_V42BIS);
    eval 'sub UIPROTO_DATA_Q931 () {0x91;}' unless defined(&UIPROTO_DATA_Q931);
    eval 'sub UIPROTO_DATA_V120 () {0x92;}' unless defined(&UIPROTO_DATA_V120);
    eval 'sub UIPROTO_DATA_CAPI () {0x93;}' unless defined(&UIPROTO_DATA_CAPI);
    eval 'sub UIPROTO_DATA_HOST_BASED () {0xfd;}' unless defined(&UIPROTO_DATA_HOST_BASED);
    eval 'sub UIPROTO_DATA_PUF () {0xfe;}' unless defined(&UIPROTO_DATA_PUF);
    eval 'sub UIPROTO_DATA_VENDOR () {0xff;}' unless defined(&UIPROTO_DATA_VENDOR);
    eval 'sub UICLASS_SMARTCARD () {0xb;}' unless defined(&UICLASS_SMARTCARD);
    eval 'sub UICLASS_SECURITY () {0xd;}' unless defined(&UICLASS_SECURITY);
    eval 'sub UICLASS_DIAGNOSTIC () {0xdc;}' unless defined(&UICLASS_DIAGNOSTIC);
    eval 'sub UICLASS_WIRELESS () {0xe0;}' unless defined(&UICLASS_WIRELESS);
    eval 'sub UISUBCLASS_RF () {0x1;}' unless defined(&UISUBCLASS_RF);
    eval 'sub UIPROTO_BLUETOOTH () {0x1;}' unless defined(&UIPROTO_BLUETOOTH);
    eval 'sub UIPROTO_RNDIS () {0x3;}' unless defined(&UIPROTO_RNDIS);
    eval 'sub UICLASS_APPL_SPEC () {0xfe;}' unless defined(&UICLASS_APPL_SPEC);
    eval 'sub UISUBCLASS_FIRMWARE_DOWNLOAD () {1;}' unless defined(&UISUBCLASS_FIRMWARE_DOWNLOAD);
    eval 'sub UISUBCLASS_IRDA () {2;}' unless defined(&UISUBCLASS_IRDA);
    eval 'sub UIPROTO_IRDA () {0;}' unless defined(&UIPROTO_IRDA);
    eval 'sub UICLASS_VENDOR () {0xff;}' unless defined(&UICLASS_VENDOR);
    eval 'sub USB_HUB_MAX_DEPTH () {5;}' unless defined(&USB_HUB_MAX_DEPTH);
    eval 'sub USB_POWER_DOWN_TIME () {200;}' unless defined(&USB_POWER_DOWN_TIME);
    eval 'sub USB_PORT_POWER_DOWN_TIME () {100;}' unless defined(&USB_PORT_POWER_DOWN_TIME);
    if(0) {
	eval 'sub USB_PORT_RESET_DELAY () {10;}' unless defined(&USB_PORT_RESET_DELAY);
	eval 'sub USB_PORT_ROOT_RESET_DELAY () {50;}' unless defined(&USB_PORT_ROOT_RESET_DELAY);
	eval 'sub USB_PORT_RESET_RECOVERY () {10;}' unless defined(&USB_PORT_RESET_RECOVERY);
	eval 'sub USB_PORT_POWERUP_DELAY () {100;}' unless defined(&USB_PORT_POWERUP_DELAY);
	eval 'sub USB_SET_ADDRESS_SETTLE () {2;}' unless defined(&USB_SET_ADDRESS_SETTLE);
	eval 'sub USB_RESUME_DELAY () {(20*5);}' unless defined(&USB_RESUME_DELAY);
	eval 'sub USB_RESUME_WAIT () {10;}' unless defined(&USB_RESUME_WAIT);
	eval 'sub USB_RESUME_RECOVERY () {10;}' unless defined(&USB_RESUME_RECOVERY);
	eval 'sub USB_EXTRA_POWER_UP_TIME () {0;}' unless defined(&USB_EXTRA_POWER_UP_TIME);
    } else {
	eval 'sub USB_PORT_RESET_DELAY () {50;}' unless defined(&USB_PORT_RESET_DELAY);
	eval 'sub USB_PORT_ROOT_RESET_DELAY () {250;}' unless defined(&USB_PORT_ROOT_RESET_DELAY);
	eval 'sub USB_PORT_RESET_RECOVERY () {250;}' unless defined(&USB_PORT_RESET_RECOVERY);
	eval 'sub USB_PORT_POWERUP_DELAY () {300;}' unless defined(&USB_PORT_POWERUP_DELAY);
	eval 'sub USB_SET_ADDRESS_SETTLE () {10;}' unless defined(&USB_SET_ADDRESS_SETTLE);
	eval 'sub USB_RESUME_DELAY () {(50*5);}' unless defined(&USB_RESUME_DELAY);
	eval 'sub USB_RESUME_WAIT () {50;}' unless defined(&USB_RESUME_WAIT);
	eval 'sub USB_RESUME_RECOVERY () {50;}' unless defined(&USB_RESUME_RECOVERY);
	eval 'sub USB_EXTRA_POWER_UP_TIME () {20;}' unless defined(&USB_EXTRA_POWER_UP_TIME);
    }
    eval 'sub USB_MIN_POWER () {100;}' unless defined(&USB_MIN_POWER);
    eval 'sub USB_MIN_POWER_SS () {150;}' unless defined(&USB_MIN_POWER_SS);
    eval 'sub USB_MAX_POWER () {500;}' unless defined(&USB_MAX_POWER);
    eval 'sub USB_MAX_POWER_SS () {900;}' unless defined(&USB_MAX_POWER_SS);
    eval 'sub USB_BUS_RESET_DELAY () {100;}' unless defined(&USB_BUS_RESET_DELAY);
    eval 'sub USB_UNCONFIG_NO () {0;}' unless defined(&USB_UNCONFIG_NO);
    eval 'sub USB_UNCONFIG_INDEX () {(-1);}' unless defined(&USB_UNCONFIG_INDEX);
    eval 'sub UPID_RESERVED () {0xf0;}' unless defined(&UPID_RESERVED);
    eval 'sub UPID_OUT () {0xe1;}' unless defined(&UPID_OUT);
    eval 'sub UPID_ACK () {0xd2;}' unless defined(&UPID_ACK);
    eval 'sub UPID_DATA0 () {0xc3;}' unless defined(&UPID_DATA0);
    eval 'sub UPID_PING () {0xb4;}' unless defined(&UPID_PING);
    eval 'sub UPID_SOF () {0xa5;}' unless defined(&UPID_SOF);
    eval 'sub UPID_NYET () {0x96;}' unless defined(&UPID_NYET);
    eval 'sub UPID_DATA2 () {0x87;}' unless defined(&UPID_DATA2);
    eval 'sub UPID_SPLIT () {0x78;}' unless defined(&UPID_SPLIT);
    eval 'sub UPID_IN () {0x69;}' unless defined(&UPID_IN);
    eval 'sub UPID_NAK () {0x5a;}' unless defined(&UPID_NAK);
    eval 'sub UPID_DATA1 () {0x4b;}' unless defined(&UPID_DATA1);
    eval 'sub UPID_ERR () {0x3c;}' unless defined(&UPID_ERR);
    eval 'sub UPID_PREAMBLE () {0x3c;}' unless defined(&UPID_PREAMBLE);
    eval 'sub UPID_SETUP () {0x2d;}' unless defined(&UPID_SETUP);
    eval 'sub UPID_STALL () {0x1e;}' unless defined(&UPID_STALL);
    eval 'sub UPID_MDATA () {0xf;}' unless defined(&UPID_MDATA);
    eval 'sub USBD_SHORT_XFER_OK () {0x4;}' unless defined(&USBD_SHORT_XFER_OK);
    eval 'sub USB_CURRENT_CONFIG_INDEX () {(-1);}' unless defined(&USB_CURRENT_CONFIG_INDEX);
    eval 'sub USB_CURRENT_ALT_INDEX () {(-1);}' unless defined(&USB_CURRENT_ALT_INDEX);
    eval 'sub USB_MAX_DEVNAMES () {4;}' unless defined(&USB_MAX_DEVNAMES);
    eval 'sub USB_MAX_DEVNAMELEN () {16;}' unless defined(&USB_MAX_DEVNAMELEN);
    eval 'sub USB_SPEED_LOW () {1;}' unless defined(&USB_SPEED_LOW);
    eval 'sub USB_SPEED_FULL () {2;}' unless defined(&USB_SPEED_FULL);
    eval 'sub USB_SPEED_HIGH () {3;}' unless defined(&USB_SPEED_HIGH);
    eval 'sub USB_SPEED_SUPER () {4;}' unless defined(&USB_SPEED_SUPER);
    eval 'sub USB_SPEED_SUPER_PLUS () {5;}' unless defined(&USB_SPEED_SUPER_PLUS);
    eval 'sub USB_IS_SS {
        my($X) = @_;
	    eval q((($X) ==  &USB_SPEED_SUPER || ($X) ==  &USB_SPEED_SUPER_PLUS));
    }' unless defined(&USB_IS_SS);
    eval 'sub USB_PORT_ENABLED () {0xff;}' unless defined(&USB_PORT_ENABLED);
    eval 'sub USB_PORT_SUSPENDED () {0xfe;}' unless defined(&USB_PORT_SUSPENDED);
    eval 'sub USB_PORT_POWERED () {0xfd;}' unless defined(&USB_PORT_POWERED);
    eval 'sub USB_PORT_DISABLED () {0xfc;}' unless defined(&USB_PORT_DISABLED);
    eval 'sub USB_EVENT_CTRLR_ATTACH () {1;}' unless defined(&USB_EVENT_CTRLR_ATTACH);
    eval 'sub USB_EVENT_CTRLR_DETACH () {2;}' unless defined(&USB_EVENT_CTRLR_DETACH);
    eval 'sub USB_EVENT_DEVICE_ATTACH () {3;}' unless defined(&USB_EVENT_DEVICE_ATTACH);
    eval 'sub USB_EVENT_DEVICE_DETACH () {4;}' unless defined(&USB_EVENT_DEVICE_DETACH);
    eval 'sub USB_EVENT_DRIVER_ATTACH () {5;}' unless defined(&USB_EVENT_DRIVER_ATTACH);
    eval 'sub USB_EVENT_DRIVER_DETACH () {6;}' unless defined(&USB_EVENT_DRIVER_DETACH);
    eval 'sub USB_EVENT_IS_ATTACH {
        my($n) = @_;
	    eval q((($n) ==  &USB_EVENT_CTRLR_ATTACH || ($n) ==  &USB_EVENT_DEVICE_ATTACH || ($n) ==  &USB_EVENT_DRIVER_ATTACH));
    }' unless defined(&USB_EVENT_IS_ATTACH);
    eval 'sub USB_EVENT_IS_DETACH {
        my($n) = @_;
	    eval q((($n) ==  &USB_EVENT_CTRLR_DETACH || ($n) ==  &USB_EVENT_DEVICE_DETACH || ($n) ==  &USB_EVENT_DRIVER_DETACH));
    }' unless defined(&USB_EVENT_IS_DETACH);
    eval 'sub USB_REQUEST () { &_IOWR(ord(\'U\'), 1, \'struct usb_ctl_request\');}' unless defined(&USB_REQUEST);
    eval 'sub USB_SETDEBUG () { &_IOW (ord(\'U\'), 2, \'int\');}' unless defined(&USB_SETDEBUG);
    eval 'sub USB_DISCOVER () { &_IO (ord(\'U\'), 3);}' unless defined(&USB_DISCOVER);
    eval 'sub USB_DEVICEINFO () { &_IOWR(ord(\'U\'), 4, \'struct usb_device_info\');}' unless defined(&USB_DEVICEINFO);
    eval 'sub USB_DEVICEINFO_OLD () { &_IOWR(ord(\'U\'), 4, \'struct usb_device_info_old\');}' unless defined(&USB_DEVICEINFO_OLD);
    eval 'sub USB_DEVICESTATS () { &_IOR (ord(\'U\'), 5, \'struct usb_device_stats\');}' unless defined(&USB_DEVICESTATS);
    eval 'sub USB_GET_REPORT_DESC () { &_IOR (ord(\'U\'), 21, \'struct usb_ctl_report_desc\');}' unless defined(&USB_GET_REPORT_DESC);
    eval 'sub USB_SET_IMMED () { &_IOW (ord(\'U\'), 22, \'int\');}' unless defined(&USB_SET_IMMED);
    eval 'sub USB_GET_REPORT () { &_IOWR(ord(\'U\'), 23, \'struct usb_ctl_report\');}' unless defined(&USB_GET_REPORT);
    eval 'sub USB_SET_REPORT () { &_IOW (ord(\'U\'), 24, \'struct usb_ctl_report\');}' unless defined(&USB_SET_REPORT);
    eval 'sub USB_GET_REPORT_ID () { &_IOR (ord(\'U\'), 25, \'int\');}' unless defined(&USB_GET_REPORT_ID);
    eval 'sub USB_GET_CONFIG () { &_IOR (ord(\'U\'), 100, \'int\');}' unless defined(&USB_GET_CONFIG);
    eval 'sub USB_SET_CONFIG () { &_IOW (ord(\'U\'), 101, \'int\');}' unless defined(&USB_SET_CONFIG);
    eval 'sub USB_GET_ALTINTERFACE () { &_IOWR(ord(\'U\'), 102, \'struct usb_alt_interface\');}' unless defined(&USB_GET_ALTINTERFACE);
    eval 'sub USB_SET_ALTINTERFACE () { &_IOWR(ord(\'U\'), 103, \'struct usb_alt_interface\');}' unless defined(&USB_SET_ALTINTERFACE);
    eval 'sub USB_GET_NO_ALT () { &_IOWR(ord(\'U\'), 104, \'struct usb_alt_interface\');}' unless defined(&USB_GET_NO_ALT);
    eval 'sub USB_GET_DEVICE_DESC () { &_IOR (ord(\'U\'), 105,  &usb_device_descriptor_t);}' unless defined(&USB_GET_DEVICE_DESC);
    eval 'sub USB_GET_CONFIG_DESC () { &_IOWR(ord(\'U\'), 106, \'struct usb_config_desc\');}' unless defined(&USB_GET_CONFIG_DESC);
    eval 'sub USB_GET_INTERFACE_DESC () { &_IOWR(ord(\'U\'), 107, \'struct usb_interface_desc\');}' unless defined(&USB_GET_INTERFACE_DESC);
    eval 'sub USB_GET_ENDPOINT_DESC () { &_IOWR(ord(\'U\'), 108, \'struct usb_endpoint_desc\');}' unless defined(&USB_GET_ENDPOINT_DESC);
    eval 'sub USB_GET_FULL_DESC () { &_IOWR(ord(\'U\'), 109, \'struct usb_full_desc\');}' unless defined(&USB_GET_FULL_DESC);
    eval 'sub USB_GET_STRING_DESC () { &_IOWR(ord(\'U\'), 110, \'struct usb_string_desc\');}' unless defined(&USB_GET_STRING_DESC);
    eval 'sub USB_DO_REQUEST () { &_IOWR(ord(\'U\'), 111, \'struct usb_ctl_request\');}' unless defined(&USB_DO_REQUEST);
    eval 'sub USB_GET_DEVICEINFO () { &_IOR (ord(\'U\'), 112, \'struct usb_device_info\');}' unless defined(&USB_GET_DEVICEINFO);
    eval 'sub USB_GET_DEVICEINFO_OLD () { &_IOR (ord(\'U\'), 112, \'struct usb_device_info_old\');}' unless defined(&USB_GET_DEVICEINFO_OLD);
    eval 'sub USB_SET_SHORT_XFER () { &_IOW (ord(\'U\'), 113, \'int\');}' unless defined(&USB_SET_SHORT_XFER);
    eval 'sub USB_SET_TIMEOUT () { &_IOW (ord(\'U\'), 114, \'int\');}' unless defined(&USB_SET_TIMEOUT);
    eval 'sub USB_SET_BULK_RA () { &_IOW (ord(\'U\'), 115, \'int\');}' unless defined(&USB_SET_BULK_RA);
    eval 'sub USB_SET_BULK_WB () { &_IOW (ord(\'U\'), 116, \'int\');}' unless defined(&USB_SET_BULK_WB);
    eval 'sub USB_SET_BULK_RA_OPT () { &_IOW (ord(\'U\'), 117, \'struct usb_bulk_ra_wb_opt\');}' unless defined(&USB_SET_BULK_RA_OPT);
    eval 'sub USB_SET_BULK_WB_OPT () { &_IOW (ord(\'U\'), 118, \'struct usb_bulk_ra_wb_opt\');}' unless defined(&USB_SET_BULK_WB_OPT);
    eval 'sub USB_GET_CM_OVER_DATA () { &_IOR (ord(\'U\'), 130, \'int\');}' unless defined(&USB_GET_CM_OVER_DATA);
    eval 'sub USB_SET_CM_OVER_DATA () { &_IOW (ord(\'U\'), 131, \'int\');}' unless defined(&USB_SET_CM_OVER_DATA);
}
1;
