import { HintStep, IntroStep } from "./core/steps";
import { Options } from "./option";
type introBeforeChangeCallback = (this: IntroJs, targetElement: HTMLElement, currentStep: number, direction: "backward" | "forward") => Promise<boolean> | boolean;
type introChangeCallback = (this: IntroJs, targetElement: HTMLElement) => void | Promise<void>;
type introAfterChangeCallback = (this: IntroJs, targetElement: HTMLElement) => void | Promise<void>;
type introCompleteCallback = (this: IntroJs, currentStep: number, reason: "skip" | "end" | "done") => void | Promise<void>;
type introStartCallback = (this: IntroJs, targetElement: HTMLElement) => void | Promise<void>;
type introExitCallback = (this: IntroJs) => void | Promise<void>;
type introSkipCallback = (this: IntroJs, currentStep: number) => void | Promise<void>;
type introBeforeExitCallback = (this: IntroJs, targetElement: HTMLElement) => boolean | Promise<boolean>;
type hintsAddedCallback = (this: IntroJs) => void | Promise<void>;
type hintClickCallback = (this: IntroJs, hintElement: HTMLElement, item: HintStep, stepId: number) => void | Promise<void>;
type hintCloseCallback = (this: IntroJs, stepId: number) => void | Promise<void>;
export declare class IntroJs {
    _currentStep: number;
    _currentStepNumber: number | undefined;
    _direction: "forward" | "backward";
    _targetElement: HTMLElement;
    _introItems: IntroStep[];
    _hintItems: HintStep[];
    _options: Options;
    _introBeforeChangeCallback?: introBeforeChangeCallback;
    _introChangeCallback?: introChangeCallback;
    _introAfterChangeCallback?: introAfterChangeCallback;
    _introCompleteCallback?: introCompleteCallback;
    _introStartCallback?: introStartCallback;
    _introExitCallback?: introExitCallback;
    _introSkipCallback?: introSkipCallback;
    _introBeforeExitCallback?: introBeforeExitCallback;
    _hintsAddedCallback?: hintsAddedCallback;
    _hintClickCallback?: hintClickCallback;
    _hintCloseCallback?: hintCloseCallback;
    _lastShowElementTimer: number;
    _hintsAutoRefreshFunction: (...args: any[]) => void;
    constructor(targetElement: HTMLElement);
    isActive(): boolean;
    clone(): IntroJs;
    setOption<K extends keyof Options>(key: K, value: Options[K]): this;
    setOptions(partialOptions: Partial<Options>): this;
    start(): Promise<this>;
    goToStep(step: number): Promise<this>;
    addStep(step: Partial<IntroStep>): this;
    addSteps(steps: Partial<IntroStep>[]): this;
    goToStepNumber(step: number): Promise<this>;
    nextStep(): Promise<this>;
    previousStep(): Promise<this>;
    currentStep(): number;
    exit(force: boolean): Promise<this>;
    refresh(refreshSteps?: boolean): this;
    setDontShowAgain(dontShowAgain: boolean): this;
    onbeforechange(providedCallback: introBeforeChangeCallback): this;
    onchange(providedCallback: introChangeCallback): this;
    onafterchange(providedCallback: introAfterChangeCallback): this;
    oncomplete(providedCallback: introCompleteCallback): this;
    onhintsadded(providedCallback: hintsAddedCallback): this;
    onhintclick(providedCallback: hintClickCallback): this;
    onhintclose(providedCallback: hintCloseCallback): this;
    onstart(providedCallback: introStartCallback): this;
    onexit(providedCallback: introExitCallback): this;
    onskip(providedCallback: introSkipCallback): this;
    onbeforeexit(providedCallback: introBeforeExitCallback): this;
    addHints(): Promise<this>;
    hideHint(stepId: number): Promise<this>;
    hideHints(): Promise<this>;
    showHint(stepId: number): this;
    showHints(): Promise<this>;
    removeHints(): this;
    removeHint(stepId: number): this;
    showHintDialog(stepId: number): Promise<this>;
}
export {};
