<?php
SOY2::import("domain.admin.Administrator");

class IndexPage extends CMSWebPageBase{

	function IndexPage(){
    	if(!UserInfoUtil::isDefaultUser()){
    		$this->jump("Administrator.Detail");
    	}

		WebPage::WebPage();

		$this->outputMessage();

		$entities = $this->getLimitedAdministratorList();

		//管理者がいないときはリストを隠して、メッセージを表示
		$this->createAdd("main_table","HTMLModel",array(
			"visible"=>count($entities)>0
		));
		$this->createAdd("table_title","HTMLLabel",array(
			"text"=>CMSMessageManager::get("ADMIN_ADMIN_ID"),
			"visible"=>count($entities)>0
		));
		$this->createAdd("list","AdministratorList",array(
			"list"    => $entities,
			"sites"   => $this->getSiteLists(),
			"visible" => count($entities)>0
		));
		$this->createAdd("no_administrator","HTMLLabel",array(
			"text"=>CMSMessageManager::get("ADMIN_MESSAGE_NO_USER"),
			"visible"=>count($entities)==0
		));

		$this->createAdd("addAdministrator","HTMLLink",array(
			"link"=>SOY2PageController::createLink("Administrator.Create"),
			"visible"=>UserInfoUtil::isDefaultUser()
		));
		$this->createAdd("changepassword","HTMLLink",array("link"=>SOY2PageController::createLink("Administrator.ChangePassword")));

	}

	function getSiteLists(){
		$SiteLogic = SOY2Logic::createInstance("logic.admin.Site.SiteLogic");
		return $SiteLogic->getSiteList();
	}

	/**
	 * 現在のユーザIDからログイン可能なサイトオブジェクトのリストを取得する
	 */
	function getLoginableSiteList(){
		$SiteLogic = SOY2Logic::createInstance("logic.admin.Site.SiteLogic");
		return $SiteLogic->getSiteByUserId(UserInfoUtil::getUserId());
	}
	/**
	 * 現在のユーザIDからログイン可能なサイトのIDのリストを取得する
	 */
	function getLoginableSiteIds(){
		$ids = array();
		$list = $this->getLoginableSiteList();
		foreach($list as $key => $site){
			$ids[] = $site->getId();
		}
		return $ids;
	}

	/**
	 * 管理者一覧を取得
	 * Administrator.ListActionを呼び出して、管理者オブジェクトのリストを返す
	 */
	function getAdministratorList(){
		$AdministratorLogic = SOY2Logic::createInstance("logic.admin.Administrator.AdministratorLogic");
		return $AdministratorLogic->getAdministratorList();
	}

	/**
	 * 自分がログイン可能なサイトにログイン可能な管理者のリスト
	 */
	function getLimitedAdministratorList(){
		if(UserInfoUtil::isDefaultUser()){
			return $this->getAdministratorList();
		}else{
			$list = array();
			$loginableSiteIds = $this->getLoginableSiteIds();
			$administratorList = $this->getAdministratorList();
			foreach($administratorList as $administrator){
				foreach($administrator->sites as $key => $siteroll){
					if(! in_array($siteroll->getSiteId(), $loginableSiteIds) ){
						unset($administrator->sites[$key]);
					}
				}
				if( count($administrator->sites) >0 ){
					$list[] = $administrator;
				}
			}
			return $list;
		}
	}

    /**
     * メッセージ出力
     */
    function outputMessage(){
    	$messages = CMSMessageManager::getMessages();
    	$this->createAdd("message","HTMLLabel",array(
    		"text" => implode("\n",$messages),
    		"visible" => !empty($messages)
    	));
    }

}

class AdministratorList extends HTMLList{

	private $sites = null;

	protected function populateItem($entity){

		$this->createAdd("userId","HTMLLabel",array(
			"text" => $entity->getUserId()
		));

		$this->add("userName",SOY2HTMLFactory::createInstance("HTMLLabel",array(
			"text" => $entity->getName()
		)));

		$this->add("detail_link",SOY2HTMLFactory::createInstance("HTMLLink",array(
			"link" => SOY2PageController::createLink("Administrator.SiteRole.".$entity->getId()),
			"visible"=> !$entity->getIsDefaultUser(),
			"text"=>(UserInfoUtil::isDefaultUser()) ? CMSMessageManager::get("ADMIN_ROLE_SETTING") : CMSMessageManager::get("ADMIN_DISPLAY_ROLES")
		)));

		$this->add("update_link",SOY2HTMLFactory::createInstance("HTMLLink",array(
			"link" => SOY2PageController::createLink("Administrator.Detail.".$entity->getId()),
			"text"=>(UserInfoUtil::isDefaultUser() || $entity->getId() == UserInfoUtil::getUserId()) ? CMSMessageManager::get("ADMIN_DETAIL_EDIT") : CMSMessageManager::get("ADMIN_DISPLAY_DETAILS")
		)));

		$this->createAdd("remove_link","HTMLLink",array(
			"link" => SOY2PageController::createLink("Administrator.Remove.".$entity->getId()),
			"visible"=> UserInfoUtil::isDefaultUser() && !$entity->getIsDefaultUser(),
		));


		$siteName = array();

		if($entity->getIsDefaultUser()){
			$siteName[] = CMSMessageManager::get("ADMIN_SUPER_USER");
		}else{
			foreach($entity->sites as $managed){
				if(isset($this->sites[$managed->getSiteId()])){
					$siteName[] = htmlspecialchars($this->sites[$managed->getSiteId()]->getSiteName(),ENT_QUOTES,"UTF-8");
					            //."<br/>". htmlspecialchars(" => ".$managed->getSiteRoleText(),ENT_QUOTES);
				}
			}
		}

		$this->createAdd("managingSite","HTMLLabel",array(
			"html"=>implode("<br />",$siteName)
		));



	}
	function setSites($sites){
		$this->sites = $sites;
	}

	function getSiteRoleText($siteRole){
		$list = SiteRole::getSiteRoleLists();
		$text = $list[(int)$siteRole];
	}

}

?>