from collections.abc import Generator, Iterable, Sequence
from importlib.machinery import ModuleSpec
from types import ModuleType

class VendorImporter:
    root_name: str
    vendored_names: set[str]
    vendor_pkg: str
    def __init__(self, root_name: str, vendored_names: Iterable[str] = (), vendor_pkg: str | None = None) -> None: ...
    @property
    def search_path(self) -> Generator[str, None, None]: ...
    def load_module(self, fullname: str) -> ModuleType: ...
    def create_module(self, spec: ModuleSpec) -> ModuleType: ...
    def exec_module(self, module: ModuleType) -> None: ...
    def find_spec(
        self, fullname: str, path: Sequence[str] | None = None, target: ModuleType | None = None
    ) -> ModuleSpec | None: ...
    def install(self) -> None: ...

names: tuple[str, ...]
