package ONVIF::PTZ::Types::VideoSourceConfiguration;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(ONVIF::PTZ::Types::ConfigurationEntity);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Name_of :ATTR(:get<Name>);
my %UseCount_of :ATTR(:get<UseCount>);
my %SourceToken_of :ATTR(:get<SourceToken>);
my %Bounds_of :ATTR(:get<Bounds>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        Name
        UseCount
        SourceToken
        Bounds
        Extension

    ) ],
    {
        'Name' => \%Name_of,
        'UseCount' => \%UseCount_of,
        'SourceToken' => \%SourceToken_of,
        'Bounds' => \%Bounds_of,
        'Extension' => \%Extension_of,
    },
    {
        'Name' => 'ONVIF::PTZ::Types::Name',
        'UseCount' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'SourceToken' => 'ONVIF::PTZ::Types::ReferenceToken',
        'Bounds' => 'ONVIF::PTZ::Types::IntRectangle',
        'Extension' => 'ONVIF::PTZ::Types::VideoSourceConfigurationExtension',
    },
    {

        'Name' => 'Name',
        'UseCount' => 'UseCount',
        'SourceToken' => 'SourceToken',
        'Bounds' => 'Bounds',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::PTZ::Types::VideoSourceConfiguration

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
VideoSourceConfiguration from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * SourceToken


=item * Bounds


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::PTZ::Types::VideoSourceConfiguration
   SourceToken => $some_value, # ReferenceToken
   Bounds => ,
   Extension =>  { # ONVIF::PTZ::Types::VideoSourceConfigurationExtension
     Rotate =>  { # ONVIF::PTZ::Types::Rotate
       Mode => $some_value, # RotateMode
       Degree =>  $some_value, # int
       Extension =>  { # ONVIF::PTZ::Types::RotateExtension
       },
     },
     Extension =>  { # ONVIF::PTZ::Types::VideoSourceConfigurationExtension2
     },
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

