/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.client.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.igoweb.igoweb.client.Client;
import org.igoweb.igoweb.client.FriendsGroup;
import org.igoweb.igoweb.shared.User;
import org.igoweb.util.swing.AList;
import org.igoweb.util.swing.GuiUtil;
import org.igoweb.util.xml.HtmlUtil;

public class UserRenderer
extends JComponent
implements ListCellRenderer<User> {
    private final Font stdFont = UIManager.getFont("Label.font");
    private User currentUser = null;
    private JComponent imageUpdateWidget;
    private final int stdH = UIManager.getInt("org.igoweb.fontH");
    private int stdW = UserRenderer.getMinimumWidth(true);
    public static final int ICON_SR_ADMIN = 0;
    public static final int ICON_JR_ADMIN = 1;
    public static final int ICON_TOURN_WINNER = 2;
    public static final int ICON_TOURN_RUNNER_UP = 3;
    public static final int ICON_ROBOT = 4;
    public static final int ICON_CENSORED = 5;
    public static final int ICON_SUBSCRIBED = 6;
    public static final int ICON_FAN = 7;
    public static final int ICON_LOW_BANDWIDTH = 8;
    public static final int ICON_ADMIN_TRACK = 9;
    public static final int ICON_MEIJIN = 10;
    public static final int ICON_COUNT = 11;
    public static final User BUDDY_BAR = new User(" ");
    public static final User NULL_USER = new User(" ");
    private boolean showHelpful;
    private static final int SMALLEST_PRERENDERED_ICON = 12;
    private static Image iconImage = null;
    private final Client client;
    private FriendsGroup friendsGroup;
    private String notes;

    public UserRenderer(Client client) {
        this(client, null);
    }

    public UserRenderer(Client client, FriendsGroup friendsGroup) {
        this.client = client;
        this.friendsGroup = friendsGroup;
    }

    public void setShowHelpful(boolean showHelpful) {
        this.showHelpful = showHelpful;
        this.stdW = UserRenderer.getMinimumWidth(!showHelpful, this.stdH);
    }

    @Override
    public Component getListCellRendererComponent(JList list, User user, int index, boolean isSelected, boolean cellHasFocus) {
        this.currentUser = user;
        JComponent jComponent = this.imageUpdateWidget = list == null ? this : list;
        if (this.showHelpful) {
            this.setBackground(UIManager.getColor(isSelected ? "ComboBox.selectionBackground" : "org.igoweb.stdBg"));
        } else {
            this.setBackground(UIManager.getColor(this.currentUser != BUDDY_BAR && this.currentUser != NULL_USER && ((AList.InnerList)list).mouseUnder() == this.currentUser ? "org.igoweb.selTextBg" : (list.isEnabled() ? "org.igoweb.inputBg" : "org.igoweb.outputBg")));
        }
        this.notes = this.friendsGroup == null || this.currentUser == null ? null : this.friendsGroup.getNotes(this.currentUser);
        this.setEnabled(list == null || list.isEnabled());
        return this;
    }

    public static int getMinimumWidth(boolean includeIcon) {
        return UserRenderer.getMinimumWidth(includeIcon, UIManager.getInt("org.igoweb.fontH"));
    }

    public static int getMinimumWidth(boolean includeIcon, int stdH) {
        return (includeIcon ? 18 * stdH + 3 : 16 * stdH + 1) / 2;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.stdW, this.currentUser == BUDDY_BAR ? 5 : this.stdH);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public void paint(Graphics g) {
        User me;
        if (this.currentUser == null || this.currentUser == NULL_USER) {
            return;
        }
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.currentUser == BUDDY_BAR) {
            g.setColor(Color.black);
            g.drawLine(0, 2, this.getWidth(), 2);
            return;
        }
        int textOffset = 2;
        g.setFont(this.stdFont);
        this.drawIcon(this.currentUser, (Graphics2D)g, this.stdH);
        textOffset += this.stdH;
        if (!this.showHelpful && this.currentUser.isSleeping()) {
            g.setColor(UIManager.getColor("org.igoweb.stdBg").darker());
        } else {
            g.setColor(UIManager.getColor("Label.foreground"));
        }
        String text = this.currentUser.getNameAndRank();
        if (!(!this.showHelpful || this.currentUser.isHelpful() || (me = this.client.getMe()).isRankWanted() && this.currentUser.getRank() > this.client.getMe().getRank())) {
            text = text + '~';
        }
        int ascent = g.getFontMetrics().getAscent();
        g.drawString(text, textOffset, ascent);
        if (this.notes != null) {
            g.drawString(this.notes, textOffset + this.stdH * 10, ascent);
        }
    }

    private void drawIcon(User who, Graphics g, int size) {
        int rawSize;
        boolean isSubscribed = who.isSubscribed();
        int iconNum = -1;
        if (who.isRobot()) {
            iconNum = 4;
        } else if (who.isMeijin()) {
            iconNum = 10;
        } else if (who.isTournWinner()) {
            iconNum = 2;
        } else if (who.isTournRunnerUp()) {
            iconNum = 3;
        }
        switch (who.getAuthLevel()) {
            case 4: 
            case 5: {
                iconNum = 0;
                isSubscribed = false;
                break;
            }
            case 3: {
                iconNum = 1;
                isSubscribed = false;
            }
        }
        if (who.isLowBandwidth()) {
            iconNum = 8;
        }
        boolean isCensored = this.client.getFriendsGroup(1).contains(who);
        boolean isFan = this.client.getFriendsGroup(2).contains(who);
        boolean isAdminWatch = this.client.getFriendsGroup(3).contains(who);
        if (!(iconNum != -1 || isCensored || isFan || isSubscribed || isAdminWatch)) {
            return;
        }
        if (iconImage == null) {
            iconImage = GuiUtil.loadImage("org/igoweb/igoweb/client/swing/userIcons.png");
        }
        if ((rawSize = iconImage.getWidth(this.imageUpdateWidget)) <= 0) {
            return;
        }
        rawSize /= 11;
        int yOffset = 0;
        if (size >= 12) {
            yOffset = size * (size - 1) / 2 + rawSize - 66;
            int rawHeight = iconImage.getHeight(this.imageUpdateWidget);
            if (rawHeight <= 0) {
                return;
            }
            if (yOffset + size > rawHeight) {
                yOffset = 0;
            }
        }
        g = g.create(1, 0, size, size);
        if (yOffset == 0) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            if (isSubscribed) {
                g2d.drawImage(iconImage, 0, 0, size, size, rawSize * 6, 0, rawSize * 7, rawSize, this.imageUpdateWidget);
            }
            if (iconNum >= 0) {
                g2d.drawImage(iconImage, 0, 0, size, size, rawSize * iconNum, 0, rawSize * (iconNum + 1), rawSize, this.imageUpdateWidget);
            }
            if (isCensored) {
                g2d.drawImage(iconImage, 0, 0, size, size, rawSize * 5, 0, rawSize * 6, rawSize, this.imageUpdateWidget);
            }
            if (isFan) {
                g2d.drawImage(iconImage, 0, 0, size, size, rawSize * 7, 0, rawSize * 8, rawSize, this.imageUpdateWidget);
            }
            if (isAdminWatch) {
                g2d.drawImage(iconImage, 0, 0, size, size, rawSize * 9, 0, rawSize * 10, rawSize, this.imageUpdateWidget);
            }
        } else {
            if (isSubscribed) {
                g.drawImage(iconImage, -6 * size, -yOffset, this.imageUpdateWidget);
            }
            if (iconNum >= 0) {
                g.drawImage(iconImage, -iconNum * size, -yOffset, this.imageUpdateWidget);
            }
            if (isCensored) {
                g.drawImage(iconImage, -5 * size, -yOffset, this.imageUpdateWidget);
            }
            if (isFan) {
                g.drawImage(iconImage, -7 * size, -yOffset, this.imageUpdateWidget);
            }
            if (isAdminWatch) {
                g.drawImage(iconImage, -9 * size, -yOffset, this.imageUpdateWidget);
            }
        }
    }

    public void setUser(User user) {
        this.getListCellRendererComponent((JList)null, user, -1, false, false);
    }

    public User getUser() {
        return this.currentUser;
    }

    @Override
    public String getToolTipText() {
        StringBuilder sb = null;
        if (this.currentUser != null) {
            for (int i = 0; i < 4; ++i) {
                String fgNotes = this.client.getFriendsGroup(i).getNotes(this.currentUser);
                if (fgNotes == null || fgNotes.length() <= 0) continue;
                if (sb == null) {
                    sb = new StringBuilder(fgNotes);
                    continue;
                }
                sb.append('\n').append(fgNotes);
            }
        }
        return sb == null ? super.getToolTipText() : HtmlUtil.textToHtml(sb.toString(), false, true);
    }
}

