<?php
/**
 * @table ASPUser
 */
class ASPUser {

	/**
	 * @id
	 */
	private $id;
    
    /**
     * @column first_name 
     */
	private $firstName;
    
    /**
     * @column last_name
     */
    private $lastName;
    
    /**
     * @column first_name_reading
     */
    private $firstNameReading;
    
    /**
     * @column last_name_reading
     */
    private $lastNameReading;
    
    /**
     * @column birth_date
     */
    private $birthDate;

	private $email;
	private $password;
	
	/**
	 * @column nickname
	 */
	private $nickName;
	
	/**
	 * @column last_login_date
	 */
	private $lastLoginDate;
    

	function getId() {
		return $this->id;
	}
	function setId($id) {
		$this->id = $id;
	}
	function getFirstName() {
		return $this->firstName;
	}
	function setFirstName($firstName) {
		$this->firstName = $firstName;
	}
	function getLastName() {
		return $this->lastName;
	}
	function setLastName($lastName) {
		$this->lastName = $lastName;
	}
	function getFirstNameReading() {
		return $this->firstNameReading;
	}
	function setFirstNameReading($firstNameReading) {
		$this->firstNameReading = $firstNameReading;
	}
	function getLastNameReading() {
		return $this->lastNameReading;
	}
	function setLastNameReading($lastNameReading) {
		$this->lastNameReading = $lastNameReading;
	}
	function getBirthDate() {
		return $this->birthDate;
	}
	function setBirthDate($birthDate) {
		if(is_numeric($birthDate)){
			$birthDate = date("Y-m-d",$birthDate);
		}
		$this->birthDate = $birthDate;
	}
	function getEmail() {
		return $this->email;
	}
	function setEmail($email) {
		$this->email = $email;
	}
	function getPassword() {
		return $this->password;
	}
	function setPassword($password) {
		$this->password = $password;
	}
	function getLastLoginDate() {
		return $this->lastLoginDate;
	}
	function setLastLoginDate($lastLoginDate) {
		$this->lastLoginDate = $lastLoginDate;
	}

	function getNickName() {
		return $this->nickName;
	}
	function setNickName($nickName) {
		$this->nickName = $nickName;
	}
	
	function getIsEnableWithdraw(){
		$denyUserEmailArr = array(
    		"demo@soycms.net"
    	);
    	
    	return !in_array($this->email,$denyUserEmailArr);
	}
}
?>