/*
 * Decompiled with CFR 0.152.
 */
package org.usadellab.trimmomatic;

import java.io.PrintStream;
import java.text.DecimalFormat;
import org.usadellab.trimmomatic.fastq.FastqRecord;

public class TrimStats {
    private static DecimalFormat formatter = new DecimalFormat("0.00");
    private long readsInput = 0L;
    private long readsSurvivingBoth = 0L;
    private long readsSurvivingForward = 0L;
    private long readsSurvivingReverse = 0L;

    public void merge(TrimStats other) {
        this.readsInput += other.readsInput;
        this.readsSurvivingBoth += other.readsSurvivingBoth;
        this.readsSurvivingForward += other.readsSurvivingForward;
        this.readsSurvivingReverse += other.readsSurvivingReverse;
    }

    public void logPair(FastqRecord[] originalRecs, FastqRecord[] recs) {
        if (originalRecs.length == 1) {
            if (originalRecs[0] != null) {
                ++this.readsInput;
                if (recs[0] != null) {
                    ++this.readsSurvivingForward;
                }
            }
        } else if (originalRecs[0] != null && originalRecs[1] != null) {
            ++this.readsInput;
            if (recs[0] != null) {
                if (recs[1] != null) {
                    ++this.readsSurvivingBoth;
                } else {
                    ++this.readsSurvivingForward;
                }
            } else if (recs[1] != null) {
                ++this.readsSurvivingReverse;
            }
        }
    }

    public String processStatsSE(PrintStream statsSummaryStream) {
        long dropped = this.readsInput - this.readsSurvivingForward;
        double survivingForwardPercent = 100.0 * (double)this.readsSurvivingForward / (double)this.readsInput;
        double droppedPercent = 100.0 * (double)dropped / (double)this.readsInput;
        if (statsSummaryStream != null) {
            statsSummaryStream.println("Input Reads: " + this.readsInput);
            statsSummaryStream.println("Surviving Reads: " + this.readsSurvivingForward);
            statsSummaryStream.println("Surviving Read Percent: " + formatter.format(survivingForwardPercent));
            statsSummaryStream.println("Dropped Reads: " + dropped);
            statsSummaryStream.println("Dropped Read Percent: " + formatter.format(droppedPercent));
        }
        return "Input Reads: " + this.readsInput + " Surviving: " + this.readsSurvivingForward + " (" + formatter.format(survivingForwardPercent) + "%) Dropped: " + dropped + " (" + formatter.format(droppedPercent) + "%)";
    }

    public String processStatsPE(PrintStream statsSummaryStream) {
        long dropped = this.readsInput - this.readsSurvivingBoth - this.readsSurvivingForward - this.readsSurvivingReverse;
        double survivingBothPercent = 100.0 * (double)this.readsSurvivingBoth / (double)this.readsInput;
        double survivingForwardPercent = 100.0 * (double)this.readsSurvivingForward / (double)this.readsInput;
        double survivingReversePercent = 100.0 * (double)this.readsSurvivingReverse / (double)this.readsInput;
        double droppedPercent = 100.0 * (double)dropped / (double)this.readsInput;
        if (statsSummaryStream != null) {
            statsSummaryStream.println("Input Read Pairs: " + this.readsInput);
            statsSummaryStream.println("Both Surviving Reads: " + this.readsSurvivingBoth);
            statsSummaryStream.println("Both Surviving Read Percent: " + formatter.format(survivingBothPercent));
            statsSummaryStream.println("Forward Only Surviving Reads: " + this.readsSurvivingForward);
            statsSummaryStream.println("Forward Only Surviving Read Percent: " + formatter.format(survivingForwardPercent));
            statsSummaryStream.println("Reverse Only Surviving Reads: " + this.readsSurvivingReverse);
            statsSummaryStream.println("Reverse Only Surviving Read Percent: " + formatter.format(survivingReversePercent));
            statsSummaryStream.println("Dropped Reads: " + dropped);
            statsSummaryStream.println("Dropped Read Percent: " + formatter.format(droppedPercent));
        }
        return "Input Read Pairs: " + this.readsInput + " Both Surviving: " + this.readsSurvivingBoth + " (" + formatter.format(survivingBothPercent) + "%) Forward Only Surviving: " + this.readsSurvivingForward + " (" + formatter.format(survivingForwardPercent) + "%) Reverse Only Surviving: " + this.readsSurvivingReverse + " (" + formatter.format(survivingReversePercent) + "%) Dropped: " + dropped + " (" + formatter.format(droppedPercent) + "%)";
    }
}

