#!/bin/sh
#
# Trampoline script for running bracket jobs from cron.
# Sets up PATH, ulimit, and logging.
#

job="$1"

PATH=/usr/pkg/bin:/usr/pkg/bin:/usr/local/bin:/usr/sbin:$PATH; export PATH

. ./bracket.conf

exec >$logdir/$job/`date '+%Y%m%d-%H%M'`.log 2>&1

# If you need to raise process limits, this is a good place to do it.
# As of 9.0/amd64, the default limit on the number of processes is
# 1024, which has been sufficient so far.

#ulimit -p 1024

bracket "$job"
