#!/usr/bin/python

# Update the file events.dat in the HTML directory, which contains
# a list of timestamps of "eventful" commits, i.e., ones where there
# were siginificant changes in the build status, build log size,
# test results, etc.
#
# Other bracket installations (or other auto-test systems) may use
# this list a a hint when choosing which CVS dates to check out for
# testing.

from bracket import *
from utils import write_file, adjacent_pairs

def update_event_list():
    build_dates = [ts for ts in existing_build_dates_at_commits()
        if get_cached_status_if_any(ts, 'build_status') is not None]

    events = []
    for tsp in adjacent_pairs(build_dates):
        if any_status_changed(tsp):
            ncommits = ts2cno(tsp[1]) - ts2cno(tsp[0])
            if ncommits == 1:
                events.append(tsp[1])

    write_file(os.path.join(config['htmldir'], 'events.dat'),
               "".join([str(e) + "\n" for e in events]), 't')

def main():
    use_current_repository()
    update_event_list()
