#!/usr/bin/python
#
# Find when "fatal error" started appearing in the build log
# (PR misc/52997)
#

from bracket import *

use_current_repository()

def f(ts):
    fn = os.path.join(test_dir(ts), 'build.log')
    f = open(fn, 'r')
    for line in f:
        m = re.search(r'dtrace.h.*fatal error', line)
        if m:
            return False
    return True

#begin = rcs2ts('2013.08.04.17.35.10')
#end   = rcs2ts('2018.02.09.04.20.38')
#find_failure(begin, end,
#             TestOp(f,
#                    [build_op],
#                    name = 'fatal_error'),
#             confirm = True)

begin = rcs2ts('2018.02.09.04.20.38')
end   = rcs2ts('2019.04.03.18.05.55')
find_fix(begin, end,
         TestOp(f,
                [build_op],
                name = 'fatal_error'),
         confirm = True)
