/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import org.igoweb.resource.ResEntry;
import org.igoweb.resource.Resource;
import org.igoweb.resource.SortedProp;

public class PkgRes {
    public static final String PROPS_HEADER = "$Id$";
    private SortedProp props = new SortedProp();
    private HashSet<String> keys = new HashSet();
    private ArrayList<PkgRes> children = new ArrayList();
    private Resource res;
    private int totalSize;

    public PkgRes(Resource res) {
        this(res, true, new HashSet<String>());
    }

    public PkgRes(Resource res, Collection<String> skipPkgs) {
        this(res, true, new HashSet<String>(skipPkgs));
    }

    private PkgRes(Resource res, boolean isTop, HashSet<String> currentPkgs) {
        int i;
        this.res = res;
        Resource[] resChildren = res.getChildren();
        ResEntry[] resources = res.getContents();
        currentPkgs.add(res.getClass().getName());
        String pkgName = res.getKeyPrefix();
        for (i = 0; i < resources.length; ++i) {
            this.keys.add(pkgName + ':' + resources[i].key);
        }
        for (i = 0; i < resChildren.length; ++i) {
            if (currentPkgs.contains(resChildren[i].getClass().getName())) continue;
            this.children.add(new PkgRes(resChildren[i], false, currentPkgs));
        }
    }

    public Collection<String> getPackagesUsed() {
        return this.getPackagesUsed(new ArrayList<String>());
    }

    private Collection<String> getPackagesUsed(Collection<String> coll) {
        coll.add(this.res.getClass().getName());
        for (PkgRes pr : this.children) {
            pr.getPackagesUsed(coll);
        }
        return coll;
    }

    public void load(Locale locale) throws IOException {
        for (PkgRes child : this.children) {
            child.load(locale);
        }
        this.props = new SortedProp();
        String file = this.res.propFilePath(locale);
        if (file != null) {
            file = "java" + File.separatorChar + file;
            try {
                FileInputStream inStream = new FileInputStream(file);
                this.props.load(inStream);
                ((InputStream)inStream).close();
            }
            catch (FileNotFoundException excep) {
                System.err.println("File not found: " + file);
            }
        }
        this.computeSize();
    }

    public void save(Locale locale) throws IOException {
        String file = this.res.propFilePath(locale);
        if (file != null) {
            FileOutputStream outStream = new FileOutputStream("java" + File.separatorChar + file);
            this.props.store(outStream, PROPS_HEADER);
            ((OutputStream)outStream).close();
        }
        for (PkgRes child : this.children) {
            child.save(locale);
        }
    }

    public HashSet<String> getAllKeys() {
        HashSet<String> allKeys = new HashSet<String>(this.keys);
        this.getAllKeys(allKeys);
        return allKeys;
    }

    private void getAllKeys(HashSet<String> allKeys) {
        allKeys.addAll(this.keys);
        for (PkgRes child : this.children) {
            child.getAllKeys(allKeys);
        }
    }

    public ResEntry[] getResources() {
        return this.getResources(new HashSet<String>());
    }

    private ResEntry[] getResources(HashSet<String> alreadySeen) {
        ResEntry[] result = new ResEntry[this.getNumResources()];
        int pos = 0;
        ResEntry[] orig = this.res.getContents();
        String pkgName = this.res.getKeyPrefix();
        for (int i = 0; i < orig.length; ++i) {
            result[i] = orig[i].repackage(pkgName);
            if (alreadySeen.add(result[i].key)) continue;
            throw new RuntimeException("Duplicate key " + result[i].key);
        }
        pos += orig.length;
        for (PkgRes child : this.children) {
            int numChildRes = child.getNumResources();
            System.arraycopy(child.getResources(alreadySeen), 0, result, pos, numChildRes);
            pos += numChildRes;
        }
        return result;
    }

    public int getNumResources() {
        int len = this.res.getContents().length;
        for (PkgRes child : this.children) {
            len += child.getNumResources();
        }
        return len;
    }

    public boolean put(String key, String value) {
        if (this.keys.contains(key)) {
            this.props.put(key, value);
            this.computeSize();
            return true;
        }
        for (PkgRes child : this.children) {
            if (!child.put(key, value)) continue;
            this.computeSize();
            return true;
        }
        return false;
    }

    public String get(String key) {
        Object result = this.props.get(key);
        if (result != null) {
            return (String)result;
        }
        for (PkgRes child : this.children) {
            result = child.get(key);
            if (result == null) continue;
            return (String)result;
        }
        return null;
    }

    public void remove(String key) {
        this.props.remove(key);
        for (PkgRes child : this.children) {
            child.remove(key);
        }
        this.computeSize();
    }

    public int getSize() {
        return this.totalSize;
    }

    private void computeSize() {
        this.totalSize = this.props.size();
        for (PkgRes child : this.children) {
            this.totalSize += child.totalSize;
        }
    }
}

