/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.boards;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import org.diylc.common.HorizontalAlignment;
import org.diylc.common.ObjectCache;
import org.diylc.common.VerticalAlignment;
import org.diylc.components.AbstractComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.BomPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;

@ComponentDescriptor(name="Breadboard", category="Boards", author="Branislav Stojkovic", description="Prototyping solderless breadboard", instanceNamePrefix="BB", stretchable=false, zOrder=2.0, bomPolicy=BomPolicy.SHOW_ONLY_TYPE_NAME, autoEdit=false)
public class Breadboard
extends AbstractComponent<Void> {
    private static final long serialVersionUID = 1L;
    public static Color FILL_COLOR = Color.white;
    public static Color BORDER_COLOR = Color.black;
    public static Size BODY_ARC = new Size(Double.valueOf(3.0), SizeUnit.mm);
    public static Color SELECTION_COLOR = Color.red;
    public static Color HOLE_COLOR = Color.decode("#EEEEEE");
    public static Color PLUS_COLOR = Color.red;
    public static Color MINUS_COLOR = Color.blue;
    public static float COORDINATE_FONT_SIZE = 9.0f;
    public static Color COORDINATE_COLOR = Color.gray.brighter();
    public static Size HOLE_SIZE = new Size(Double.valueOf(1.5), SizeUnit.mm);
    public static Size HOLE_ARC = new Size(Double.valueOf(1.0), SizeUnit.mm);
    protected Point point = new Point(0, 0);

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        int y;
        double offset;
        int section;
        if (this.checkPointsClipped(g2d.getClip())) {
            return;
        }
        int bodyArc = (int)BODY_ARC.convertToPixels();
        double spacing = project.getGridSpacing().convertToPixels();
        g2d.setColor(FILL_COLOR);
        int width = (int)(23.0 * project.getGridSpacing().convertToPixels());
        int height = (int)(31.0 * project.getGridSpacing().convertToPixels());
        g2d.fillRoundRect(this.point.x, this.point.y, width, height, bodyArc, bodyArc);
        g2d.setColor(componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : BORDER_COLOR);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1));
        g2d.drawRoundRect(this.point.x, this.point.y, width, height, bodyArc, bodyArc);
        drawingObserver.stopTracking();
        g2d.setColor(PLUS_COLOR);
        g2d.drawLine((int)((double)this.point.x + spacing), (int)((double)this.point.y + spacing), (int)((double)this.point.x + spacing), (int)((double)this.point.y + 30.0 * spacing));
        g2d.drawLine((int)((double)this.point.x + 19.0 * spacing), (int)((double)this.point.y + spacing), (int)((double)this.point.x + 19.0 * spacing), (int)((double)this.point.y + 30.0 * spacing));
        g2d.setColor(MINUS_COLOR);
        g2d.drawLine((int)((double)this.point.x + 4.0 * spacing), (int)((double)this.point.y + spacing), (int)((double)this.point.x + 4.0 * spacing), (int)((double)this.point.y + 30.0 * spacing));
        g2d.drawLine((int)((double)this.point.x + 22.0 * spacing), (int)((double)this.point.y + spacing), (int)((double)this.point.x + 22.0 * spacing), (int)((double)this.point.y + 30.0 * spacing));
        int holeSize = this.getClosestOdd(HOLE_SIZE.convertToPixels());
        int holeArc = (int)HOLE_ARC.convertToPixels();
        g2d.setFont(LABEL_FONT.deriveFont(COORDINATE_FONT_SIZE));
        byte a = "a".getBytes()[0];
        for (section = 0; section <= 1; ++section) {
            offset = (double)(section * 7) * spacing;
            for (y = 0; y < 30; ++y) {
                g2d.setColor(COORDINATE_COLOR);
                int coordinateX = section == 0 ? (int)((double)this.point.x + offset + 5.5 * spacing) : (int)((double)this.point.x + offset + 10.5 * spacing);
                this.drawCenteredText(g2d, new Integer(y + 1).toString(), coordinateX, (int)((double)this.point.y + (double)(y + 1) * spacing), section == 0 ? HorizontalAlignment.RIGHT : HorizontalAlignment.LEFT, VerticalAlignment.CENTER);
                for (int x = 0; x < 5; ++x) {
                    int holeX = (int)((double)this.point.x + offset + (double)(x + 6) * spacing);
                    int holeY = (int)((double)this.point.y + (double)(y + 1) * spacing);
                    g2d.setColor(HOLE_COLOR);
                    g2d.fillRoundRect(holeX - holeSize / 2, holeY - holeSize / 2, holeSize, holeSize, holeArc, holeArc);
                    g2d.setColor(BORDER_COLOR);
                    g2d.drawRoundRect(holeX - holeSize / 2, holeY - holeSize / 2, holeSize, holeSize, holeArc, holeArc);
                    if (y != 0) continue;
                    g2d.setColor(COORDINATE_COLOR);
                    this.drawCenteredText(g2d, new String(new byte[]{(byte)(a + x + 5 * section)}), holeX, this.point.y, HorizontalAlignment.CENTER, VerticalAlignment.TOP);
                    this.drawCenteredText(g2d, new String(new byte[]{(byte)(a + x + 5 * section)}), holeX, (int)((double)this.point.y + spacing * 30.0 + (double)(COORDINATE_FONT_SIZE / 2.0f)), HorizontalAlignment.CENTER, VerticalAlignment.TOP);
                }
            }
        }
        for (section = 0; section <= 1; ++section) {
            offset = (double)(section * 18) * spacing;
            for (y = 0; y < 30; ++y) {
                for (int x = 0; x < 2; ++x) {
                    if ((y + 1) % 5 == 0) continue;
                    int holeX = (int)((double)this.point.x + offset + (double)(x + 2) * spacing);
                    int holeY = (int)((double)this.point.y + ((double)(y + 1) + 0.5) * spacing);
                    g2d.setColor(HOLE_COLOR);
                    g2d.fillRoundRect(holeX - holeSize / 2, holeY - holeSize / 2, holeSize, holeSize, holeArc, holeArc);
                    g2d.setColor(BORDER_COLOR);
                    g2d.drawRoundRect(holeX - holeSize / 2, holeY - holeSize / 2, holeSize, holeSize, holeArc, holeArc);
                }
            }
        }
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        int factor = 32 / width;
        int arc = 4 / factor;
        g2d.setColor(FILL_COLOR);
        g2d.fillRect(2 / factor, 2 / factor, width - 4 / factor, height - 4 / factor);
        g2d.setColor(BORDER_COLOR);
        g2d.drawRect(2 / factor, 2 / factor, width - 4 / factor, height - 4 / factor);
        g2d.setColor(HOLE_COLOR);
        g2d.fillRoundRect(width / 3 - 2 / factor, width / 3 - 2 / factor, this.getClosestOdd(5.0 / (double)factor), this.getClosestOdd(5.0 / (double)factor), arc, arc);
        g2d.setColor(BORDER_COLOR);
        g2d.drawRoundRect(width / 3 - 2 / factor, width / 3 - 2 / factor, this.getClosestOdd(5.0 / (double)factor), this.getClosestOdd(5.0 / (double)factor), arc, arc);
        g2d.setColor(HOLE_COLOR);
        g2d.fillRoundRect(2 * width / 3 - 2 / factor, width / 3 - 2 / factor, this.getClosestOdd(5.0 / (double)factor), this.getClosestOdd(5.0 / (double)factor), arc, arc);
        g2d.setColor(BORDER_COLOR);
        g2d.drawRoundRect(2 * width / 3 - 2 / factor, width / 3 - 2 / factor, this.getClosestOdd(5.0 / (double)factor), this.getClosestOdd(5.0 / (double)factor), arc, arc);
        g2d.setColor(HOLE_COLOR);
        g2d.fillRoundRect(width / 3 - 2 / factor, 2 * width / 3 - 2 / factor, this.getClosestOdd(5.0 / (double)factor), this.getClosestOdd(5.0 / (double)factor), arc, arc);
        g2d.setColor(BORDER_COLOR);
        g2d.drawRoundRect(width / 3 - 2 / factor, 2 * width / 3 - 2 / factor, this.getClosestOdd(5.0 / (double)factor), this.getClosestOdd(5.0 / (double)factor), arc, arc);
        g2d.setColor(HOLE_COLOR);
        g2d.fillRoundRect(2 * width / 3 - 2 / factor, 2 * width / 3 - 2 / factor, this.getClosestOdd(5.0 / (double)factor), this.getClosestOdd(5.0 / (double)factor), arc, arc);
        g2d.setColor(BORDER_COLOR);
        g2d.drawRoundRect(2 * width / 3 - 2 / factor, 2 * width / 3 - 2 / factor, this.getClosestOdd(5.0 / (double)factor), this.getClosestOdd(5.0 / (double)factor), arc, arc);
        g2d.setColor(MINUS_COLOR);
        g2d.drawLine(width / 2, 2 / factor, width / 2, height - 4 / factor);
    }

    public int getControlPointCount() {
        return 1;
    }

    public Point getControlPoint(int index) {
        return this.point;
    }

    public boolean isControlPointSticky(int index) {
        return false;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.NEVER;
    }

    public void setControlPoint(Point point, int index) {
        this.point.setLocation(point);
    }

    public Void getValue() {
        return null;
    }

    public void setValue(Void value) {
    }

    @Deprecated
    public String getName() {
        return super.getName();
    }
}

