/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.connectivity;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.CubicCurve2D;
import org.diylc.common.ObjectCache;
import org.diylc.common.PCBLayer;
import org.diylc.components.AbstractCurvedComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.annotations.BomPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;

@ComponentDescriptor(name="Curved Trace", author="Branislav Stojkovic", category="Connectivity", instanceNamePrefix="Trace", description="Curved copper trace with two control points", zOrder=3.0, bomPolicy=BomPolicy.NEVER_SHOW, autoEdit=false)
public class CurvedTrace
extends AbstractCurvedComponent<Void> {
    private static final long serialVersionUID = 1L;
    public static Color COLOR = Color.black;
    public static Size SIZE = new Size(Double.valueOf(1.0), SizeUnit.mm);
    protected Size size = SIZE;
    private PCBLayer layer = PCBLayer._1;

    protected Color getDefaultColor() {
        return COLOR;
    }

    protected void drawCurve(CubicCurve2D curve, Graphics2D g2d, ComponentState componentState) {
        int thickness = (int)this.size.convertToPixels();
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(thickness));
        Color curveColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.color;
        g2d.setColor(curveColor);
        g2d.draw(curve);
    }

    @EditableProperty(name="Width")
    public Size getThickness() {
        return this.size;
    }

    public void setThickness(Size size) {
        this.size = size;
    }

    @EditableProperty
    public PCBLayer getLayer() {
        if (this.layer == null) {
            this.layer = PCBLayer._1;
        }
        return this.layer;
    }

    public void setLayer(PCBLayer layer) {
        this.layer = layer;
    }

    public Void getValue() {
        return null;
    }

    public void setValue(Void value) {
    }

    public Byte getAlpha() {
        return super.getAlpha();
    }

    public void setAlpha(Byte alpha) {
        super.setAlpha(alpha);
    }
}

