/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.electromechanical;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.HorizontalAlignment;
import org.diylc.common.ObjectCache;
import org.diylc.common.Orientation;
import org.diylc.common.VerticalAlignment;
import org.diylc.components.AbstractTransparentComponent;
import org.diylc.components.electromechanical.JackType;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="Cliff 1/4\" Jack", category="Electromechanical", author="Branislav Stojkovic", description="Cliff-style closed panel mount 1/4\" phono jack", stretchable=false, zOrder=4.0, instanceNamePrefix="J", autoEdit=false)
public class CliffJack1_4
extends AbstractTransparentComponent<String> {
    private static final long serialVersionUID = 1L;
    private static Size SPACING = new Size(Double.valueOf(0.3), SizeUnit.in);
    private static Size PIN_WIDTH = new Size(Double.valueOf(0.1), SizeUnit.in);
    private static Size PIN_THICKNESS = new Size(Double.valueOf(0.02), SizeUnit.in);
    private static Color BODY_COLOR = Color.decode("#666666");
    private static Color NUT_COLOR = Color.decode("#999999");
    private static Color BORDER_COLOR = Color.black;
    private static Color LABEL_COLOR = Color.white;
    private static Size BODY_WIDTH = new Size(Double.valueOf(0.75), SizeUnit.in);
    private static Size BODY_LENGTH = new Size(Double.valueOf(0.9), SizeUnit.in);
    private static Size TAIL_LENGTH = new Size(Double.valueOf(0.1), SizeUnit.in);
    private Point[] controlPoints = new Point[]{new Point(0, 0)};
    private JackType type = JackType.MONO;
    private Orientation orientation = Orientation.DEFAULT;
    private transient Shape[] body;
    private String value = "";

    public CliffJack1_4() {
        this.updateControlPoints();
    }

    private void updateControlPoints() {
        double angle;
        this.body = null;
        int x = this.controlPoints[0].x;
        int y = this.controlPoints[0].y;
        int spacing = (int)SPACING.convertToPixels();
        this.controlPoints = new Point[this.type == JackType.STEREO ? 6 : 4];
        this.controlPoints[0] = new Point(x, y);
        this.controlPoints[1] = new Point(x, y + 2 * spacing);
        this.controlPoints[2] = new Point(x + 2 * spacing, y);
        this.controlPoints[3] = new Point(x + 2 * spacing, y + 2 * spacing);
        if (this.type == JackType.STEREO) {
            this.controlPoints[4] = new Point(x + spacing, y);
            this.controlPoints[5] = new Point(x + spacing, y + 2 * spacing);
        }
        if ((angle = this.getAngle()) != 0.0) {
            AffineTransform rotation = AffineTransform.getRotateInstance(angle, x, y);
            for (int i = 1; i < this.controlPoints.length; ++i) {
                rotation.transform(this.controlPoints[i], this.controlPoints[i]);
            }
        }
    }

    private double getAngle() {
        double angle;
        switch (this.orientation) {
            case _90: {
                angle = 1.5707963267948966;
                break;
            }
            case _180: {
                angle = Math.PI;
                break;
            }
            case _270: {
                angle = 4.71238898038469;
                break;
            }
            default: {
                angle = 0.0;
            }
        }
        return angle;
    }

    public Shape[] getBody() {
        if (this.body == null) {
            this.body = new Shape[5];
            int bodyLength = (int)BODY_LENGTH.convertToPixels();
            int bodyWidth = (int)BODY_WIDTH.convertToPixels();
            int centerX = (this.controlPoints[0].x + this.controlPoints[3].x) / 2;
            int centerY = (this.controlPoints[0].y + this.controlPoints[3].y) / 2;
            this.body[0] = new Rectangle(centerX - bodyLength / 2, centerY - bodyWidth / 2, bodyLength, bodyWidth);
            int tailLength = (int)TAIL_LENGTH.convertToPixels();
            this.body[1] = new RoundRectangle2D.Double(centerX - bodyLength / 2 - tailLength, centerY - bodyWidth / 4, tailLength * 2, bodyWidth / 2, tailLength, tailLength);
            Area tailArea = new Area(this.body[1]);
            tailArea.subtract(new Area(this.body[0]));
            this.body[1] = tailArea;
            this.body[2] = new Rectangle(centerX + bodyLength / 2, centerY - bodyWidth / 4, tailLength, bodyWidth / 2);
            this.body[3] = new Rectangle(centerX + bodyLength / 2 + tailLength, centerY - bodyWidth / 4, tailLength, bodyWidth / 2);
            tailArea = new Area(this.body[3]);
            int radius = bodyLength / 2 + tailLength * 2;
            tailArea.intersect(new Area(new Ellipse2D.Double(centerX - radius, centerY - radius, radius * 2, radius * 2)));
            this.body[3] = tailArea;
            double angle = this.getAngle();
            if (angle != 0.0) {
                AffineTransform rotation = AffineTransform.getRotateInstance(angle, centerX, centerY);
                for (int i = 0; i < this.body.length; ++i) {
                    if (this.body[i] == null) continue;
                    Area area = new Area(this.body[i]);
                    area.transform(rotation);
                    this.body[i] = area;
                }
            }
            Area pins = new Area();
            int pinWidth = (int)PIN_WIDTH.convertToPixels();
            int pinThickness = (int)PIN_THICKNESS.convertToPixels();
            for (int i = 0; i < this.getControlPointCount(); ++i) {
                Point point = this.getControlPoint(i);
                Rectangle pin = this.orientation == Orientation.DEFAULT || this.orientation == Orientation._180 ? new Rectangle(point.x - pinWidth / 2, point.y - pinThickness / 2, pinWidth, pinThickness) : new Rectangle(point.x - pinThickness / 2, point.y - pinWidth / 2, pinThickness, pinWidth);
                pins.add(new Area(pin));
            }
            this.body[4] = pins;
        }
        return this.body;
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        Shape[] body = this.getBody();
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1));
        if (componentState != ComponentState.DRAGGING) {
            Composite oldComposite = g2d.getComposite();
            if (this.alpha < MAX_ALPHA) {
                g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
            }
            g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : BODY_COLOR);
            for (int i = 0; i < body.length - 1; ++i) {
                if (i == body.length - 2) {
                    g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : NUT_COLOR);
                }
                g2d.fill(body[i]);
            }
            g2d.setComposite(oldComposite);
        }
        Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
        Color finalBorderColor = outlineMode ? (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : theme.getOutlineColor()) : (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : BORDER_COLOR);
        g2d.setColor(finalBorderColor);
        for (int i = 0; i < body.length - 1; ++i) {
            g2d.draw(body[i]);
        }
        Shape pins = body[body.length - 1];
        if (!outlineMode) {
            g2d.setColor(METAL_COLOR);
            g2d.fill(pins);
        }
        g2d.setColor(outlineMode ? theme.getOutlineColor() : METAL_COLOR.darker());
        g2d.draw(pins);
        Color finalLabelColor = outlineMode ? (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : theme.getOutlineColor()) : (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : LABEL_COLOR);
        g2d.setColor(finalLabelColor);
        g2d.setFont(LABEL_FONT);
        int centerX = (this.controlPoints[0].x + this.controlPoints[3].x) / 2;
        int centerY = (this.controlPoints[0].y + this.controlPoints[3].y) / 2;
        this.drawCenteredText(g2d, this.name, centerX, centerY, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        int bodyWidth = this.getClosestOdd(width * 3 / 5);
        int tailWidth = this.getClosestOdd(width * 3 / 9);
        g2d.setColor(BODY_COLOR);
        g2d.fillRoundRect((width - tailWidth) / 2, height / 2, tailWidth, height / 2 - 64 / height, 128 / width, 128 / width);
        g2d.setColor(BORDER_COLOR);
        g2d.drawRoundRect((width - tailWidth) / 2, height / 2, tailWidth, height / 2 - 64 / height, 128 / width, 128 / width);
        g2d.setColor(NUT_COLOR);
        g2d.fillRoundRect((width - tailWidth) / 2, 64 / height, tailWidth, height / 2, 128 / width, 128 / width);
        g2d.setColor(BORDER_COLOR);
        g2d.drawRoundRect((width - tailWidth) / 2, 64 / height, tailWidth, height / 2, 128 / width, 128 / width);
        g2d.setColor(BODY_COLOR);
        g2d.fillRect((width - bodyWidth) / 2, height / 7 + 1, bodyWidth, height * 5 / 7);
        g2d.setColor(BORDER_COLOR);
        g2d.drawRect((width - bodyWidth) / 2, height / 7 + 1, bodyWidth, height * 5 / 7);
        g2d.setColor(METAL_COLOR);
        int pinX1 = this.getClosestOdd((width - bodyWidth * 3 / 4) / 2);
        int pinX2 = this.getClosestOdd((width + bodyWidth * 3 / 4) / 2) - 1;
        g2d.drawLine(pinX1, width * 2 / 8, pinX1, width * 3 / 8);
        g2d.drawLine(pinX1, width * 5 / 8, pinX1, width * 6 / 8);
        g2d.drawLine(pinX2, width * 2 / 8, pinX2, width * 3 / 8);
        g2d.drawLine(pinX2, width * 5 / 8, pinX2, width * 6 / 8);
    }

    public int getControlPointCount() {
        return this.controlPoints.length;
    }

    public Point getControlPoint(int index) {
        return this.controlPoints[index];
    }

    public void setControlPoint(Point point, int index) {
        this.controlPoints[index].setLocation(point);
        this.body = null;
    }

    public boolean isControlPointSticky(int index) {
        return true;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.NEVER;
    }

    @EditableProperty
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @EditableProperty
    public JackType getType() {
        return this.type;
    }

    public void setType(JackType type) {
        this.type = type;
        this.updateControlPoints();
    }

    @EditableProperty
    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.updateControlPoints();
    }
}

